/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.update;

import com.kms.katalon.composer.components.impl.util.PlatformUtil;
import com.kms.katalon.composer.update.UpdateComponent;
import com.kms.katalon.composer.update.UpdateManager;
import com.kms.katalon.composer.update.models.ExecInfo;
import java.io.File;
import java.io.IOException;
import org.eclipse.jdt.launching.JavaRuntime;

public class UpdaterLauncher
implements UpdateComponent {
    private static final String[] CANDIDATES_JAVA_FILES = new String[]{"java", "java.exe"};
    private static final String[] CANDIDATE_JAVA_LOCATIONS = new String[]{"bin" + File.separatorChar, "jre" + File.separatorChar + "bin" + File.separatorChar};
    private String javaExecFile;
    private String updateJarFile;
    private String appDir;
    private String katalonExecFile;
    private String latestVersionDir;
    private String latestVersion;
    private String currentVersion;

    public UpdaterLauncher(String latestVersion, String currentVersion) throws IOException {
        UpdateManager updateManager = this.getUpdateManager();
        this.javaExecFile = this.getInstalledJRE();
        this.updateJarFile = updateManager.getUpdateJar().getAbsolutePath();
        this.appDir = updateManager.getApplicationDir().getAbsolutePath();
        this.katalonExecFile = updateManager.getApplicationExecFile().getAbsolutePath();
        this.latestVersionDir = updateManager.getVersionUpdateDir(latestVersion).getAbsolutePath();
        this.latestVersion = latestVersion;
        this.currentVersion = currentVersion;
    }

    public void startUpdaterLauncher() throws IOException, InterruptedException {
        ExecInfo execInfo = new ExecInfo();
        execInfo.setAppDir(this.appDir);
        execInfo.setExecFile(this.katalonExecFile);
        execInfo.setLatestVersionDir(this.latestVersionDir);
        execInfo.setLatestVersion(this.latestVersion);
        execInfo.setCurrentVersion(this.currentVersion);
        this.getUpdateManager().saveExecInfo(execInfo);
        String javaExec = PlatformUtil.isWindows() ? "java" : "./java";
        String[] commands = new String[]{javaExec, "-jar", this.updateJarFile};
        new File(this.updateJarFile).setReadable(true);
        new File(this.updateJarFile).setWritable(true);
        new File(this.updateJarFile).setExecutable(true);
        ProcessBuilder builder = new ProcessBuilder(commands).directory(new File(this.javaExecFile).getParentFile());
        Process p = builder.start();
        p.waitFor();
    }

    private String getInstalledJRE() {
        File vmInstallLocation = JavaRuntime.getDefaultVMInstall().getInstallLocation();
        int i = 0;
        while (i < CANDIDATES_JAVA_FILES.length) {
            int j = 0;
            while (j < CANDIDATE_JAVA_LOCATIONS.length) {
                File javaFile = new File(vmInstallLocation, String.valueOf(CANDIDATE_JAVA_LOCATIONS[j]) + CANDIDATES_JAVA_FILES[i]);
                if (javaFile.isFile()) {
                    return javaFile.getAbsolutePath();
                }
                ++j;
            }
            ++i;
        }
        return "java";
    }
}

