/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.update.dialogs;

import com.kms.katalon.composer.components.impl.dialogs.AbstractDialog;
import com.kms.katalon.composer.components.util.ComponentBuilder;
import com.kms.katalon.composer.components.util.ComponentUtil;
import com.kms.katalon.constants.MessageConstants;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public class NewUpdateDialog
extends AbstractDialog {
    public static final int DOWNLOAD_ID = 1025;
    public static final int REMIND_LATER_ID = 1026;
    public static final int IGNORE_UPDATE_ID = 1027;
    private String currentVersion;
    private String newVersion;
    private String releaseNotesLink;
    private boolean forceUpdate;

    public NewUpdateDialog(Shell parentShell, String currentVersion, String newVersion, String releaseNotesLink, boolean forceUpdate) {
        super(parentShell);
        this.currentVersion = currentVersion;
        this.newVersion = newVersion;
        this.releaseNotesLink = releaseNotesLink;
        this.forceUpdate = forceUpdate;
    }

    protected Control createDialogContainer(Composite parent) {
        Composite container = (Composite)ComponentBuilder.gridContainer((Composite)parent).fillHorizontal().build();
        Composite currentVersionContainer = (Composite)ComponentBuilder.gridContainer((Composite)container, (int)2, (boolean)true).margin(ComponentUtil.applyZoom((int)20)).marginBottom(ComponentUtil.applyZoom((int)10)).fillHorizontal().build();
        ComponentBuilder.label((Composite)currentVersionContainer).text(MessageConstants.LBL_CURRENT_VERSION).textLeft().fillHorizontal().build();
        ComponentBuilder.label((Composite)currentVersionContainer).text(this.currentVersion).textLeft().fillHorizontal().build();
        Composite newVersionContainer = (Composite)ComponentBuilder.gridContainer((Composite)container, (int)2, (boolean)true).marginLeft(ComponentUtil.applyZoom((int)20)).marginRight(ComponentUtil.applyZoom((int)20)).marginBottom(ComponentUtil.applyZoom((int)20)).fillHorizontal().build();
        ComponentBuilder.label((Composite)newVersionContainer).text(MessageConstants.LBL_NEW_VERSION).textLeft().fillHorizontal().build();
        Composite newVersionDetailContainer = (Composite)ComponentBuilder.gridContainer((Composite)newVersionContainer, (int)2).build();
        ComponentBuilder.label((Composite)newVersionDetailContainer).text(this.newVersion).textLeft().fillHorizontal().build();
        ComponentBuilder.link((Composite)newVersionDetailContainer).linkTo(MessageConstants.LBL_LINK_RELEASE_NOTES, this.releaseNotesLink).fillHorizontal().build();
        return container;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 1025, MessageConstants.BTN_DOWNLOAD, true);
        if (!this.forceUpdate) {
            this.createButton(parent, 1026, MessageConstants.BTN_REMIND_ME_LATER, false);
            this.createButton(parent, 1027, MessageConstants.BTN_IGNORE_THIS_UPDATE, false);
        }
    }

    public String getDialogTitle() {
        return MessageConstants.DIALOG_TITLE_KATALON_STUDIO_NEW_UPDATE;
    }

    protected void buttonPressed(int buttonId) {
        super.buttonPressed(buttonId);
        this.setReturnCode(buttonId);
        if (!this.forceUpdate) {
            super.close();
        } else {
            Program.launch((String)MessageConstants.URL_KATALON_DOWNLOAD);
        }
    }

    protected void setInput() {
    }

    protected void registerControlModifyListeners() {
    }
}

