/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.core.application;

import com.kms.katalon.activation.dialog.ExpiredLicenseDialog;
import com.kms.katalon.application.utils.ActivationInfoCollector;
import com.kms.katalon.application.utils.ApplicationContext;
import com.kms.katalon.application.utils.ApplicationInfo;
import com.kms.katalon.application.utils.VersionUtil;
import com.kms.katalon.composer.components.event.EventBrokerSingleton;
import com.kms.katalon.composer.components.services.UISynchronizeService;
import com.kms.katalon.composer.components.util.UITimeUtil;
import com.kms.katalon.composer.handlers.DeactivateHandler;
import com.kms.katalon.composer.handlers.IdleTimeoutHandler;
import com.kms.katalon.composer.update.UpdateManager;
import com.kms.katalon.composer.update.dialogs.NewUpdateDialog;
import com.kms.katalon.composer.update.models.LastestVersionInfo;
import com.kms.katalon.core.model.KatalonEdition;
import com.kms.katalon.core.util.ApplicationEdition;
import com.kms.katalon.core.util.TimeUtil;
import com.kms.katalon.feature.TestOpsMessageError;
import com.kms.katalon.integration.analytics.providers.HttpClientUtils;
import com.kms.katalon.logging.LogUtil;
import com.kms.katalon.tracking.service.Trackings;
import com.kms.katalon.util.ComposerActivationInfoCollector;
import java.net.URL;
import java.util.Timer;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;

public class ApplicationStaupHandler {
    private static final long LOG_OUT_AFTER_MILISECONDS = 300000L;
    private static Timer logoutTimer;
    private static String lastActivateErrorMessage;

    public static boolean checkActivation(boolean isStartup) throws Exception {
        if (!isStartup) {
            TimeUtil.cancel((Timer)logoutTimer);
        } else if (KatalonEdition.FREE == ApplicationEdition.get() && ApplicationStaupHandler.needToUpdateNewVersion()) {
            PlatformUI.getWorkbench().close();
            return false;
        }
        if (!ComposerActivationInfoCollector.checkActivation(isStartup)) {
            EventBrokerSingleton.getInstance().getEventBroker().send("PROJECT/CLOSE", null);
            PlatformUI.getWorkbench().close();
            return false;
        }
        ApplicationStaupHandler.scheduleCheckLicense();
        try {
            Trackings.trackOpenApplication((boolean)false, (String)"gui");
        }
        catch (Exception exception) {}
        return true;
    }

    private static void scheduleCheckLicense() {
        lastActivateErrorMessage = ActivationInfoCollector.DEFAULT_REASON;
        ActivationInfoCollector.scheduleCheckLicense(() -> UISynchronizeService.syncExec(() -> {
            ApplicationContext appContext = ApplicationContext.getInstance();
            if (!appContext.isLogoutAck()) {
                IdleTimeoutHandler.getInstance().stopCountingDown();
                ExpiredLicenseDialog expiredDialog = new ExpiredLicenseDialog(Display.getCurrent().getActiveShell(), lastActivateErrorMessage);
                appContext.setLogoutAck(true);
                expiredDialog.open();
                ApplicationStaupHandler.logoutKSAfter(300000L);
            }
        }), () -> {
            TestOpsMessageError errorMessage = new TestOpsMessageError();
            ActivationInfoCollector.checkAndMarkActivatedForGUIMode((TestOpsMessageError)errorMessage);
            String error = errorMessage.getMessage();
            if (StringUtils.isNotBlank((CharSequence)error)) {
                lastActivateErrorMessage = error;
                LogUtil.printErrorLine((String)error);
            }
        });
    }

    private static void logoutKSAfter(long miliseconds) {
        TimeUtil.cancel((Timer)logoutTimer);
        logoutTimer = UITimeUtil.setTimeout(() -> UISynchronizeService.syncExec(() -> new DeactivateHandler().execute()), (long)miliseconds);
    }

    private static boolean needToUpdateNewVersion() {
        try {
            UpdateManager updateManager = UpdateManager.getInstance();
            URL url = new URL(updateManager.getLatestVersionUrl());
            URIBuilder uriBuilder = new URIBuilder(url.toURI());
            HttpGet httpGet = new HttpGet(uriBuilder.build());
            LastestVersionInfo lastestUpdateVersion = (LastestVersionInfo)HttpClientUtils.executeRequest((HttpUriRequest)httpGet, LastestVersionInfo.class);
            String latestVersion = lastestUpdateVersion.getLatestVersion();
            String currentVersion = ApplicationInfo.officialReleaseVersion();
            if (VersionUtil.isNewer((String)latestVersion, (String)currentVersion)) {
                LogUtil.logInfo((String)String.format("The current version %s is old, need to update to the latest version %s", currentVersion, latestVersion));
                new NewUpdateDialog(Display.getCurrent().getActiveShell(), currentVersion, latestVersion, lastestUpdateVersion.getReleaseNotesLink(), true).open();
                return true;
            }
        }
        catch (Exception e) {
            LogUtil.logInfo((String)("Unable to check for new release version. Exception details: " + e.getMessage()));
        }
        return false;
    }
}

