/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.webserver;

import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.core.util.internal.JsonUtil;
import com.sun.net.httpserver.HttpExchange;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.URI;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.NameValuePair;
import org.apache.http.client.utils.URLEncodedUtils;
import org.json.JSONObject;

public class CustomRequest {
    protected HttpExchange req;
    protected OutputStream res;
    protected Map<String, Object> requestObject = new HashMap<String, Object>();

    public CustomRequest(HttpExchange req) {
        this.req = req;
        this.res = req.getResponseBody();
    }

    public String getMethod() {
        return this.req.getRequestMethod();
    }

    public URI getURI() {
        return this.req.getRequestURI();
    }

    public String query(String param) {
        List<NameValuePair> params = this.query();
        NameValuePair foundParam = params.stream().filter(paramI -> StringUtils.equals((CharSequence)paramI.getName(), (CharSequence)param)).findFirst().orElse(null);
        return foundParam != null ? foundParam.getValue() : null;
    }

    public List<NameValuePair> query() {
        return URLEncodedUtils.parse((URI)this.req.getRequestURI(), (String)"UTF-8");
    }

    public void setHeader(String name, Object value) {
        this.req.getResponseHeaders().set(name, value.toString());
    }

    public void end() {
        this.end(200);
    }

    public void end(int httpCode) {
        try {
            this.send(httpCode);
        }
        catch (IOException iOException) {}
    }

    public void send(Object content) throws IOException {
        this.send(200, content);
    }

    public void send(int httpCode, Object content) throws IOException {
        byte[] bytes = null;
        if (content != null) {
            if (content instanceof String) {
                bytes = ((String)content).getBytes();
            } else if (content instanceof byte[]) {
                bytes = (byte[])content;
            } else {
                String rawJson = JsonUtil.toJson((Object)content, (boolean)false);
                bytes = rawJson != null ? rawJson.getBytes() : null;
                this.setHeader("Content-Type", "application/json");
            }
        }
        this.sendResponseHeaders(httpCode, bytes != null ? bytes.length : 0);
        if (bytes != null) {
            this.res.write(bytes);
        }
        this.res.close();
    }

    public void sendResponseHeaders(int httpCode, int length) throws IOException {
        this.req.sendResponseHeaders(httpCode, length);
    }

    public Map<String, Object> getRequestObject() {
        try {
            JSONObject jsonObject = this.getRequestData();
            int numOfStars = jsonObject.getInt("numOfStars");
            String feedback = jsonObject.getString("feedback");
            this.requestObject.put("numOfStars", numOfStars);
            this.requestObject.put("feedback", feedback);
            return this.requestObject;
        }
        catch (IOException error) {
            LoggerSingleton.logError((Throwable)error);
            return null;
        }
    }

    protected JSONObject getRequestData() throws IOException {
        String line;
        InputStreamReader isr = new InputStreamReader(this.req.getRequestBody());
        BufferedReader br = new BufferedReader(isr);
        StringBuilder requestData = new StringBuilder();
        while ((line = br.readLine()) != null) {
            requestData.append(line);
        }
        return new JSONObject(requestData.toString());
    }
}

