/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.webserver;

import com.kms.katalon.composer.components.services.UISynchronizeService;
import com.kms.katalon.composer.helpers.SSOController;
import com.kms.katalon.core.util.EncodingUtil;
import com.kms.katalon.logging.LogUtil;
import com.kms.katalon.webserver.WebViewServer;
import com.kms.katalon.webserver.handlers.EmailTemplateHandler;
import com.kms.katalon.webserver.handlers.KatalonActionHandler;
import com.kms.katalon.webserver.handlers.KatalonContentHandler;
import com.kms.katalon.webserver.handlers.KatalonInfoHandler;
import com.kms.katalon.webserver.handlers.KatalonTrackingHandler;
import com.kms.katalon.webserver.handlers.SSOAuthHandler;
import com.kms.katalon.webserver.handlers.StaticFileHandler;
import com.kms.katalon.webserver.handlers.TestOpsProjectInfoHandler;
import java.io.IOException;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.text.MessageFormat;

public class WebViewController {
    private static final String DEFAULT_WEBVIEW_BUILD_DIR = "resources/webview";
    private static WebViewController _instance;
    private WebViewServer webViewServer;

    public WebViewServer getWebViewServer() {
        return this.webViewServer;
    }

    public static WebViewController getInstance() {
        if (_instance == null) {
            _instance = new WebViewController();
        }
        return _instance;
    }

    private WebViewController() {
    }

    public void startAsync() {
        UISynchronizeService.asyncExec(() -> this.start());
    }

    public void start() {
        try {
            this.webViewServer = new WebViewServer().create().use("/auth", new SSOAuthHandler()).use("/content", new KatalonContentHandler()).use("/info", new KatalonInfoHandler()).use("/template", new EmailTemplateHandler()).use("/action", new KatalonActionHandler()).use("/tracking", new KatalonTrackingHandler()).use("/testOpsProjectInfo", new TestOpsProjectInfoHandler()).use("/", new StaticFileHandler(DEFAULT_WEBVIEW_BUILD_DIR)).start();
            SSOController.getInstance().setRedirectServer(this.getPage(""));
        }
        catch (IOException | KeyManagementException | KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException | CertificateException error) {
            LogUtil.logError((Throwable)error);
        }
    }

    public void ensureStarted() {
        if (this.webViewServer == null || !this.webViewServer.isStarted()) {
            this.start();
        }
    }

    public void stop() {
        this.webViewServer.stop();
    }

    public void stopAsync() {
        this.webViewServer.stopAsync();
    }

    public String getHost() {
        return this.webViewServer.getHost();
    }

    public String getPage(String path) {
        return MessageFormat.format("http://{0}/{1}", this.getHost(), path);
    }

    public String getMultiMediaPage(String mediaUrl) {
        return MessageFormat.format("{0}?url={1}", this.getPage("MultiMedia.html"), EncodingUtil.encodeURIComponent((String)mediaUrl));
    }
}

