/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.webserver.handlers;

import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.execution.setting.EmailSettingStore;
import com.kms.katalon.execution.util.EmailTemplateUtil;
import com.kms.katalon.webserver.CustomHttpHandler;
import com.kms.katalon.webserver.CustomRequest;
import com.kms.katalon.webserver.types.HTMLEmailTemplate;
import java.io.IOException;

public class EmailTemplateHandler
extends CustomHttpHandler {
    private EmailSettingStore settingStore;

    @Override
    public void customHandle(CustomRequest req) throws IOException {
        this.settingStore = new EmailSettingStore(ProjectController.getInstance().getCurrentProject());
        String rawRequestedTemplate = req.query("type");
        boolean isSetDefaults = Boolean.parseBoolean(req.query("setDefaults"));
        HTMLEmailTemplate requestedTemplate = HTMLEmailTemplate.valueOf(rawRequestedTemplate);
        switch (requestedTemplate) {
            case TEST_SUITE: {
                req.send(this.getEmailHTMLTemplateForTS(isSetDefaults));
                break;
            }
            case TEST_SUITE_COLLECTION: {
                req.send(this.getEmailHTMLTemplateForTSC(isSetDefaults));
                break;
            }
        }
        req.end();
    }

    private String getEmailHTMLTemplateForTS(boolean isSetDefaults) {
        try {
            if (isSetDefaults) {
                return EmailTemplateUtil.getHTMLTemplateForTestSuite();
            }
            return this.settingStore.getEmailHTMLTemplateForTestSuite();
        }
        catch (Exception e) {
            LoggerSingleton.logError((Throwable)e);
            return "";
        }
    }

    private String getEmailHTMLTemplateForTSC(boolean isSetDefaults) {
        try {
            if (isSetDefaults) {
                return EmailTemplateUtil.getEmailHTMLTemplateForTestSuiteCollection();
            }
            return this.settingStore.getEmailHTMLTemplateForTestSuiteCollection();
        }
        catch (Exception e) {
            LoggerSingleton.logError((Throwable)e);
            return "";
        }
    }
}

