/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.webserver.handlers;

import com.kms.katalon.application.utils.ApplicationInfo;
import com.kms.katalon.composer.components.services.UISynchronizeService;
import com.kms.katalon.composer.components.util.DialogUtil;
import com.kms.katalon.composer.components.util.ShellManager;
import com.kms.katalon.composer.helpers.SSOController;
import com.kms.katalon.integration.analytics.exceptions.AnalyticsApiException;
import com.kms.katalon.logging.LogUtil;
import com.kms.katalon.webserver.CustomHttpHandler;
import com.kms.katalon.webserver.CustomRequest;
import java.io.IOException;
import java.net.URISyntaxException;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.swt.widgets.Shell;

public class SSOAuthHandler
extends CustomHttpHandler {
    @Override
    public void customHandle(CustomRequest req) throws IOException {
        UISynchronizeService.syncExec(() -> DialogUtil.activateShell((Shell)ShellManager.getMainShell()));
        String context = req.query("context");
        if (StringUtils.equalsAny((CharSequence)context, (CharSequence[])new CharSequence[]{"LOGIN", "REGISTER,LOGIN"})) {
            this.handleLogin(req);
        }
    }

    private void handleLogin(CustomRequest req) throws IOException {
        String code = req.query("code");
        String idpType = req.query("idp_type");
        String subDomain = req.query("sub_domain");
        String message = "Authenticate successfully.\r\nYou can close this page and return to Katalon Studio IDE.";
        String html = this.generateCallbackPage(message, "LOGIN");
        req.send(200, html);
        req.end();
        ApplicationInfo.clearAuthenticationType();
        ApplicationInfo.clearAuthenticationSubDomain();
        if (StringUtils.isNotBlank((CharSequence)code)) {
            SSOController controller = SSOController.getInstance();
            controller.notifyCodeGrabbed(code);
            try {
                String token = controller.grabTokens(code);
                ApplicationInfo.setAuthenticationType((String)idpType);
                ApplicationInfo.setAuthenticationSubDomain((String)subDomain);
                controller.notifyTokenGrabbed(token);
            }
            catch (AnalyticsApiException | URISyntaxException error) {
                LogUtil.logError((Throwable)error);
                try {
                    controller.rollbackFailedSSOLogin();
                }
                catch (AnalyticsApiException rollbackError) {
                    LogUtil.logError((Throwable)rollbackError);
                }
                controller.notifyTokenError((Exception)error);
            }
        }
    }

    private String generateCallbackPage(String message, String context) {
        String image = "/sso/authenticated.png";
        String html = "<body>\n    <style>\n    .auth-container {\n        position: fixed;\n        width: 100%;\n        height: 100%;\n        left: 0;\n        top: 0;\n        display: flex;\n        justify-content: center;\n        align-items: center;\n        flex-direction: column;\n        margin-top: -5%;\n    }\n    .auth-image {\n        width: 10rem;\n    }\n    .auth-message {\n        font-family: sans-serif;\n        font-size: 1.7rem;\n        white-space: pre-wrap;\n        text-align: center;\n        margin-top: 3rem;\n    }\n    </style>\n    <div class=\"auth-container\">\n        <img src=\"{image}\" class=\"auth-image\">\n        <div class=\"auth-message\">{message}</div>\n    </div>\n    <script>\n        window.close();\n        var url = new URL(location.href);\n        var simpleUrl = `${url.origin}${url.pathname}?context={context}`;\n        history.replaceState(null, \"\", simpleUrl);\n    </script>\n</body>\n".replace("{message}", message).replace("{image}", image).replace("{context}", context);
        return html;
    }
}

