/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.webview.util;

import com.kms.katalon.application.utils.ActivationInfoCollector;
import com.kms.katalon.application.utils.ApplicationInfo;
import com.kms.katalon.core.model.KatalonPackage;
import com.kms.katalon.core.util.JsonBuilder;
import com.kms.katalon.integration.analytics.exceptions.AnalyticsApiException;
import com.kms.katalon.integration.analytics.providers.TestOpsService;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

public class WebviewLicenseUtil {
    private static Long orgId;

    public static String getLicenseExpirationDate() throws GeneralSecurityException, IOException, AnalyticsApiException, ParseException {
        orgId = ApplicationInfo.getOrganization().getId();
        String kseLicenseExpirationDate = WebviewLicenseUtil.getKSELicenseExpirationDate();
        String kreLicenseExpirationDate = WebviewLicenseUtil.getKRELicenseExpirationDate();
        return WebviewLicenseUtil.parseLicenseExpirationDateToJson(kseLicenseExpirationDate, kreLicenseExpirationDate);
    }

    private static String parseLicenseExpirationDateToJson(String kse, String kre) {
        JsonBuilder jsonBuilder = JsonBuilder.object();
        if (kse != null) {
            jsonBuilder.property("KSE", (Object)kse);
        }
        if (kre != null) {
            jsonBuilder.property("KRE", (Object)kre);
        }
        return jsonBuilder.toJson();
    }

    private static String getKRELicenseExpirationDate() throws AnalyticsApiException {
        String kreLicenseExpirationDate = null;
        Date date = TestOpsService.getInstance().getExpirationOnline(orgId, KatalonPackage.ENGINE);
        if (date != null) {
            kreLicenseExpirationDate = WebviewLicenseUtil.formatDate(date);
        }
        return kreLicenseExpirationDate;
    }

    private static String formatDate(Date date) {
        SimpleDateFormat formatter = new SimpleDateFormat("MMMMM dd, yyyy");
        return formatter.format(date);
    }

    private static String getKSELicenseExpirationDate() throws ParseException, GeneralSecurityException, IOException, AnalyticsApiException {
        if (ActivationInfoCollector.isLicenseOffline()) {
            String offlineLicenseDate = ActivationInfoCollector.getExpirationDate();
            offlineLicenseDate = offlineLicenseDate.substring(0, offlineLicenseDate.length() - 6);
            return offlineLicenseDate;
        }
        String kseLicenseExpirationDate = null;
        Date date = TestOpsService.getInstance().getExpirationOnline(orgId);
        if (date != null) {
            kseLicenseExpirationDate = WebviewLicenseUtil.formatDate(date);
        }
        if (kseLicenseExpirationDate == null && ActivationInfoCollector.getExpirationDate() != null) {
            kseLicenseExpirationDate = ActivationInfoCollector.getExpirationDate().substring(0, ActivationInfoCollector.getExpirationDate().length() - 6);
        }
        return kseLicenseExpirationDate;
    }
}

