/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.integration.analytics.handler;

import com.kms.katalon.application.KatalonApplicationActivator;
import com.kms.katalon.entity.integration.analytics.AnalyticsOrganization;
import com.kms.katalon.integration.analytics.constants.IntegrationAnalyticsMessages;
import com.kms.katalon.integration.analytics.entity.AnalyticsProject;
import com.kms.katalon.integration.analytics.entity.AnalyticsTeam;
import com.kms.katalon.integration.analytics.entity.AnalyticsTestProject;
import com.kms.katalon.integration.analytics.entity.AnalyticsTokenInfo;
import com.kms.katalon.integration.analytics.entity.GitRepositoryEntity;
import com.kms.katalon.integration.analytics.exceptions.AnalyticsApiException;
import com.kms.katalon.integration.analytics.providers.TestOpsService;
import com.kms.katalon.integration.analytics.setting.AnalyticsSettingStore;
import com.kms.katalon.logging.LogUtil;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;

public class AnalyticsAuthorizationHandler {
    public static String getTokenNew(TestOpsService testOpsService, AnalyticsSettingStore settingStore) {
        try {
            String token = testOpsService.requestAdminToken().getAccessToken();
            settingStore.setToken(token);
            return token;
        }
        catch (Exception ex) {
            LogUtil.logError((Throwable)ex);
            try {
                settingStore.enableIntegration(false);
            }
            catch (IOException e) {
                LogUtil.logError((Throwable)e);
            }
            return null;
        }
    }

    public static String getToken(TestOpsService testOpsService, AnalyticsSettingStore settingStore) {
        try {
            String token = testOpsService.requestAdminToken().getAccessToken();
            settingStore.setToken(token);
            return token;
        }
        catch (Exception ex) {
            LogUtil.logError((Throwable)ex);
            try {
                settingStore.enableIntegration(false);
            }
            catch (IOException e) {
                LogUtil.logError((Throwable)e);
            }
            try {
                String message = KatalonApplicationActivator.getFeatureActivator().getTestOpsMessage(ex.getMessage());
                LogUtil.logError((String)MessageFormat.format(IntegrationAnalyticsMessages.MSG_ERROR_WITH_REASON, message));
            }
            catch (Exception exception) {}
            return null;
        }
    }

    public static List<AnalyticsOrganization> getOrganizations(TestOpsService testOpsService) {
        ArrayList<AnalyticsOrganization> organizations = new ArrayList<AnalyticsOrganization>();
        try {
            List<AnalyticsOrganization> loaded = testOpsService.getOrganizations();
            if (loaded != null && !loaded.isEmpty()) {
                organizations.addAll(loaded);
            }
        }
        catch (AnalyticsApiException e) {
            LogUtil.logError((Throwable)e);
        }
        return organizations;
    }

    public static List<AnalyticsProject> getOnCloudProjects(TestOpsService testOpsService, AnalyticsOrganization org) {
        ArrayList<AnalyticsProject> projects = new ArrayList<AnalyticsProject>();
        try {
            List<AnalyticsProject> loaded = testOpsService.getOnCloudProjects(org);
            if (loaded != null && !loaded.isEmpty()) {
                projects.addAll(loaded);
            }
        }
        catch (AnalyticsApiException e) {
            LogUtil.logError((Throwable)e);
        }
        return projects;
    }

    public static List<AnalyticsProject> getOnPremProjects(TestOpsService testOpsService, AnalyticsTeam team) {
        ArrayList<AnalyticsProject> projects = new ArrayList<AnalyticsProject>();
        try {
            List<AnalyticsProject> loaded = testOpsService.getOnPremProjects(team);
            if (loaded != null && !loaded.isEmpty()) {
                projects.addAll(loaded);
            }
        }
        catch (AnalyticsApiException e) {
            LogUtil.logError((Throwable)e);
        }
        return projects;
    }

    public static List<AnalyticsProject> getCloudProjects(final TestOpsService testOpsService, final AnalyticsOrganization org, ProgressMonitorDialog monitorDialog) {
        final ArrayList<AnalyticsProject> projects = new ArrayList<AnalyticsProject>();
        try {
            monitorDialog.run(true, false, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        try {
                            monitor.beginTask(IntegrationAnalyticsMessages.MSG_DLG_PRG_RETRIEVING_PROJECTS, 2);
                            monitor.subTask(IntegrationAnalyticsMessages.MSG_DLG_PRG_GETTING_PROJECTS);
                            List<AnalyticsProject> loaded = testOpsService.getOnCloudProjects(org);
                            if (loaded != null && !loaded.isEmpty()) {
                                projects.addAll(loaded);
                            }
                            monitor.worked(1);
                        }
                        catch (Exception e) {
                            throw new InvocationTargetException(e);
                        }
                    }
                    finally {
                        monitor.done();
                    }
                }
            });
            return projects;
        }
        catch (InvocationTargetException exception) {
            Throwable cause = exception.getCause();
            if (!(cause instanceof AnalyticsApiException)) {
                LogUtil.logError((Throwable)cause);
            }
        }
        catch (InterruptedException interruptedException) {}
        return projects;
    }

    public static List<AnalyticsProject> getOnPremProjects(final TestOpsService testOpsService, final AnalyticsTeam team, ProgressMonitorDialog monitorDialog) {
        final ArrayList<AnalyticsProject> projects = new ArrayList<AnalyticsProject>();
        try {
            monitorDialog.run(true, false, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        try {
                            monitor.beginTask(IntegrationAnalyticsMessages.MSG_DLG_PRG_RETRIEVING_PROJECTS, 2);
                            monitor.subTask(IntegrationAnalyticsMessages.MSG_DLG_PRG_GETTING_PROJECTS);
                            List<AnalyticsProject> loaded = testOpsService.getOnPremProjects(team);
                            if (loaded != null && !loaded.isEmpty()) {
                                projects.addAll(loaded);
                            }
                            monitor.worked(1);
                        }
                        catch (Exception e) {
                            throw new InvocationTargetException(e);
                        }
                    }
                    finally {
                        monitor.done();
                    }
                }
            });
            return projects;
        }
        catch (InvocationTargetException exception) {
            Throwable cause = exception.getCause();
            if (!(cause instanceof AnalyticsApiException)) {
                LogUtil.logError((Throwable)cause);
            }
        }
        catch (InterruptedException interruptedException) {}
        return projects;
    }

    public static List<AnalyticsProject> getProjectsList(TestOpsService testOpsService) throws AnalyticsApiException {
        ArrayList<AnalyticsProject> projects = new ArrayList<AnalyticsProject>();
        List<AnalyticsProject> loaded = testOpsService.getPlatformProjects();
        if (loaded != null && !loaded.isEmpty()) {
            projects.addAll(loaded);
        }
        return projects;
    }

    public static List<AnalyticsProject> getActiveProjects(TestOpsService testOpsService) throws AnalyticsApiException {
        List<AnalyticsProject> projects = AnalyticsAuthorizationHandler.getProjectsList(testOpsService);
        ArrayList<AnalyticsProject> activeProjects = new ArrayList<AnalyticsProject>();
        for (AnalyticsProject project : projects) {
            if (!project.getStatus().equalsIgnoreCase(IntegrationAnalyticsMessages.ACTIVE_PROJECT)) continue;
            activeProjects.add(project);
        }
        return activeProjects;
    }

    public static List<AnalyticsTeam> getTeams(TestOpsService testOpsService, Long orgId) {
        ArrayList<AnalyticsTeam> teams = new ArrayList<AnalyticsTeam>();
        try {
            List<AnalyticsTeam> loaded = testOpsService.getTeams(orgId);
            if (loaded != null && !loaded.isEmpty()) {
                teams.addAll(loaded);
            }
        }
        catch (AnalyticsApiException e) {
            LogUtil.logError((Throwable)e);
        }
        return teams;
    }

    public static List<AnalyticsTeam> getTeams(final TestOpsService testOpsService, final Long orgId, ProgressMonitorDialog monitorDialog) {
        final ArrayList<AnalyticsTeam> teams = new ArrayList<AnalyticsTeam>();
        try {
            monitorDialog.run(true, false, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        try {
                            monitor.beginTask(IntegrationAnalyticsMessages.MSG_DLG_PRG_RETRIEVING_TEAMS, 2);
                            monitor.subTask(IntegrationAnalyticsMessages.MSG_DLG_PRG_GETTING_TEAMS);
                            List<AnalyticsTeam> loaded = testOpsService.getTeams(orgId);
                            if (loaded != null && !loaded.isEmpty()) {
                                teams.addAll(loaded);
                            }
                            monitor.worked(1);
                        }
                        catch (Exception e) {
                            throw new InvocationTargetException(e);
                        }
                    }
                    finally {
                        monitor.done();
                    }
                }
            });
            return teams;
        }
        catch (InvocationTargetException exception) {
            Throwable cause = exception.getCause();
            if (!(cause instanceof AnalyticsApiException)) {
                LogUtil.logError((Throwable)cause);
            }
        }
        catch (InterruptedException interruptedException) {}
        return teams;
    }

    public static int getDefaultOrganizationIndex(AnalyticsSettingStore analyticsSettingStore, List<AnalyticsOrganization> organizations) {
        int selectionIndex = 0;
        AnalyticsOrganization storedOrganization = analyticsSettingStore.getOrganization();
        if (storedOrganization != null && storedOrganization.getId() != null && organizations != null) {
            int i = 0;
            while (i < organizations.size()) {
                AnalyticsOrganization org = organizations.get(i);
                if (storedOrganization.getId().equals(org.getId())) {
                    selectionIndex = i;
                    return selectionIndex;
                }
                ++i;
            }
        }
        return selectionIndex;
    }

    public static int getDefaultTeamIndex(AnalyticsSettingStore analyticsSettingStore, List<AnalyticsTeam> teams) {
        int selectionIndex = 0;
        AnalyticsTeam storedTeam = analyticsSettingStore.getTeam();
        if (storedTeam != null && storedTeam.getId() != null && teams != null) {
            int i = 0;
            while (i < teams.size()) {
                AnalyticsTeam p = teams.get(i);
                if (storedTeam.getId().equals(p.getId())) {
                    selectionIndex = i;
                    return selectionIndex;
                }
                ++i;
            }
        }
        return selectionIndex;
    }

    public static int getTeamIndex(List<AnalyticsTeam> teams, AnalyticsTeam selectedTeam) {
        int selectionIndex = 0;
        try {
            if (selectedTeam != null && selectedTeam.getId() != null && teams != null) {
                int i = 0;
                while (i < teams.size()) {
                    AnalyticsTeam t = teams.get(i);
                    if (selectedTeam.getId().equals(t.getId())) {
                        selectionIndex = i;
                        return selectionIndex;
                    }
                    ++i;
                }
            }
        }
        catch (Exception e) {
            LogUtil.logError((Throwable)e);
        }
        return selectionIndex;
    }

    public static List<String> getOrganizationNamesWithEllipsis(List<AnalyticsOrganization> orgs, int maxWidth) {
        List<String> names = orgs.stream().filter(t -> t.getName() != null).map(t -> StringUtils.abbreviate((String)t.getName(), (int)maxWidth)).collect(Collectors.toList());
        return names;
    }

    public static List<String> getTeamNames(List<AnalyticsTeam> teams) {
        List<String> names = teams.stream().map(t -> t.getName()).collect(Collectors.toList());
        return names;
    }

    public static List<String> getOrganizationNames(List<AnalyticsOrganization> orgs) {
        List<String> names = orgs.stream().map(t -> t != null ? t.getName() : null).filter(nameI -> StringUtils.isNotBlank((CharSequence)nameI)).collect(Collectors.toList());
        return names;
    }

    public static List<String> getProjectNames(List<AnalyticsProject> projects) {
        ArrayList<String> names = new ArrayList<String>();
        projects.forEach(p -> {
            boolean bl = names.add(p.getName());
        });
        return names;
    }

    public static List<String> getRepositoriesUrl(List<GitRepositoryEntity> repositories) {
        ArrayList<String> names = new ArrayList<String>();
        repositories.forEach(p -> {
            boolean bl = names.add(p.getRepository());
        });
        return names;
    }

    public static int getProjectIndex(AnalyticsProject analyticsProject, List<AnalyticsProject> projects) {
        int selectionIndex = 0;
        try {
            if (analyticsProject != null && analyticsProject.getId() != null) {
                int i = 0;
                while (i < projects.size()) {
                    AnalyticsProject p = projects.get(i);
                    if (analyticsProject.getId().equals(p.getId())) {
                        selectionIndex = i;
                        return selectionIndex;
                    }
                    ++i;
                }
            }
        }
        catch (Exception e) {
            LogUtil.logError((Throwable)e);
        }
        return selectionIndex;
    }

    public static int getDefaultProjectIndex(AnalyticsSettingStore analyticsSettingStore, List<AnalyticsProject> projects) {
        int selectionIndex = 0;
        AnalyticsProject storedProject = analyticsSettingStore.getProject();
        if (storedProject != null && storedProject.getId() != null) {
            int i = 0;
            while (i < projects.size()) {
                AnalyticsProject p = projects.get(i);
                if (storedProject.getId().equals(p.getId())) {
                    selectionIndex = i;
                    return selectionIndex;
                }
                ++i;
            }
        }
        return selectionIndex;
    }

    public static int getDefaultTestProjectIndex(AnalyticsSettingStore analyticsSettingStore, List<AnalyticsTestProject> testProjects) {
        int selectionIndex = 0;
        AnalyticsTestProject storedTestProject = analyticsSettingStore.getLastLinkedTestProject();
        if (storedTestProject == null) {
            return selectionIndex;
        }
        int i = 0;
        while (i < testProjects.size()) {
            if (testProjects.get(i).getId().equals(storedTestProject.getId())) {
                return i;
            }
            ++i;
        }
        return selectionIndex;
    }

    public static AnalyticsProject createProject(String projectName, AnalyticsTeam team) throws AnalyticsApiException {
        return TestOpsService.getActiveInstance().createProject(projectName, team);
    }

    public static List<AnalyticsTestProject> getTestProjects(long projectId, String serverUrl, AnalyticsTokenInfo token) {
        try {
            return TestOpsService.getActiveInstance().getTestProjects(projectId);
        }
        catch (AnalyticsApiException e) {
            LogUtil.logError((Throwable)e);
            return new ArrayList<AnalyticsTestProject>();
        }
    }

    public static void updateTestProject(AnalyticsTestProject testProject, long timestamp, String folderName, String fileName, String uploadedPath) {
        try {
            TestOpsService.getActiveInstance().updateTestProject(testProject.getId(), timestamp, folderName, fileName, uploadedPath);
        }
        catch (AnalyticsApiException e) {
            LogUtil.logError((Throwable)e);
        }
    }
}

