/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.integration.analytics.providers;

import com.kms.katalon.core.network.HttpClientProxyBuilder;
import com.kms.katalon.core.network.ProxyInformation;
import com.kms.katalon.execution.preferences.ProxyPreferences;
import com.kms.katalon.integration.analytics.exceptions.AnalyticsApiException;
import com.kms.katalon.integration.analytics.providers.IBeforeDownloadStarted;
import com.kms.katalon.integration.analytics.providers.IDownloadRequestProgressChanged;
import com.kms.katalon.integration.analytics.providers.TestOpsService;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URISyntaxException;
import java.security.GeneralSecurityException;
import java.util.LinkedList;
import java.util.List;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.conn.EofSensorInputStream;
import org.apache.http.impl.client.CloseableHttpClient;
import org.eclipse.core.runtime.IProgressMonitor;

public class ApiRequestDownloader {
    private List<IDownloadRequestProgressChanged> downloadProgressListeners;
    private List<IBeforeDownloadStarted> beforeDownloadStartedListeners;
    private IProgressMonitor monitor;
    private String resourcePath;

    public ApiRequestDownloader(String resourcePath, IProgressMonitor monitor) {
        this.resourcePath = resourcePath;
        this.monitor = monitor;
    }

    public void subcribeDownloadProgressChanged(IDownloadRequestProgressChanged listener) {
        if (this.downloadProgressListeners == null) {
            this.downloadProgressListeners = new LinkedList<IDownloadRequestProgressChanged>();
        }
        this.downloadProgressListeners.add(listener);
    }

    public void subcribeBeforeDownloadStarted(IBeforeDownloadStarted listener) {
        if (this.beforeDownloadStartedListeners == null) {
            this.beforeDownloadStartedListeners = new LinkedList<IBeforeDownloadStarted>();
        }
        this.beforeDownloadStartedListeners.add(listener);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public File download() throws IOException, URISyntaxException, GeneralSecurityException, AnalyticsApiException {
        TestOpsService testOpsService = TestOpsService.getActiveInstance();
        URIBuilder builder = testOpsService.getTestOpsUriBuilder(this.resourcePath);
        HttpGet httpRequest = new HttpGet(builder.build().toASCIIString());
        testOpsService.applyTestOpsHeaders((HttpUriRequest)httpRequest, false);
        HttpClientProxyBuilder httpClientProxyBuilder = HttpClientProxyBuilder.create((ProxyInformation)ProxyPreferences.getAuthProxyInformation(), (String)httpRequest.getURI().toURL().toString());
        CloseableHttpClient httpClient = httpClientProxyBuilder.getClientBuilder().build();
        if (this.monitor.isCanceled()) {
            return null;
        }
        HttpResponse httpResponse = httpClient.execute((HttpUriRequest)httpRequest);
        int statusCode = httpResponse.getStatusLine().getStatusCode();
        if (statusCode != 200) {
            throw new AnalyticsApiException("Status code: " + statusCode);
        }
        HttpEntity entity = httpResponse.getEntity();
        if (!entity.isStreaming()) {
            throw new AnalyticsApiException("Unsupported download contents.");
        }
        this.notifyBeforeDownloadListeners(entity.getContentLength());
        File file = File.createTempFile("katalon_tmp_report", ".zip");
        Throwable throwable = null;
        Object var11_13 = null;
        try {
            EofSensorInputStream in = (EofSensorInputStream)entity.getContent();
            try {
                try (FileOutputStream fileOutputStream = new FileOutputStream(file);){
                    long total = entity.getContentLength();
                    long downloaded = 0L;
                    byte[] dataBuffer = new byte[1024];
                    if (!this.monitor.isCanceled()) {
                        int bytesRead;
                        while ((bytesRead = in.read(dataBuffer, 0, 1024)) != -1) {
                            fileOutputStream.write(dataBuffer, 0, bytesRead);
                            this.notifyProgressListeners(total, downloaded += (long)bytesRead);
                            if (this.monitor.isCanceled()) break;
                        }
                    }
                    in.abortConnection();
                }
                if (in == null) return file;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                if (in == null) throw throwable;
                in.close();
                throw throwable;
            }
            in.close();
            return file;
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
                throw throwable;
            } else {
                if (throwable == throwable3) throw throwable;
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
    }

    private void notifyProgressListeners(long total, long downloaded) {
        if (this.downloadProgressListeners != null) {
            this.downloadProgressListeners.parallelStream().forEach(l3 -> l3.notifyProgressChanged(total, downloaded));
        }
    }

    private void notifyBeforeDownloadListeners(long contentLength) {
        if (this.beforeDownloadStartedListeners != null) {
            this.beforeDownloadStartedListeners.parallelStream().forEach(l2 -> l2.notifyDownloadInfo(contentLength));
        }
    }
}

