/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.integration.analytics.providers;

import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.entity.project.ProjectEntity;
import com.kms.katalon.integration.analytics.entity.AnalyticsOrganizationSetting;
import com.kms.katalon.integration.analytics.exceptions.AnalyticsApiException;
import com.kms.katalon.integration.analytics.providers.TestOpsService;
import com.kms.katalon.integration.analytics.setting.AnalyticsSettingStore;

public class FeatureFlagService {
    private static FeatureFlagService instance;
    private Long lastFlagCheckTime;
    private Boolean isKsOnboardingEnabled;
    private Long lastCheckedOrgId;
    private static final long CHECKING_TIMEOUT = 900000L;

    public boolean checkKsOnboardingEnabled() throws AnalyticsApiException {
        ProjectEntity currentProject = ProjectController.getInstance().getCurrentProject();
        if (currentProject == null) {
            return false;
        }
        AnalyticsSettingStore settingStore = new AnalyticsSettingStore(ProjectController.getInstance().getCurrentProject().getFolderLocation());
        if (!settingStore.isIntegrationEnabled()) {
            return false;
        }
        Long organizationId = settingStore.getOrganization().getId();
        boolean shouldCheckFlag = this.shouldCheckFlag(organizationId);
        if (shouldCheckFlag) {
            AnalyticsOrganizationSetting orgSetting = TestOpsService.getActiveInstance().getOrganiztionSetting(organizationId);
            this.isKsOnboardingEnabled = orgSetting.isKsOnboardingFlowEnabled();
            this.lastFlagCheckTime = System.currentTimeMillis();
            this.lastCheckedOrgId = organizationId;
        }
        if (this.isKsOnboardingEnabled != null && this.isKsOnboardingEnabled.booleanValue()) {
            return true;
        }
        throw new AnalyticsApiException("Disable KsOnboardingEnabled flag");
    }

    private boolean shouldCheckFlag(Long organizationId) {
        return this.isKsOnboardingEnabled == null || System.currentTimeMillis() - this.lastFlagCheckTime > 900000L || !this.lastCheckedOrgId.equals(organizationId);
    }

    public static FeatureFlagService getInstance() {
        if (instance == null) {
            instance = new FeatureFlagService();
        }
        return instance;
    }
}

