/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.integration.analytics.providers;

import com.google.common.base.Objects;
import com.google.common.reflect.TypeToken;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.kms.katalon.application.KatalonApplication;
import com.kms.katalon.application.utils.ApplicationInfo;
import com.kms.katalon.application.utils.LoginMethod;
import com.kms.katalon.application.utils.VersionUtil;
import com.kms.katalon.core.model.KatalonEdition;
import com.kms.katalon.core.model.KatalonPackage;
import com.kms.katalon.core.network.RequestBuilder;
import com.kms.katalon.core.util.JsonBuilder;
import com.kms.katalon.core.util.Strings;
import com.kms.katalon.core.util.internal.JsonUtil;
import com.kms.katalon.entity.integration.analytics.AnalyticsOrganization;
import com.kms.katalon.integration.analytics.entity.AnalyticsExecution;
import com.kms.katalon.integration.analytics.entity.AnalyticsExecutionPage;
import com.kms.katalon.integration.analytics.entity.AnalyticsExecutionStage;
import com.kms.katalon.integration.analytics.entity.AnalyticsFeature;
import com.kms.katalon.integration.analytics.entity.AnalyticsFileInfo;
import com.kms.katalon.integration.analytics.entity.AnalyticsKREOrganization;
import com.kms.katalon.integration.analytics.entity.AnalyticsLicenseKey;
import com.kms.katalon.integration.analytics.entity.AnalyticsOrganizationPage;
import com.kms.katalon.integration.analytics.entity.AnalyticsOrganizationSetting;
import com.kms.katalon.integration.analytics.entity.AnalyticsPage;
import com.kms.katalon.integration.analytics.entity.AnalyticsPageBaseResource;
import com.kms.katalon.integration.analytics.entity.AnalyticsPlan;
import com.kms.katalon.integration.analytics.entity.AnalyticsPlanPage;
import com.kms.katalon.integration.analytics.entity.AnalyticsProject;
import com.kms.katalon.integration.analytics.entity.AnalyticsProjectPage;
import com.kms.katalon.integration.analytics.entity.AnalyticsRelease;
import com.kms.katalon.integration.analytics.entity.AnalyticsReleasePage;
import com.kms.katalon.integration.analytics.entity.AnalyticsRunConfiguration;
import com.kms.katalon.integration.analytics.entity.AnalyticsTeam;
import com.kms.katalon.integration.analytics.entity.AnalyticsTeamPage;
import com.kms.katalon.integration.analytics.entity.AnalyticsTestCase;
import com.kms.katalon.integration.analytics.entity.AnalyticsTestProject;
import com.kms.katalon.integration.analytics.entity.AnalyticsTestProjectPage;
import com.kms.katalon.integration.analytics.entity.AnalyticsTestRun;
import com.kms.katalon.integration.analytics.entity.AnalyticsTokenInfo;
import com.kms.katalon.integration.analytics.entity.AnalyticsTracking;
import com.kms.katalon.integration.analytics.entity.AnalyticsUploadInfo;
import com.kms.katalon.integration.analytics.entity.AnalyticsUser;
import com.kms.katalon.integration.analytics.entity.TestCaseIdentity;
import com.kms.katalon.integration.analytics.entity.TestOpsProjectStatistics;
import com.kms.katalon.integration.analytics.entity.TestOpsProjectStatisticsPage;
import com.kms.katalon.integration.analytics.entity.TestOpsTotalExecutionStatistics;
import com.kms.katalon.integration.analytics.entity.TestOpsUsage;
import com.kms.katalon.integration.analytics.exceptions.AnalyticsApiException;
import com.kms.katalon.integration.analytics.providers.BaseTestOpsService;
import com.kms.katalon.integration.analytics.query.AnalyticsQuery;
import com.kms.katalon.integration.analytics.query.AnalyticsQueryCondition;
import com.kms.katalon.integration.analytics.query.AnalyticsQueryFunction;
import com.kms.katalon.integration.analytics.query.AnalyticsQueryPagination;
import com.kms.katalon.license.models.AuthenticationToken;
import com.kms.katalon.logging.LogUtil;
import com.kms.katalon.util.LicenseServerUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import java.time.LocalTime;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.InputStreamEntity;
import org.apache.http.entity.StringEntity;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.FileBody;
import org.apache.http.entity.mime.content.StringBody;

public class TestOpsService
extends BaseTestOpsService<TestOpsService> {
    public static final int DEFAULT_RETRY_TIMES = 3;
    public static final String SIZE_OF_EACH_PAGE = "30";
    private static TestOpsService instance;
    private static TestOpsService overridingInstance;
    private static TestOpsService activeInstance;
    private String detectedTestOpsServer;

    public static TestOpsService getInstance() {
        if (instance == null) {
            instance = new TestOpsService();
        }
        return instance;
    }

    public static TestOpsService getOverridingInstance() {
        if (overridingInstance == null) {
            overridingInstance = (TestOpsService)TestOpsService.getInstance().clone();
            overridingInstance.clearAllTokens();
            overridingInstance.clearCredential();
        }
        return overridingInstance;
    }

    public static void switchToOverridingInstance() {
        activeInstance = TestOpsService.getOverridingInstance();
    }

    public static void switchToDefaultInstance() {
        activeInstance = TestOpsService.getInstance();
    }

    public static boolean isUsingDefaultInstance() {
        return TestOpsService.getActiveInstance() == TestOpsService.getInstance();
    }

    public static boolean isUsingOverridingInstance() {
        return TestOpsService.getActiveInstance() == TestOpsService.getOverridingInstance();
    }

    public boolean isOnPremUser() {
        return !LicenseServerUtil.isKatalonLicenseServer((String)this.getAdminServer()) && this.isLoginWithLicenseServer();
    }

    private boolean isLoginWithLicenseServer() {
        return ApplicationInfo.getLoginMethod() == LoginMethod.CREDENTIAL;
    }

    public static TestOpsService getActiveInstance() {
        return activeInstance != null ? activeInstance : TestOpsService.getInstance();
    }

    public static TestOpsService getActiveInstanceWithDetectedTestOpsServer() {
        TestOpsService testOpsServiceByDetectedServer = (TestOpsService)TestOpsService.getActiveInstance().clone();
        String testOpsServer = TestOpsService.getActiveInstance().getDetectedTestOpsServer();
        testOpsServiceByDetectedServer.setTestOpsServer(testOpsServer);
        AuthenticationToken testOpsToken = testOpsServiceByDetectedServer.getTestOpsToken();
        testOpsToken.setServer(testOpsServer);
        return testOpsServiceByDetectedServer;
    }

    public void detectTestOpsServer() throws AnalyticsApiException {
        if (StringUtils.isBlank((CharSequence)this.getAdminServer())) {
            return;
        }
        String detectedTestOpsServer = this.getTestOpsServerFromUser();
        if (StringUtils.isNotBlank((CharSequence)detectedTestOpsServer)) {
            this.detectedTestOpsServer = detectedTestOpsServer;
        }
    }

    public String getDetectedTestOpsServer() {
        return (String)Strings.firstNonBlank((CharSequence[])new String[]{this.detectedTestOpsServer, this.getTestOpsServer()});
    }

    public void setDetectedTestOpsServer(String detectedTestOpsServer) {
        this.detectedTestOpsServer = detectedTestOpsServer;
    }

    public AnalyticsOrganization createDefaultOrganization() throws AnalyticsApiException {
        try {
            URIBuilder uriBuilder = this.getAdminUriBuilder("/api/v1/organizations");
            HttpPost httpPost = new HttpPost(uriBuilder.build());
            return this.sendAdminRequest((HttpUriRequest)httpPost, AnalyticsOrganization.class);
        }
        catch (Exception e) {
            throw AnalyticsApiException.wrap(e);
        }
    }

    public AnalyticsOrganization getOrganization(long orgId) throws AnalyticsApiException {
        try {
            URIBuilder uriBuilder = this.getAdminUriBuilder(String.format("/api/v1/organizations/%d", orgId));
            HttpGet httpGet = new HttpGet(uriBuilder.build().toASCIIString());
            AnalyticsOrganization organization = this.sendAdminRequest((HttpUriRequest)httpGet, AnalyticsOrganization.class);
            return organization;
        }
        catch (Exception e) {
            throw AnalyticsApiException.wrap(e);
        }
    }

    public List<AnalyticsOrganization> getOrganizations() throws AnalyticsApiException {
        try {
            URIBuilder uriBuilder = this.getAdminUriBuilder("/api/v1/users/me");
            HttpGet httpGet = new HttpGet(uriBuilder.build().toASCIIString());
            AnalyticsOrganizationPage organizationPage = this.sendAdminRequest((HttpUriRequest)httpGet, AnalyticsOrganizationPage.class);
            return organizationPage.getOrganizations();
        }
        catch (Exception e) {
            throw new AnalyticsApiException(e);
        }
    }

    public List<AnalyticsOrganization> getKREOrganizations() throws AnalyticsApiException {
        try {
            URIBuilder uriBuilder = this.getAdminUriBuilder("/api/v1/organizations/list");
            HttpGet httpGet = new HttpGet(uriBuilder.build().toASCIIString());
            AnalyticsKREOrganization[] organizations = this.sendAdminRequest((HttpUriRequest)httpGet, AnalyticsKREOrganization[].class);
            String type = ApplicationInfo.getAuthenticationType();
            String domain = ApplicationInfo.getAuthenticationSubDomain();
            return Arrays.asList(organizations).stream().filter(element -> element.isKreLicense() && element.isSamlSSO() == StringUtils.equalsIgnoreCase((CharSequence)type, (CharSequence)"saml") && StringUtils.equalsIgnoreCase((CharSequence)element.getDomain(), (CharSequence)domain)).collect(Collectors.toList());
        }
        catch (Exception e) {
            throw AnalyticsApiException.wrap(e);
        }
    }

    public AnalyticsOrganizationSetting getOrganiztionSetting(long organizationId) throws AnalyticsApiException {
        try {
            URIBuilder uriBuilder = this.getTestOpsUriBuilder("/api/v1/organizations/setting");
            uriBuilder.addParameter("organizationId", Long.toString(organizationId));
            HttpGet httpGet = new HttpGet(uriBuilder.build().toASCIIString());
            AnalyticsOrganizationSetting organizationSetting = this.sendTestOpsRequest((HttpUriRequest)httpGet, AnalyticsOrganizationSetting.class);
            return organizationSetting;
        }
        catch (Exception e) {
            throw AnalyticsApiException.wrap(e);
        }
    }

    public List<AnalyticsTeam> getTeams(Long orgId) throws AnalyticsApiException {
        try {
            Long currentPage = 0L;
            AnalyticsTeamPage teamPage = this.getTeamPageByPageAndSize(currentPage, orgId);
            ArrayList<AnalyticsTeam> teams = new ArrayList<AnalyticsTeam>();
            if (!teamPage.getContent().isEmpty()) {
                teams.addAll(teamPage.getContent());
            }
            while (!teamPage.getLast().booleanValue()) {
                for (AnalyticsTeam team : teamPage.getContent()) {
                    if (!team.getOrganization().getId().equals(orgId)) continue;
                    teams.add(team);
                }
                currentPage = currentPage + 1L;
                teamPage = this.getTeamPageByPageAndSize(currentPage, orgId);
            }
            return teams;
        }
        catch (Exception e) {
            throw AnalyticsApiException.wrap(e);
        }
    }

    public AnalyticsTeamPage getTeamPageByPageAndSize(Long pageNumber, Long orgId) throws AnalyticsApiException {
        try {
            String conditions = "{\"key\":\"Organization.id\",\"operator\":\"=\",\"value\":\"" + orgId + "\"}";
            String parameterValue = this.buildQueryParam("Team", conditions, "", pageNumber.toString(), SIZE_OF_EACH_PAGE, "name,asc", "");
            URIBuilder uriBuilder = this.getAdminUriBuilder("/api/v1/search");
            uriBuilder.addParameter("q", parameterValue);
            HttpGet httpGet = new HttpGet(uriBuilder.build().toASCIIString());
            return this.sendAdminRequest((HttpUriRequest)httpGet, AnalyticsTeamPage.class);
        }
        catch (Exception e) {
            throw AnalyticsApiException.wrap(e);
        }
    }

    public List<AnalyticsTestProject> getTestProjects(long projectId) throws AnalyticsApiException {
        try {
            AnalyticsTestProjectPage response = this.getTestProjectPage(projectId, 0);
            ArrayList<AnalyticsTestProject> testProjects = new ArrayList<AnalyticsTestProject>();
            if (!response.isEmpty()) {
                testProjects.addAll(Arrays.asList(response.getContent()));
            }
            while (!response.isEmpty() && !response.isLast()) {
                response = this.getTestProjectPage(projectId, response.getPageable().getPageNumber() + 1);
                testProjects.addAll(Arrays.asList(response.getContent()));
            }
            return testProjects;
        }
        catch (Exception e) {
            throw AnalyticsApiException.wrap(e);
        }
    }

    private AnalyticsTestProjectPage getTestProjectPage(long projectId, int page) throws Exception {
        URIBuilder builder = this.getTestOpsUriBuilder("/api/v1/search");
        AnalyticsQuery query = new AnalyticsQuery();
        query.setType("TestProject");
        query.setGroupBys(new String[0]);
        LinkedList<AnalyticsQueryCondition> conditions = new LinkedList<AnalyticsQueryCondition>();
        AnalyticsQueryCondition conditionProject = new AnalyticsQueryCondition("Project.id", "=", String.valueOf(projectId));
        conditions.add(conditionProject);
        query.setConditions(conditions.toArray(new AnalyticsQueryCondition[conditions.size()]));
        query.setFunctions(new AnalyticsQueryFunction[0]);
        AnalyticsQueryPagination pagination = new AnalyticsQueryPagination(page, 30, new String[]{"name,asc"});
        query.setPagination(pagination);
        builder.setParameter("q", JsonUtil.toJson((Object)query));
        HttpGet httpGet = new HttpGet(builder.build().toASCIIString());
        AnalyticsTestProjectPage response = this.sendTestOpsRequest((HttpUriRequest)httpGet, AnalyticsTestProjectPage.class);
        return response;
    }

    public AnalyticsProject getDefaultNewUserProject() throws AnalyticsApiException {
        try {
            URIBuilder uriBuilder = this.getTestOpsUriBuilder("/api/v1/projects");
            HttpGet httpGet = new HttpGet(uriBuilder.build().toASCIIString());
            AnalyticsPage<AnalyticsProject> response = this.sendTestOpsRequest((HttpUriRequest)httpGet, new TypeToken<AnalyticsPage<AnalyticsProject>>(){});
            if (!response.getContent().isEmpty()) {
                Optional<AnalyticsProject> defaultProject = response.getContent().stream().filter(project -> project.isAutoIntegrate()).findFirst();
                return defaultProject.orElse(null);
            }
            return null;
        }
        catch (Exception e) {
            throw AnalyticsApiException.wrap(e);
        }
    }

    public List<AnalyticsProject> getOnCloudProjects(AnalyticsOrganization org) throws AnalyticsApiException {
        try {
            URIBuilder uriBuilder = this.getAdminUriBuilder("/api/v1/users/me");
            HttpGet httpGet = new HttpGet(uriBuilder.build().toASCIIString());
            AnalyticsOrganizationPage organizationPage = this.sendAdminRequest((HttpUriRequest)httpGet, AnalyticsOrganizationPage.class);
            List<AnalyticsProject> projects = organizationPage.getProjects().stream().filter(p -> Objects.equal((Object)p.getTeam().getOrganization().getId(), (Object)org.getId())).toList();
            return projects;
        }
        catch (Exception e) {
            throw AnalyticsApiException.wrap(e);
        }
    }

    public List<AnalyticsProject> getOnPremProjects(AnalyticsTeam team) throws AnalyticsApiException {
        try {
            URIBuilder uriBuilder = this.getAdminUriBuilder("/api/v1/projects");
            if (team != null && team.getId() != 0L) {
                uriBuilder.setParameter("teamId", "" + team.getId());
                uriBuilder.setParameter("sort", "name,asc");
            }
            HttpGet httpGet = new HttpGet(uriBuilder.build().toASCIIString());
            AnalyticsProjectPage projectPage = this.sendAdminRequest((HttpUriRequest)httpGet, AnalyticsProjectPage.class);
            List<AnalyticsProject> projects = projectPage.getContent();
            int pageNumber = 0;
            while (!projectPage.getLast().booleanValue()) {
                uriBuilder.setParameter("page", Integer.toString(++pageNumber));
                httpGet = new HttpGet(uriBuilder.build().toASCIIString());
                projectPage = this.sendAdminRequest((HttpUriRequest)httpGet, AnalyticsProjectPage.class);
                projects.addAll(projectPage.getContent());
            }
            return projects;
        }
        catch (Exception e) {
            throw AnalyticsApiException.wrap(e);
        }
    }

    public List<AnalyticsProject> getPlatformProjects() throws AnalyticsApiException {
        try {
            URIBuilder uriBuilder = this.getAdminUriBuilder("/api/v1/projects/platform-projects");
            HttpGet httpGet = new HttpGet(uriBuilder.build().toASCIIString());
            AnalyticsProject[] projectArray = this.sendAdminRequest((HttpUriRequest)httpGet, AnalyticsProject[].class);
            List<AnalyticsProject> projectList = Arrays.asList(projectArray);
            return projectList;
        }
        catch (Exception e) {
            throw AnalyticsApiException.wrap(e);
        }
    }

    public AnalyticsProject createProject(String projectName, AnalyticsTeam team) throws AnalyticsApiException {
        try {
            URIBuilder uriBuilder = this.getAdminUriBuilder("/api/v1/projects");
            HttpPost httpPost = new HttpPost(uriBuilder.build());
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("name", projectName);
            if (team != null && team.getId() != null) {
                map.put("teamId", "" + team.getId());
            }
            httpPost.setEntity((HttpEntity)this.asBodyEntity(map));
            return this.sendAdminRequest((HttpUriRequest)httpPost, AnalyticsProject.class);
        }
        catch (Exception e) {
            throw AnalyticsApiException.wrap(e);
        }
    }

    public List<AnalyticsRelease> getReleases(Long projectId) throws AnalyticsApiException {
        try {
            AnalyticsReleasePage response = this.getReleasePage(projectId, 0, true);
            ArrayList<AnalyticsRelease> releases = new ArrayList<AnalyticsRelease>();
            if (!response.isEmpty()) {
                releases.addAll(Arrays.asList(response.getContent()));
            }
            while (!response.isEmpty() && !response.isLast()) {
                response = this.getReleasePage(projectId, response.getPageable().getPageNumber() + 1, true);
                releases.addAll(Arrays.asList(response.getContent()));
            }
            return releases;
        }
        catch (Exception e) {
            throw AnalyticsApiException.wrap(e);
        }
    }

    public List<AnalyticsRelease> getFirstReleasesPage(Long projectId) throws AnalyticsApiException {
        try {
            AnalyticsReleasePage response = this.getReleasePage(projectId, 0, false);
            return Arrays.asList(response.getContent());
        }
        catch (Exception e) {
            throw AnalyticsApiException.wrap(e);
        }
    }

    private AnalyticsReleasePage getReleasePage(Long projectId, Integer page, boolean activeOnly) throws Exception {
        URIBuilder builder = this.getTestOpsUriBuilder("/api/v1/search");
        AnalyticsQuery query = new AnalyticsQuery();
        query.setType("Release");
        query.setGroupBys(new String[0]);
        LinkedList<AnalyticsQueryCondition> conditions = new LinkedList<AnalyticsQueryCondition>();
        AnalyticsQueryCondition conditionProject = new AnalyticsQueryCondition("Project.id", "=", projectId.toString());
        conditions.add(conditionProject);
        if (activeOnly) {
            AnalyticsQueryCondition conditionStatus = new AnalyticsQueryCondition("closed", "=", "false");
            conditions.add(conditionStatus);
        }
        query.setConditions(conditions.toArray(new AnalyticsQueryCondition[0]));
        query.setFunctions(new AnalyticsQueryFunction[0]);
        AnalyticsQueryPagination pagination = new AnalyticsQueryPagination(page, 30, new String[]{"closed,asc", "name,asc"});
        query.setPagination(pagination);
        builder.setParameter("q", JsonUtil.toJson((Object)query));
        HttpGet httpGet = new HttpGet(builder.build().toASCIIString());
        AnalyticsReleasePage response = this.sendTestOpsRequest((HttpUriRequest)httpGet, AnalyticsReleasePage.class);
        return response;
    }

    public List<AnalyticsPlan> getPlans(Long projectId) throws AnalyticsApiException {
        try {
            URIBuilder builder = this.getTestOpsUriBuilder("/api/v1/search");
            AnalyticsQuery query = new AnalyticsQuery();
            query.setType("RunConfiguration");
            AnalyticsQueryCondition conditionProject = new AnalyticsQueryCondition("Project.id", "=", projectId.toString());
            query.setConditions(new AnalyticsQueryCondition[]{conditionProject});
            AnalyticsQueryPagination pagination = new AnalyticsQueryPagination(0, 30, new String[]{"name,asc"});
            query.setPagination(pagination);
            builder.setParameter("q", JsonUtil.toJson((Object)query));
            HttpGet httpGet = new HttpGet(builder.build().toASCIIString());
            AnalyticsPlanPage response = this.sendTestOpsRequest((HttpUriRequest)httpGet, AnalyticsPlanPage.class);
            return Arrays.asList(response.getContent());
        }
        catch (Exception e) {
            throw AnalyticsApiException.wrap(e);
        }
    }

    public AnalyticsRunConfiguration createTestPlan(long projectId, long teamId, String name, long testProjectId, String cloudType, String configType, long testSuiteCollectionId) throws AnalyticsApiException {
        try {
            LogUtil.logInfo((String)("Katalon TestOps: Create test plan in Katalon TestOps server: " + this.getTestOpsServer()));
            URIBuilder uriBuilder = this.getTestOpsUriBuilder("/api/v1/run-configurations");
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("name", name);
            map.put("projectId", String.valueOf(projectId));
            map.put("teamId", String.valueOf(teamId));
            map.put("testProjectId", String.valueOf(testProjectId));
            map.put("cloudType", cloudType);
            map.put("configType", configType);
            map.put("testSuiteCollectionId", String.valueOf(testSuiteCollectionId));
            HttpPost httpPost = new HttpPost(uriBuilder.build());
            httpPost.setEntity((HttpEntity)this.asBodyEntity(map));
            return this.sendTestOpsRequest((HttpUriRequest)httpPost, AnalyticsRunConfiguration.class);
        }
        catch (Exception e) {
            LogUtil.logError((Throwable)e);
            throw AnalyticsApiException.wrap(e);
        }
    }

    public void sendTrackingActivity(AnalyticsTracking trackingInfo) throws AnalyticsApiException {
        try {
            URIBuilder uriBuilder = this.getTestOpsUriBuilder("/api/v1/tracking");
            HttpPost httpPost = new HttpPost(uriBuilder.build());
            httpPost.setHeader("Accept", "application/json");
            httpPost.setHeader("Content-type", "application/json");
            Gson gson = new GsonBuilder().setDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ").create();
            StringEntity entity = new StringEntity(gson.toJson((Object)trackingInfo), StandardCharsets.UTF_8);
            httpPost.setEntity((HttpEntity)entity);
            this.sendTestOpsRequest((HttpUriRequest)httpPost, Object.class, true);
        }
        catch (Exception e) {
            throw AnalyticsApiException.wrap(e);
        }
    }

    public void uploadFileWithRetry(String url, File file) throws AnalyticsApiException {
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (FileInputStream content = new FileInputStream(file);){
                InputStreamEntity entity = new InputStreamEntity((InputStream)content, file.length());
                HttpPut httpPut = new HttpPut(url);
                httpPut.setEntity((HttpEntity)entity);
                int retryCount = 0;
                do {
                    HttpResponse response;
                    int statusCode;
                    if (TestOpsService.isOkStatus(statusCode = (response = this.sendSimpleRequest((HttpUriRequest)httpPut)).getStatusLine().getStatusCode())) {
                        return;
                    }
                    if (!TestOpsService.isRetryStatus(statusCode)) {
                        LogUtil.logInfo((String)MessageFormat.format("Upload failed with status code {0}. No retry.", String.valueOf(statusCode)));
                        return;
                    }
                    LogUtil.logInfo((String)MessageFormat.format("Upload failed with status code {0}. Retrying {1}.", String.valueOf(statusCode), String.valueOf(++retryCount)));
                    try {
                        TimeUnit.SECONDS.sleep(7L);
                    }
                    catch (InterruptedException interruptedException) {
                        LogUtil.logInfo((String)"No waiting before retrying. Thread intrrupted.");
                    }
                } while ((long)retryCount < 10L);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            throw AnalyticsApiException.wrap(e);
        }
    }

    public List<AnalyticsExecution> uploadFileInfo(long projectId, long timestamp, String folderName, String fileName, String uploadedPath, boolean isEnd) throws AnalyticsApiException {
        try {
            LogUtil.logInfo((String)("Katalon TestOps: Start uploading report to Katalon TestOps server: " + this.getTestOpsServer()));
            URIBuilder uriBuilder = this.getTestOpsUriBuilder("/api/v1/katalon-test-reports");
            uriBuilder.setParameter("projectId", String.valueOf(projectId));
            uriBuilder.setParameter("batch", String.valueOf(timestamp));
            uriBuilder.setParameter("folderPath", folderName);
            uriBuilder.setParameter("isEnd", String.valueOf(isEnd));
            uriBuilder.setParameter("fileName", fileName);
            uriBuilder.setParameter("uploadedPath", uploadedPath);
            HttpPost httpPost = new HttpPost(uriBuilder.build());
            return this.sendTestOpsRequest((HttpUriRequest)httpPost, new TypeToken<ArrayList<AnalyticsExecution>>(){});
        }
        catch (Exception e) {
            LogUtil.logError((Throwable)e);
            throw AnalyticsApiException.wrap(e);
        }
    }

    public AnalyticsUploadInfo getUploadInfo(long projectId) throws AnalyticsApiException {
        try {
            URIBuilder uriBuilder = this.getTestOpsUriBuilder("/api/v1/files/upload-url");
            uriBuilder.setParameter("projectId", String.valueOf(projectId));
            HttpGet httpGet = new HttpGet(uriBuilder.build());
            return this.sendTestOpsRequest((HttpUriRequest)httpGet, AnalyticsUploadInfo.class);
        }
        catch (Exception e) {
            throw AnalyticsApiException.wrap(e);
        }
    }

    public void uploadFile(String url, File file) throws AnalyticsApiException {
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (FileInputStream content = new FileInputStream(file);){
                InputStreamEntity entity = new InputStreamEntity((InputStream)content, file.length());
                HttpPut httpPut = new HttpPut(url);
                httpPut.setEntity((HttpEntity)entity);
                this.sendRequest((HttpUriRequest)httpPut, Object.class);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            throw AnalyticsApiException.wrap(e);
        }
    }

    public AnalyticsTestProject updateTestProject(long testProjectId, long timestamp, String folderPath, String fileName, String uploadedPath) throws AnalyticsApiException {
        try {
            LogUtil.logInfo((String)("Katalon TestOps: Start uploading test project to Katalon TestOps server: " + this.getTestOpsServer()));
            URIBuilder uriBuilder = this.getTestOpsUriBuilder(MessageFormat.format("/api/v1/test-projects/{0}/update-package", String.valueOf(testProjectId)));
            uriBuilder.setParameter("batch", String.valueOf(timestamp));
            uriBuilder.setParameter("folderPath", folderPath);
            uriBuilder.setParameter("fileName", fileName);
            uriBuilder.setParameter("uploadedPath", uploadedPath);
            HttpPost httpPost = new HttpPost(uriBuilder.build());
            return this.sendTestOpsRequest((HttpUriRequest)httpPost, AnalyticsTestProject.class);
        }
        catch (Exception e) {
            LogUtil.logError((Throwable)e);
            throw AnalyticsApiException.wrap(e);
        }
    }

    public AnalyticsTestProject uploadTestProject(long projectId, long teamId, long timestamp, String name, String folderName, String fileName, String uploadedPath) throws AnalyticsApiException {
        try {
            LogUtil.logInfo((String)("Katalon TestOps: Start uploading test project to Katalon TestOps server: " + this.getTestOpsServer()));
            URIBuilder uriBuilder = this.getTestOpsUriBuilder("/api/v1/test-projects/upload");
            uriBuilder.setParameter("name", name);
            uriBuilder.setParameter("projectId", String.valueOf(projectId));
            uriBuilder.setParameter("teamId", String.valueOf(teamId));
            uriBuilder.setParameter("batch", String.valueOf(timestamp));
            uriBuilder.setParameter("folderPath", folderName);
            uriBuilder.setParameter("fileName", fileName);
            uriBuilder.setParameter("uploadedPath", uploadedPath);
            HttpPost httpPost = new HttpPost(uriBuilder.build());
            return this.sendTestOpsRequest((HttpUriRequest)httpPost, AnalyticsTestProject.class);
        }
        catch (Exception e) {
            LogUtil.logError((Throwable)e);
            throw AnalyticsApiException.wrap(e);
        }
    }

    public List<AnalyticsExecution> sendLog(long projectId, long timestamp, String folderName, File file, boolean isEnd) throws AnalyticsApiException {
        try {
            URIBuilder uriBuilder = this.getTestOpsUriBuilder("/api/v1/katalon-test-reports");
            HttpPost httpPost = new HttpPost(uriBuilder.build());
            StringBody projectIdPart = new StringBody(String.valueOf(projectId), ContentType.MULTIPART_FORM_DATA);
            StringBody batchPart = new StringBody(String.valueOf(timestamp), ContentType.MULTIPART_FORM_DATA);
            StringBody isEndPart = new StringBody(String.valueOf(isEnd), ContentType.MULTIPART_FORM_DATA);
            StringBody folderPathPart = new StringBody(folderName, ContentType.MULTIPART_FORM_DATA);
            FileBody fileBodyPart = new FileBody(file, ContentType.DEFAULT_BINARY);
            MultipartEntityBuilder builder = MultipartEntityBuilder.create();
            builder.setMode(HttpMultipartMode.BROWSER_COMPATIBLE);
            builder.addPart("projectId", (ContentBody)projectIdPart);
            builder.addPart("batch", (ContentBody)batchPart);
            builder.addPart("folderPath", (ContentBody)folderPathPart);
            builder.addPart("isEnd", (ContentBody)isEndPart);
            builder.addPart("file", (ContentBody)fileBodyPart);
            HttpEntity entity = builder.build();
            httpPost.setEntity(entity);
            return this.sendTestOpsRequest((HttpUriRequest)httpPost, new TypeToken<ArrayList<AnalyticsExecution>>(){});
        }
        catch (Exception e) {
            throw AnalyticsApiException.wrap(e);
        }
    }

    public List<AnalyticsUploadInfo> getMultipleUploadInfo(long projectId, long numberUploadInfo) throws AnalyticsApiException {
        try {
            URIBuilder uriBuilder = this.getTestOpsUriBuilder("/api/v1/files/upload-urls");
            uriBuilder.setParameter("projectId", String.valueOf(projectId));
            uriBuilder.setParameter("numberUrl", String.valueOf(numberUploadInfo));
            HttpGet httpGet = new HttpGet(uriBuilder.build());
            return this.sendTestOpsRequest((HttpUriRequest)httpGet, new TypeToken<ArrayList<AnalyticsUploadInfo>>(){});
        }
        catch (Exception e) {
            LogUtil.logError((Throwable)e);
            throw AnalyticsApiException.wrap(e);
        }
    }

    public List<AnalyticsExecution> uploadMultipleFileInfo(long projectId, long timestamp, List<AnalyticsFileInfo> fileInfoList) throws AnalyticsApiException {
        try {
            LogUtil.logInfo((String)("Katalon TestOps: Start uploading report to Katalon TestOps server: " + this.getTestOpsServer()));
            URIBuilder uriBuilder = this.getTestOpsUriBuilder("/api/v1/katalon/test-reports/multiple");
            uriBuilder.setParameter("projectId", String.valueOf(projectId));
            uriBuilder.setParameter("batch", String.valueOf(timestamp));
            HttpPost httpPost = new HttpPost(uriBuilder.build());
            httpPost.setEntity((HttpEntity)this.asBodyEntity(fileInfoList));
            return this.sendTestOpsRequest((HttpUriRequest)httpPost, new TypeToken<ArrayList<AnalyticsExecution>>(){});
        }
        catch (Exception e) {
            LogUtil.logError((Throwable)e);
            throw AnalyticsApiException.wrap(e);
        }
    }

    public void updateTestRunResult(long projectId, AnalyticsTestRun testRun) throws AnalyticsApiException {
        try {
            URIBuilder uriBuilder = this.getTestOpsUriBuilder("/api/v1/katalon/test-reports/update-result");
            uriBuilder.setParameter("projectId", String.valueOf(projectId));
            HttpPost httpPost = new HttpPost(uriBuilder.build());
            httpPost.setEntity((HttpEntity)this.asBodyEntity(testRun));
            this.sendTestOpsRequest((HttpUriRequest)httpPost, Object.class);
        }
        catch (Exception e) {
            throw AnalyticsApiException.wrap(e);
        }
    }

    public List<AnalyticsExecution> getExecutions(Long projectId) throws AnalyticsApiException {
        try {
            AnalyticsExecutionPage response = this.getExecutionPage(projectId, 0);
            ArrayList<AnalyticsExecution> executions = new ArrayList<AnalyticsExecution>();
            if (!response.isEmpty()) {
                executions.addAll(Arrays.asList(response.getContent()));
            }
            return executions.stream().filter(e -> e.getExecutionStage() != AnalyticsExecutionStage.RUNNING).collect(Collectors.toList());
        }
        catch (Exception e2) {
            throw AnalyticsApiException.wrap(e2);
        }
    }

    private AnalyticsExecutionPage getExecutionPage(Long projectId, Integer page) throws Exception {
        URIBuilder builder = this.getTestOpsUriBuilder("/api/v1/search");
        AnalyticsQuery query = new AnalyticsQuery();
        query.setType("Execution");
        AnalyticsQueryCondition conditionProject = new AnalyticsQueryCondition("Project.id", "=", projectId.toString());
        query.setConditions(new AnalyticsQueryCondition[]{conditionProject});
        AnalyticsQueryPagination pagination = new AnalyticsQueryPagination(page, 30, new String[]{"order,desc"});
        query.setPagination(pagination);
        builder.setParameter("q", JsonUtil.toJson((Object)query));
        HttpGet httpGet = new HttpGet(builder.build().toASCIIString());
        AnalyticsExecutionPage response = this.sendTestOpsRequest((HttpUriRequest)httpGet, AnalyticsExecutionPage.class);
        return response;
    }

    public List<AnalyticsTestCase> getTestCaseRuns(Long projectId, List<String> testCaseIds) throws AnalyticsApiException {
        try {
            URIBuilder uriBuilder = this.getTestOpsUriBuilder("/api/v1/test-cases/statistics");
            ArrayList<TestCaseIdentity.IdentityResource> identityResources = new ArrayList<TestCaseIdentity.IdentityResource>();
            int numberOfTestCaseIds = 0;
            for (String str : testCaseIds) {
                if (numberOfTestCaseIds > 29) break;
                String[] arr = str.split("/");
                if (arr.length < 2) continue;
                String name = arr[arr.length - 1];
                String path = str.substring(0, str.lastIndexOf(47));
                TestCaseIdentity.IdentityResource identityResource = new TestCaseIdentity.IdentityResource();
                identityResource.setName(name);
                identityResource.setPath(path);
                identityResources.add(identityResource);
                ++numberOfTestCaseIds;
            }
            TestCaseIdentity testCaseIdentity = new TestCaseIdentity();
            testCaseIdentity.setProjectId(projectId);
            testCaseIdentity.setIdentityResources(identityResources);
            HttpPost httpPost = new HttpPost(uriBuilder.build().toASCIIString());
            httpPost.setConfig(this.addRequestTimeout());
            httpPost.setEntity((HttpEntity)this.asBodyEntity(testCaseIdentity));
            AnalyticsTestCase[] analyticsTestCaseArray = this.sendTestOpsRequest((HttpUriRequest)httpPost, AnalyticsTestCase[].class);
            List<AnalyticsTestCase> analyticsTestCaseList = Arrays.asList(analyticsTestCaseArray);
            return analyticsTestCaseList;
        }
        catch (Exception e) {
            throw AnalyticsApiException.wrap(e);
        }
    }

    public List<AnalyticsExecution> getCompletedExecutions(Long projectId, int size) throws AnalyticsApiException {
        try {
            URIBuilder builder = this.getTestOpsUriBuilder("/api/v1/search");
            AnalyticsQuery query = new AnalyticsQuery();
            query.setType("Execution");
            AnalyticsQueryCondition conditionProject = new AnalyticsQueryCondition("Project.id", "=", projectId.toString());
            AnalyticsQueryCondition conditionStage = new AnalyticsQueryCondition("executionStage", "=", "COMPLETED");
            AnalyticsQueryCondition conditionStatus = new AnalyticsQueryCondition("status", "!=", "INCOMPLETE");
            query.setConditions(new AnalyticsQueryCondition[]{conditionProject, conditionStage, conditionStatus});
            AnalyticsQueryPagination pagination = new AnalyticsQueryPagination(0, size, new String[]{"order,desc"});
            query.setPagination(pagination);
            builder.setParameter("q", JsonUtil.toJson((Object)query));
            HttpGet httpGet = new HttpGet(builder.build().toASCIIString());
            httpGet.setConfig(this.addRequestTimeout());
            AnalyticsExecutionPage response = this.sendTestOpsRequest((HttpUriRequest)httpGet, AnalyticsExecutionPage.class);
            return Arrays.asList(response.getContent());
        }
        catch (Exception e) {
            throw AnalyticsApiException.wrap(e);
        }
    }

    public List<AnalyticsExecution> getCompletedExecutionTestSuite(Long projectId, String testSuitePath, String testSuiteName, int size) throws AnalyticsApiException {
        try {
            URIBuilder builder = this.getTestOpsUriBuilder("/api/v1/search");
            AnalyticsQuery query = new AnalyticsQuery();
            query.setType("ExecutionWithoutTestSuiteCollection");
            AnalyticsQueryCondition conditionProject = new AnalyticsQueryCondition("Project.id", "=", projectId.toString());
            AnalyticsQueryCondition conditionTestSuitePath = new AnalyticsQueryCondition("TestSuite.path", "=", testSuitePath);
            AnalyticsQueryCondition conditionTestSuiteName = new AnalyticsQueryCondition("TestSuite.name", "=", testSuiteName);
            AnalyticsQueryCondition conditionTestSuiteType = new AnalyticsQueryCondition("TestSuite.type", "=", "KATALON_STUDIO");
            AnalyticsQueryCondition conditionStage = new AnalyticsQueryCondition("executionStage", "=", "COMPLETED");
            AnalyticsQueryCondition conditionStatus = new AnalyticsQueryCondition("status", "!=", "INCOMPLETE");
            query.setConditions(new AnalyticsQueryCondition[]{conditionProject, conditionTestSuitePath, conditionTestSuiteName, conditionTestSuiteType, conditionStage, conditionStatus});
            AnalyticsQueryPagination pagination = new AnalyticsQueryPagination(0, size, new String[]{"id,desc"});
            query.setPagination(pagination);
            builder.setParameter("q", JsonUtil.toJson((Object)query));
            HttpGet httpGet = new HttpGet(builder.build().toASCIIString());
            httpGet.setConfig(this.addRequestTimeout());
            AnalyticsExecutionPage response = this.sendTestOpsRequest((HttpUriRequest)httpGet, AnalyticsExecutionPage.class);
            return Arrays.asList(response.getContent());
        }
        catch (Exception e) {
            throw AnalyticsApiException.wrap(e);
        }
    }

    public TestOpsProjectStatistics getProjectStatisticsInLast7Days(Long projectId) throws AnalyticsApiException {
        try {
            URIBuilder builder = this.getTestOpsUriBuilder("/api/v1/search");
            AnalyticsQuery query = new AnalyticsQuery();
            query.setType("ProjectStatisticsCustomizeTime");
            ZonedDateTime today = ZonedDateTime.now();
            ZonedDateTime last7Days = today.minusDays(6L);
            ZonedDateTime startTime = last7Days.with(LocalTime.of(0, 0, 0));
            ZonedDateTime endTime = today.with(LocalTime.of(23, 59, 59));
            DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ssxxx");
            String startTimeString = startTime.format(formatter);
            String endTimeString = endTime.format(formatter);
            AnalyticsQueryCondition conditionProject = new AnalyticsQueryCondition("Project.id", "=", projectId.toString());
            AnalyticsQueryCondition conditionStartTime = new AnalyticsQueryCondition("startTime", ">=", startTimeString);
            AnalyticsQueryCondition conditionEndTime = new AnalyticsQueryCondition("startTime", "<=", endTimeString);
            query.setConditions(new AnalyticsQueryCondition[]{conditionProject, conditionStartTime, conditionEndTime});
            AnalyticsQueryPagination pagination = new AnalyticsQueryPagination(0, 30, new String[]{"name,asc"});
            query.setPagination(pagination);
            builder.setParameter("q", JsonUtil.toJson((Object)query));
            HttpGet httpGet = new HttpGet(builder.build().toASCIIString());
            httpGet.setConfig(this.addRequestTimeout());
            TestOpsProjectStatisticsPage response = this.sendTestOpsRequest((HttpUriRequest)httpGet, TestOpsProjectStatisticsPage.class);
            return Arrays.asList(response.getContent()).get(0);
        }
        catch (Exception e) {
            throw AnalyticsApiException.wrap(e);
        }
    }

    public TestOpsTotalExecutionStatistics getTotalExecutionsStatistics(Long projectId) throws AnalyticsApiException {
        try {
            ZonedDateTime now = ZonedDateTime.now();
            DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ssxxx");
            String nowString = now.format(formatter);
            URIBuilder uriBuilder = this.getTestOpsUriBuilder("/api/v1/total-execution-comparison");
            uriBuilder.setParameter("projectId", String.valueOf(projectId));
            uriBuilder.setParameter("timeString", nowString);
            HttpGet httpGet = new HttpGet(uriBuilder.build().toASCIIString());
            httpGet.setConfig(this.addRequestTimeout());
            return this.sendTestOpsRequest((HttpUriRequest)httpGet, TestOpsTotalExecutionStatistics.class);
        }
        catch (Exception e) {
            throw AnalyticsApiException.wrap(e);
        }
    }

    public List<AnalyticsFeature> getFeatures(long organizationId, String ksVersion) throws AnalyticsApiException {
        try {
            URIBuilder uriBuilder = this.getAdminUriBuilder("/api/v1/features");
            uriBuilder.setParameter("organizationId", String.valueOf(organizationId));
            uriBuilder.setParameter("ksVersion", ksVersion);
            HttpGet httpGet = new HttpGet(uriBuilder.build());
            List features = this.sendAdminRequest((HttpUriRequest)httpGet, new TypeToken<ArrayList<AnalyticsFeature>>(){});
            return features;
        }
        catch (Exception e) {
            throw AnalyticsApiException.wrap(e);
        }
    }

    public AnalyticsPageBaseResource getUserSession(String machineId, Long orgId) throws AnalyticsApiException {
        try {
            URIBuilder uriBuilder = this.getAdminUriBuilder("/api/v1/search");
            AnalyticsQuery query = new AnalyticsQuery();
            query.setType("KsSession");
            LinkedList<AnalyticsQueryCondition> conditions = new LinkedList<AnalyticsQueryCondition>();
            AnalyticsQueryCondition conditionMachineId = new AnalyticsQueryCondition("machineId", "contains", machineId);
            conditions.add(conditionMachineId);
            AnalyticsQueryCondition conditionOrg = new AnalyticsQueryCondition("Organization.id", "=", String.valueOf(orgId));
            conditions.add(conditionOrg);
            query.setConditions(conditions.toArray(new AnalyticsQueryCondition[conditions.size()]));
            query.setFunctions(new AnalyticsQueryFunction[0]);
            AnalyticsQueryPagination pagination = new AnalyticsQueryPagination(0, 30, new String[]{"startTime,desc"});
            query.setPagination(pagination);
            query.setGroupBys(new String[0]);
            HttpPost httpPost = new HttpPost(uriBuilder.build().toASCIIString());
            httpPost.setEntity((HttpEntity)this.asBodyEntity(query));
            return this.sendAdminRequest((HttpUriRequest)httpPost, AnalyticsPageBaseResource.class);
        }
        catch (Exception e) {
            throw AnalyticsApiException.wrap(e);
        }
    }

    public AnalyticsLicenseKey getLicenseKey(Long organizationId, String sessionId, String hostname, String machineId, String type, String subDomain, boolean isSilentLog) throws AnalyticsApiException {
        try {
            URIBuilder uriBuilder = this.getAdminUriBuilder("/api/v1/license-keys/activate");
            uriBuilder.setParameter("machineKey", String.valueOf(machineId));
            uriBuilder.setParameter("ksVersion", VersionUtil.getCurrentVersion().getVersion());
            uriBuilder.setParameter("organizationId", organizationId == null ? "" : Long.toString(organizationId));
            uriBuilder.setParameter("sessionId", sessionId);
            uriBuilder.setParameter("hostname", hostname);
            uriBuilder.setParameter("idpType", StringUtils.defaultString((String)type));
            uriBuilder.setParameter("subdomain", StringUtils.defaultString((String)subDomain));
            KatalonPackage katalonPackage = KatalonApplication.getKatalonPackage();
            if (KatalonPackage.ENGINE.equals((Object)katalonPackage) && KatalonApplication.isRunningInDevOpsEnvironment()) {
                katalonPackage = KatalonPackage.FLOATING_ENGINE;
            }
            uriBuilder.setParameter("package", katalonPackage.getPackageName());
            KatalonEdition edition = ApplicationInfo.getKatalonEdition();
            if (edition == KatalonEdition.FREE) {
                uriBuilder.setParameter("licenseType", "free");
            } else if (edition == KatalonEdition.ENTERPRISE) {
                uriBuilder.setParameter("licenseType", "trial,enterprise");
            }
            uriBuilder.setParameter("katalonEdition", edition.toString());
            HttpPost httpPost = new HttpPost(uriBuilder.build().toASCIIString());
            AnalyticsLicenseKey licenseKey = this.sendAdminRequest((HttpUriRequest)httpPost, AnalyticsLicenseKey.class, isSilentLog);
            return licenseKey;
        }
        catch (Exception e) {
            throw AnalyticsApiException.wrap(e);
        }
    }

    public void deactivate(String machineId, Long orgId) throws AnalyticsApiException {
        try {
            URIBuilder uriBuilder = this.getAdminUriBuilder("/api/v1/machine");
            uriBuilder.setParameter("machineKey", machineId);
            uriBuilder.setParameter("package", KatalonApplication.getKatalonPackage().getPackageName());
            if (orgId != null) {
                uriBuilder.setParameter("organizationId", String.valueOf(orgId));
            }
            HttpDelete httpPost = new HttpDelete(uriBuilder.build().toASCIIString());
            this.sendAdminRequest((HttpUriRequest)httpPost, Object.class);
        }
        catch (Exception e) {
            throw AnalyticsApiException.wrap(e);
        }
    }

    public void releaseLicense(String machineId, String ksVersion, String sessionId, Long orgId) throws AnalyticsApiException {
        try {
            URIBuilder uriBuilder = this.getAdminUriBuilder("/api/v1/license-keys/release");
            uriBuilder.setParameter("machineKey", machineId);
            uriBuilder.setParameter("ksVersion", ksVersion);
            uriBuilder.setParameter("sessionId", sessionId);
            uriBuilder.setParameter("package", KatalonApplication.getKatalonPackage().getPackageName());
            if (orgId != null) {
                uriBuilder.setParameter("organizationId", String.valueOf(orgId));
            }
            HttpPost httpPost = new HttpPost(uriBuilder.build().toASCIIString());
            this.sendAdminRequest((HttpUriRequest)httpPost, Object.class);
        }
        catch (Exception e) {
            throw AnalyticsApiException.wrap(e);
        }
    }

    public Date getExpirationOnline(Long orgId) throws AnalyticsApiException {
        return this.getExpirationOnline(orgId, KatalonApplication.getKatalonPackage());
    }

    public Date getExpirationOnline(Long orgId, KatalonPackage katalonPackage) throws AnalyticsApiException {
        try {
            URIBuilder uriBuilder = this.getAdminUriBuilder("/api/v1/subscription/expiration");
            uriBuilder.setParameter("feature", katalonPackage.getPackageName());
            if (orgId != null) {
                uriBuilder.setParameter("organizationId", String.valueOf(orgId));
            }
            HttpGet httpGet = new HttpGet(uriBuilder.build().toASCIIString());
            return this.sendAdminRequest((HttpUriRequest)httpGet, Date.class);
        }
        catch (Exception e) {
            throw AnalyticsApiException.wrap(e);
        }
    }

    public String getTestOpsServerFromUser() throws AnalyticsApiException {
        AnalyticsUser analyticsUser = this.getUser();
        if (analyticsUser != null && analyticsUser.getConfigs() != null && StringUtils.isNotEmpty((CharSequence)analyticsUser.getConfigs().getIoServerUrl())) {
            return analyticsUser.getConfigs().getIoServerUrl();
        }
        return null;
    }

    public AnalyticsUser getUser() throws AnalyticsApiException {
        try {
            URIBuilder uriBuilder = this.getAdminUriBuilder("/api/v1/users/me");
            HttpGet httpGet = new HttpGet(uriBuilder.build().toASCIIString());
            AnalyticsUser user = this.sendAdminRequest((HttpUriRequest)httpGet, AnalyticsUser.class);
            return user;
        }
        catch (Exception e) {
            throw AnalyticsApiException.wrap(e);
        }
    }

    public TestOpsUsage getUserUsageWithRetry(Long orgId) throws AnalyticsApiException {
        return this.getUserUsageWithRetry(orgId, 3);
    }

    public TestOpsUsage getUserUsageWithRetry(Long orgId, int retryTimes) throws AnalyticsApiException {
        int counter = 0;
        AnalyticsApiException lastError = null;
        while (counter++ < retryTimes) {
            try {
                return this.getUserUsage(orgId);
            }
            catch (AnalyticsApiException error) {
                lastError = error;
            }
        }
        if (lastError != null) {
            throw lastError;
        }
        return null;
    }

    public TestOpsUsage getUserUsage(Long orgId) throws AnalyticsApiException {
        try {
            URIBuilder uriBuilder = this.getKatOneUriBuilder("/v1/test-result-counts");
            String query = JsonBuilder.object().array("filters", new Object[]{JsonBuilder.object().property("field", (Object)"organizationId").property("operator", (Object)"EQ").property("value", (Object)orgId).build()}).array("sorts", new Object[]{JsonBuilder.object().property("field", (Object)"createdAt").property("desc", (Object)true).build()}).property("limit", (Object)1).toJson();
            HttpRequestBase request = RequestBuilder.get().uri(uriBuilder).body(query).build();
            return this.sendKatOneRequest((HttpUriRequest)request, TestOpsUsage.class);
        }
        catch (AnalyticsApiException error) {
            throw error;
        }
        catch (Exception error) {
            throw AnalyticsApiException.wrap(error);
        }
    }

    public String buildQueryParam(String type, String conditions, String functions, String pageNumber, String sizeOfPage, String sortedBy, String groupBys) {
        return MessageFormat.format("'{' \"type\": \"{0}\", \"conditions\": [{1}], \"functions\": [{2}], \"pagination\": '{' \"page\": {3}, \"size\": {4}, \"sorts\": [\"{5}\"] '}', \"groupBys\": [{6}] '}'", type, conditions, functions, pageNumber, sizeOfPage, sortedBy, groupBys);
    }

    public AuthenticationToken grabAdminToken(AuthenticationToken katOneToken) throws AnalyticsApiException {
        AnalyticsTokenInfo tokenInfo = this.requestToken(this.getAdminServer(), "", "access_token_" + katOneToken.getAccessToken());
        this.transferTokenInfo(tokenInfo, this.getAdminToken(), this.getAdminServer());
        this.transferTokenInfo(tokenInfo, this.getTestOpsToken(), this.getTestOpsServer());
        return this.getAdminToken();
    }
}

