/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.integration.analytics.report;

import com.kms.katalon.application.utils.ApplicationInfo;
import com.kms.katalon.core.configuration.RunConfiguration;
import com.kms.katalon.core.logging.model.TestSuiteCollectionLogRecord;
import com.kms.katalon.core.logging.model.TestSuiteLogRecord;
import com.kms.katalon.entity.testsuite.TestSuiteEntity;
import com.kms.katalon.execution.console.entity.ConsoleOption;
import com.kms.katalon.execution.console.entity.LongConsoleOption;
import com.kms.katalon.execution.entity.IExecutedEntity;
import com.kms.katalon.execution.entity.ReportFolder;
import com.kms.katalon.execution.entity.TestSuiteCollectionExecutedEntity;
import com.kms.katalon.execution.entity.TestSuiteExecutedEntity;
import com.kms.katalon.execution.integration.ReportIntegrationContribution;
import com.kms.katalon.execution.launcher.result.ExecutionEntityResult;
import com.kms.katalon.execution.launcher.result.LauncherStatus;
import com.kms.katalon.integration.analytics.AnalyticsComponent;
import com.kms.katalon.integration.analytics.constants.IntegrationAnalyticsMessages;
import com.kms.katalon.integration.analytics.entity.AnalyticsTestRun;
import com.kms.katalon.integration.analytics.entity.AnalyticsTracking;
import com.kms.katalon.integration.analytics.report.AnalyticsReportHelper;
import com.kms.katalon.integration.analytics.report.AnalyticsReportService;
import com.kms.katalon.logging.LogUtil;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import org.apache.commons.lang.StringUtils;

public class AnalyticsReportIntegration
implements ReportIntegrationContribution,
AnalyticsComponent {
    public static final String TESTOPS_RELEASE_ID_CONSOLE_OPTION_NAME = "testOpsReleaseId";
    public static final String TESTOPS_PROJECT_ID_CONSOLE_OPTION_NAME = "testOpsProjectId";
    public static final String TESTOPS_BUILD_ID_CONSOLE_OPTION_NAME = "testOpsBuildId";
    public static final String TESTOPS_TRACK_INTEGRATION_ENABLED = "testops_integration_enabled";
    public static final String TESTOPS_PREFIX = "testOps.";
    private static Long TESTOPS_RELEASE_ID = null;
    private static Long TESTOPS_PROJECT_ID = null;
    private static Long TESTOPS_BUILD_ID = null;
    private static final Object lock = new Object();
    private List<ConsoleOption<?>> integrationCommandList;
    private Map<String, Object> testOpsGenericCommandMap = new LinkedHashMap<String, Object>();
    public static final LongConsoleOption TESTOPS_RELEASE_ID_CONSOLE_OPTION = new LongConsoleOption(){

        public String getOption() {
            return AnalyticsReportIntegration.TESTOPS_RELEASE_ID_CONSOLE_OPTION_NAME;
        }

        public Long getValue() {
            return TESTOPS_RELEASE_ID;
        }
    };
    private static final LongConsoleOption TESTOPS_PROJECT_ID_CONSOLE_OPTION = new LongConsoleOption(){

        public String getOption() {
            return AnalyticsReportIntegration.TESTOPS_PROJECT_ID_CONSOLE_OPTION_NAME;
        }

        public Long getValue() {
            return TESTOPS_PROJECT_ID;
        }
    };
    private static final LongConsoleOption TESTOPS_BUILD_ID_CONSOLE_OPTION = new LongConsoleOption(){

        public String getOption() {
            return AnalyticsReportIntegration.TESTOPS_BUILD_ID_CONSOLE_OPTION_NAME;
        }

        public Long getValue() {
            return TESTOPS_BUILD_ID;
        }
    };
    private AnalyticsReportService reportService = new AnalyticsReportService();

    public AnalyticsReportIntegration() {
        this.integrationCommandList = new ArrayList();
        this.integrationCommandList.add((ConsoleOption<?>)TESTOPS_RELEASE_ID_CONSOLE_OPTION);
        this.integrationCommandList.add((ConsoleOption<?>)TESTOPS_PROJECT_ID_CONSOLE_OPTION);
        this.integrationCommandList.add((ConsoleOption<?>)TESTOPS_BUILD_ID_CONSOLE_OPTION);
    }

    public static LongConsoleOption getConsoleOption(String optionName) throws NoSuchElementException {
        switch (optionName) {
            case "testOpsProjectId": {
                return TESTOPS_PROJECT_ID_CONSOLE_OPTION;
            }
            case "testOpsReleaseId": {
                return TESTOPS_RELEASE_ID_CONSOLE_OPTION;
            }
            case "testOpsBuildId": {
                return TESTOPS_BUILD_ID_CONSOLE_OPTION;
            }
        }
        throw new NoSuchElementException(MessageFormat.format(IntegrationAnalyticsMessages.MSG_EXCEPTION_NO_CONSOLE_OPTION, optionName));
    }

    public void setConsoleOptionList(List<ConsoleOption<?>> list) {
        this.integrationCommandList = list;
    }

    public List<ConsoleOption<?>> getConsoleOptionList() {
        return this.integrationCommandList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setArgumentValue(ConsoleOption<?> consoleOption, String argumentValue) throws Exception {
        String param;
        String optionName;
        String[] split;
        if (StringUtils.isBlank((String)argumentValue)) {
            return;
        }
        if (consoleOption == TESTOPS_RELEASE_ID_CONSOLE_OPTION) {
            try {
                TESTOPS_RELEASE_ID = Long.parseLong(argumentValue.trim());
            }
            catch (Exception e) {
                LogUtil.logError((Throwable)e);
            }
            return;
        }
        if (consoleOption == TESTOPS_PROJECT_ID_CONSOLE_OPTION) {
            try {
                TESTOPS_PROJECT_ID = Long.parseLong(argumentValue.trim());
            }
            catch (Exception e) {
                LogUtil.logError((Throwable)e);
            }
            return;
        }
        if (consoleOption == TESTOPS_BUILD_ID_CONSOLE_OPTION) {
            try {
                Object e = lock;
                synchronized (e) {
                    TESTOPS_BUILD_ID = Long.parseLong(argumentValue.trim());
                }
            }
            catch (NumberFormatException e) {
                LogUtil.logError((Throwable)e);
            }
        }
        if (consoleOption.getOption().startsWith(TESTOPS_PREFIX) && (split = (optionName = consoleOption.getOption()).split("\\.")).length == 2 && StringUtils.isNotBlank((String)(param = split[1])) && StringUtils.isNotBlank((String)argumentValue)) {
            this.testOpsGenericCommandMap.put(StringUtils.substring((String)param, (int)0, (int)50), StringUtils.substring((String)argumentValue, (int)0, (int)256));
        }
    }

    public boolean isIntegrationActive(TestSuiteEntity testSuite) {
        try {
            return this.getSettingStore().isIntegrationEnabled();
        }
        catch (Exception e) {
            LogUtil.logError((Throwable)e);
            return false;
        }
    }

    public void uploadTestSuiteResult(TestSuiteLogRecord suiteLogRecord) throws Exception {
        String collectionId = suiteLogRecord.getTestSuiteCollectionId();
        if (StringUtils.isNotBlank((String)collectionId)) {
            return;
        }
        ReportFolder reportFolder = new ReportFolder(suiteLogRecord.getLogFolder());
        this.reportService.upload(reportFolder);
    }

    public void uploadTestSuiteCollectionResult(TestSuiteCollectionLogRecord collectionLogRecord) throws Exception {
        List suiteLogRecords = collectionLogRecord.getTestSuiteRecords();
        ArrayList<String> paths = new ArrayList<String>();
        for (TestSuiteLogRecord suiteLogRecord : suiteLogRecords) {
            paths.add(suiteLogRecord.getLogFolder());
        }
        paths.add(collectionLogRecord.getReportFolder());
        ReportFolder reportFolder = new ReportFolder(paths);
        this.reportService.upload(reportFolder);
    }

    public void printIntegrateMessage() {
        LogUtil.printOutputLine((String)IntegrationAnalyticsMessages.MSG_INTEGRATE_WITH_KA);
    }

    public void notifyProccess(Object event, ExecutionEntityResult result) {
        try {
            IExecutedEntity executedEntity = result.getExecutedEntity();
            if (!(executedEntity instanceof TestSuiteExecutedEntity) && !(executedEntity instanceof TestSuiteCollectionExecutedEntity)) {
                return;
            }
            boolean integrationActive = this.getSettingStore().isIntegrationEnabled();
            boolean isUploadReport = this.getSettingStore().isAutoUploadReportEnabled();
            if (!integrationActive || !isUploadReport) {
                return;
            }
            if (AnalyticsReportHelper.getInstance().isTestopsIntegrationEnabled()) {
                if (executedEntity instanceof TestSuiteExecutedEntity) {
                    if (ApplicationInfo.isPlatformStudio() && RunConfiguration.getInstance().isLaunchingDebugMode()) {
                        return;
                    }
                    AnalyticsTestRun testRun = new AnalyticsTestRun();
                    testRun.setName(result.getName());
                    testRun.setSessionId(result.getSessionId());
                    if (result.getTestStatusValue() != null) {
                        testRun.setStatus(result.getTestStatusValue().name());
                    }
                    testRun.setTestSuiteId(executedEntity.getSourceId());
                    testRun.setEnd(result.isEnd());
                    if (event instanceof LauncherStatus) {
                        LauncherStatus status = (LauncherStatus)event;
                        switch (status) {
                            case WAITING: 
                            case TERMINATED: {
                                break;
                            }
                            default: {
                                this.reportService.updateExecutionProccess(testRun);
                                break;
                            }
                        }
                    } else {
                        this.reportService.updateExecutionProccess(testRun);
                    }
                } else if (executedEntity instanceof TestSuiteCollectionExecutedEntity) {
                    AnalyticsTestRun testRun = new AnalyticsTestRun();
                    testRun.setSessionId(result.getSessionId());
                    testRun.setEnd(result.isEnd());
                    this.reportService.updateExecutionProccess(testRun);
                }
            }
        }
        catch (Exception e) {
            LogUtil.logError((Throwable)e);
        }
    }

    public void sendTrackingActivity(Long organizationId, String machineId, String sessionId, Date startTime, Date endTime, String ksVersion) {
        try {
            AnalyticsTracking trackingInfo = new AnalyticsTracking();
            trackingInfo.setMachineId(machineId);
            trackingInfo.setSessionId(sessionId);
            trackingInfo.setStartTime(startTime);
            trackingInfo.setEndTime(endTime);
            trackingInfo.setKsVersion(ksVersion);
            trackingInfo.setOrganizationId(organizationId);
            this.reportService.sendTrackingActivity(trackingInfo);
        }
        catch (Exception exception) {}
    }

    public boolean shouldUploadReportWhenIncomplete() {
        return true;
    }

    public boolean isNeededTrackingData() {
        return true;
    }

    public Map<String, Object> getTrackingProperties() {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        boolean isIntegrationEnabled = this.getSettingStore().isIntegrationEnabled();
        properties.put(TESTOPS_TRACK_INTEGRATION_ENABLED, isIntegrationEnabled);
        return properties;
    }

    public Map<String, Object> getTestOpsGenericCommandMap() {
        return this.testOpsGenericCommandMap;
    }
}

