/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.integration.analytics.util;

import com.kms.katalon.logging.LogUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.Arrays;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.FilenameUtils;

public class ZipHelper {
    private static final List<String> ignoreFileArray = Arrays.asList(".class", ".log", ".ctxt", ".jar", ".war", ".ear", ".zip", ".tar.gz", ".rar", ".project", ".classpath");
    private static final List<String> ignoreFolderArray = Arrays.asList(".mtj.tmp", "hs_err_pid", "Libs", "bin", ".git", "Reports");

    public static void Compress(String srcFolder, String destZipFile) {
        try {
            FileOutputStream fileWriteStream = new FileOutputStream(destZipFile);
            ZipOutputStream zipStream = new ZipOutputStream(fileWriteStream);
            ZipHelper.addFolderToZip("", srcFolder, zipStream);
            zipStream.flush();
            zipStream.close();
        }
        catch (Exception e) {
            LogUtil.logError((Throwable)e);
        }
    }

    private static void addFileToZip(String path, String srcFile, ZipOutputStream zip) throws Exception {
        File folder = new File(srcFile);
        if (folder != null) {
            if (folder.isDirectory()) {
                ZipHelper.addFolderToZip(path, srcFile, zip);
            } else {
                String extensionFile = "." + FilenameUtils.getExtension((String)folder.toString());
                if (!ignoreFileArray.contains(extensionFile)) {
                    int len;
                    byte[] buf = new byte[1024];
                    FileInputStream inputStream = new FileInputStream(srcFile);
                    zip.putNextEntry(new ZipEntry(String.valueOf(path) + "/" + folder.getName()));
                    while ((len = inputStream.read(buf)) > 0) {
                        zip.write(buf, 0, len);
                    }
                    inputStream.close();
                }
            }
        }
    }

    private static void addFolderToZip(String path, String srcFolder, ZipOutputStream zip) throws Exception {
        File folder = new File(srcFolder);
        if (folder != null) {
            String[] stringArray = folder.list();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String fileName = stringArray[n2];
                if (!ignoreFolderArray.contains(fileName) && !ignoreFileArray.contains(fileName)) {
                    if (path.equals("")) {
                        ZipHelper.addFileToZip(folder.getName(), String.valueOf(srcFolder) + "/" + fileName, zip);
                    } else {
                        ZipHelper.addFileToZip(String.valueOf(path) + "/" + folder.getName(), String.valueOf(srcFolder) + "/" + fileName, zip);
                    }
                }
                ++n2;
            }
        }
    }
}

