/*
 * Decompiled with CFR 0.152.
 */
package graphql.execution;

import graphql.Assert;
import graphql.GraphQLError;
import graphql.PublicApi;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

@PublicApi
public class DataFetcherExceptionHandlerResult {
    private final List<GraphQLError> errors;

    private DataFetcherExceptionHandlerResult(Builder builder) {
        this.errors = builder.errors;
    }

    public List<GraphQLError> getErrors() {
        return this.errors;
    }

    public static Builder newResult() {
        return new Builder();
    }

    public static Builder newResult(GraphQLError error) {
        return new Builder().error(error);
    }

    public static class Builder {
        private final List<GraphQLError> errors = new ArrayList<GraphQLError>();

        public Builder errors(List<GraphQLError> errors2) {
            this.errors.addAll((Collection<GraphQLError>)Assert.assertNotNull(errors2));
            return this;
        }

        public Builder error(GraphQLError error) {
            this.errors.add(Assert.assertNotNull(error));
            return this;
        }

        public DataFetcherExceptionHandlerResult build() {
            return new DataFetcherExceptionHandlerResult(this);
        }
    }
}

