/*
 * Decompiled with CFR 0.152.
 */
package graphql.execution.instrumentation.fieldvalidation;

import graphql.GraphQLError;
import graphql.PublicApi;
import graphql.com.google.common.collect.ImmutableList;
import graphql.execution.ResultPath;
import graphql.execution.instrumentation.fieldvalidation.FieldAndArguments;
import graphql.execution.instrumentation.fieldvalidation.FieldValidation;
import graphql.execution.instrumentation.fieldvalidation.FieldValidationEnvironment;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiFunction;

@PublicApi
public class SimpleFieldValidation
implements FieldValidation {
    private final Map<ResultPath, BiFunction<FieldAndArguments, FieldValidationEnvironment, Optional<GraphQLError>>> rules = new LinkedHashMap<ResultPath, BiFunction<FieldAndArguments, FieldValidationEnvironment, Optional<GraphQLError>>>();

    public SimpleFieldValidation addRule(ResultPath fieldPath, BiFunction<FieldAndArguments, FieldValidationEnvironment, Optional<GraphQLError>> rule) {
        this.rules.put(fieldPath, rule);
        return this;
    }

    @Override
    public List<GraphQLError> validateFields(FieldValidationEnvironment validationEnvironment) {
        ArrayList errors2 = new ArrayList();
        for (ResultPath fieldPath : this.rules.keySet()) {
            List<FieldAndArguments> fieldAndArguments = validationEnvironment.getFieldsByPath().get(fieldPath);
            if (fieldAndArguments == null) continue;
            BiFunction<FieldAndArguments, FieldValidationEnvironment, Optional<GraphQLError>> ruleFunction = this.rules.get(fieldPath);
            for (FieldAndArguments fieldAndArgument : fieldAndArguments) {
                Optional<GraphQLError> graphQLError = ruleFunction.apply(fieldAndArgument, validationEnvironment);
                graphQLError.ifPresent(errors2::add);
            }
        }
        return ImmutableList.copyOf(errors2);
    }
}

