/*
 * Decompiled with CFR 0.152.
 */
package graphql.parser;

import graphql.Internal;
import graphql.com.google.common.collect.ImmutableList;
import graphql.language.AbstractDescribedNode;
import graphql.language.Comment;
import graphql.language.Document;
import graphql.language.Node;
import graphql.org.antlr.v4.runtime.CommonTokenStream;
import graphql.org.antlr.v4.runtime.ParserRuleContext;
import graphql.org.antlr.v4.runtime.Token;
import graphql.parser.NodeToRuleCapturingParser;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;

@Internal
public class CommentParser {
    private final Map<Node<?>, ParserRuleContext> nodeToRuleMap;
    private CommonTokenStream tokens;
    private static final int CHANNEL_COMMENTS = 2;
    private final Predicate<Token> alwaysTrue = token -> true;
    private final Predicate<Token> isNotPrecededByLineBreak = refToken -> Optional.ofNullable(this.tokens.getHiddenTokensToLeft(refToken.getTokenIndex(), -1)).map(hiddenTokens -> hiddenTokens.stream().noneMatch(token -> token.getText().equals("\n"))).orElse(false);
    private final Predicate<Token> isPrecededByLineBreak = refToken -> Optional.ofNullable(this.tokens.getHiddenTokensToLeft(refToken.getTokenIndex(), -1)).map(hiddenTokens -> hiddenTokens.stream().anyMatch(token -> token.getText().equals("\n"))).orElse(false);
    private final Predicate<Token> isFirstToken = refToken -> refToken.getTokenIndex() == 0;
    private final Predicate<Token> isPrecededOnlyBySpaces = refToken -> Optional.ofNullable(this.tokens.getTokens(0, refToken.getTokenIndex() - 1)).map(beforeTokens -> beforeTokens.stream().allMatch(token -> token.getText().equals(" "))).orElse(false);

    public CommentParser(NodeToRuleCapturingParser.ParserContext parserContext) {
        this.nodeToRuleMap = parserContext.getNodeToRuleMap();
        this.tokens = parserContext.getTokens();
    }

    public Optional<Comment> getBeginningOfBlockComment(Node<?> node, String prefix) {
        ParserRuleContext ctx = this.nodeToRuleMap.get(node);
        Token start2 = ctx.start;
        if (start2 != null) {
            return this.tokens.getTokens(start2.getTokenIndex(), ctx.stop.getTokenIndex()).stream().filter(token -> token.getText().equals(prefix)).findFirst().map(token -> this.tokens.getHiddenTokensToRight(token.getTokenIndex(), 2)).map(commentTokens -> this.getCommentOnChannel((List<Token>)commentTokens, this.isNotPrecededByLineBreak)).flatMap(comments -> comments.stream().findFirst());
        }
        return Optional.empty();
    }

    public List<Comment> getEndOfBlockComments(Node<?> node, String blockSuffix) {
        ParserRuleContext ctx = this.nodeToRuleMap.get(node);
        return this.searchTokenToLeft(ctx.stop, blockSuffix).map(suffixToken -> this.tokens.getHiddenTokensToLeft(suffixToken.getTokenIndex(), 2)).map(commentTokens -> this.getCommentOnChannel((List<Token>)commentTokens, this.isPrecededByLineBreak)).orElse(Collections.emptyList());
    }

    public Optional<Comment> getTrailingComment(Node<?> node) {
        if (!(node instanceof AbstractDescribedNode)) {
            return Optional.empty();
        }
        ParserRuleContext ctx = this.nodeToRuleMap.get(node);
        List<Token> rightRefChannel = this.tokens.getHiddenTokensToRight(ctx.stop.getTokenIndex(), 2);
        if (rightRefChannel != null) {
            List<Comment> comments = this.getCommentOnChannel(rightRefChannel, this.isNotPrecededByLineBreak);
            return comments.stream().findFirst();
        }
        return Optional.empty();
    }

    public List<Comment> getLeadingComments(Node<?> node) {
        int tokPos;
        List<Token> leftRefChannel;
        ParserRuleContext ctx = this.nodeToRuleMap.get(node);
        Token start2 = ctx.start;
        if (start2 != null && (leftRefChannel = this.tokens.getHiddenTokensToLeft(tokPos = start2.getTokenIndex(), 2)) != null) {
            return this.getCommentOnChannel(leftRefChannel, this.isPrecededByLineBreak);
        }
        return Collections.emptyList();
    }

    public List<Comment> getCommentsAfterDescription(Node<?> node) {
        List<Token> commentTokens;
        if (!(node instanceof AbstractDescribedNode) || node instanceof AbstractDescribedNode && ((AbstractDescribedNode)node).getDescription() == null) {
            return Collections.emptyList();
        }
        ParserRuleContext ctx = this.nodeToRuleMap.get(node);
        Token start2 = ctx.start;
        if (start2 != null && (commentTokens = this.tokens.getHiddenTokensToRight(start2.getTokenIndex(), 2)) != null) {
            return this.getCommentOnChannel(commentTokens, this.isPrecededByLineBreak);
        }
        return Collections.emptyList();
    }

    public Optional<Comment> getCommentOnFirstLineOfDocument(Document node) {
        int tokPos;
        List<Token> leftRefChannel;
        ParserRuleContext ctx = this.nodeToRuleMap.get(node);
        Token start2 = ctx.start;
        if (start2 != null && (leftRefChannel = this.tokens.getHiddenTokensToLeft(tokPos = start2.getTokenIndex(), 2)) != null) {
            List<Comment> comments = this.getCommentOnChannel(leftRefChannel, this.isFirstToken.or(this.isPrecededOnlyBySpaces));
            return comments.stream().findFirst();
        }
        return Optional.empty();
    }

    public List<Comment> getCommentsAfterAllDefinitions(Document node) {
        List<Token> leftRefChannel;
        ParserRuleContext ctx = this.nodeToRuleMap.get(node);
        Token start2 = ctx.start;
        if (start2 != null && (leftRefChannel = this.tokens.getHiddenTokensToRight(ctx.stop.getTokenIndex(), 2)) != null) {
            return this.getCommentOnChannel(leftRefChannel, refToken -> Optional.ofNullable(this.tokens.getHiddenTokensToLeft(refToken.getTokenIndex(), -1)).map(hiddenTokens -> hiddenTokens.stream().anyMatch(token -> token.getText().equals("\n"))).orElse(false));
        }
        return Collections.emptyList();
    }

    protected List<Comment> getCommentOnChannel(List<Token> refChannel, Predicate<Token> shouldIncludePredicate) {
        ImmutableList.Builder comments = ImmutableList.builder();
        for (Token refTok : refChannel) {
            boolean shouldIncludeComment;
            String text = refTok.getText();
            if (text == null || !(shouldIncludeComment = shouldIncludePredicate.test(refTok))) continue;
            text = text.replaceFirst("^#", "");
            comments.add(new Comment(text, null));
        }
        return comments.build();
    }

    private Optional<Token> searchTokenToLeft(Token token, String text) {
        for (int i = token.getTokenIndex(); i > 0; --i) {
            Token t2 = this.tokens.get(i);
            if (!t2.getText().equals(text)) continue;
            return Optional.of(t2);
        }
        return Optional.empty();
    }
}

