/*
 * Decompiled with CFR 0.152.
 */
package graphql.schema.diffing;

import com.google.common.util.concurrent.AtomicDoubleArray;
import graphql.Internal;
import java.util.Arrays;

@Internal
public class HungarianAlgorithm {
    public final AtomicDoubleArray[] costMatrix;
    private final int rows;
    private final int cols;
    private final int dim;
    public final int[] matchJobByWorker;
    private final int[] matchWorkerByJob;
    private final int[] minSlackWorkerByJob;
    private final double[] minSlackValueByJob;
    private final int[] parentWorkerByCommittedJob;
    private final boolean[] committedWorkers;
    private final double[] labelByWorker;
    private final double[] labelByJob;

    public HungarianAlgorithm(AtomicDoubleArray[] costMatrix) {
        this.dim = Math.max(costMatrix.length, costMatrix[0].length());
        this.rows = costMatrix.length;
        this.cols = costMatrix[0].length();
        this.costMatrix = costMatrix;
        this.labelByWorker = new double[this.dim];
        this.labelByJob = new double[this.dim];
        this.minSlackWorkerByJob = new int[this.dim];
        this.minSlackValueByJob = new double[this.dim];
        this.committedWorkers = new boolean[this.dim];
        this.parentWorkerByCommittedJob = new int[this.dim];
        this.matchJobByWorker = new int[this.dim];
        Arrays.fill(this.matchJobByWorker, -1);
        this.matchWorkerByJob = new int[this.dim];
        Arrays.fill(this.matchWorkerByJob, -1);
    }

    protected void computeInitialFeasibleSolution() {
        for (int j = 0; j < this.dim; ++j) {
            this.labelByJob[j] = Double.POSITIVE_INFINITY;
        }
        for (int w = 0; w < this.dim; ++w) {
            for (int j = 0; j < this.dim; ++j) {
                if (!(this.costMatrix[w].get(j) < this.labelByJob[j])) continue;
                this.labelByJob[j] = this.costMatrix[w].get(j);
            }
        }
    }

    public int[] execute() {
        this.reduce();
        this.computeInitialFeasibleSolution();
        this.greedyMatch();
        int w = this.fetchUnmatchedWorker();
        while (w < this.dim) {
            this.initializePhase(w);
            this.executePhase();
            w = this.fetchUnmatchedWorker();
        }
        int[] result = Arrays.copyOf(this.matchJobByWorker, this.rows);
        for (w = 0; w < result.length; ++w) {
            if (result[w] < this.cols) continue;
            result[w] = -1;
        }
        return result;
    }

    protected void executePhase() {
        block0: while (true) {
            int minSlackWorker = -1;
            int minSlackJob = -1;
            double minSlackValue = Double.POSITIVE_INFINITY;
            for (int j = 0; j < this.dim; ++j) {
                if (this.parentWorkerByCommittedJob[j] != -1 || !(this.minSlackValueByJob[j] < minSlackValue)) continue;
                minSlackValue = this.minSlackValueByJob[j];
                minSlackWorker = this.minSlackWorkerByJob[j];
                minSlackJob = j;
            }
            if (minSlackValue > 0.0) {
                this.updateLabeling(minSlackValue);
            }
            this.parentWorkerByCommittedJob[minSlackJob] = minSlackWorker;
            if (this.matchWorkerByJob[minSlackJob] == -1) {
                int committedJob = minSlackJob;
                int parentWorker = this.parentWorkerByCommittedJob[committedJob];
                while (true) {
                    int temp = this.matchJobByWorker[parentWorker];
                    this.match(parentWorker, committedJob);
                    committedJob = temp;
                    if (committedJob == -1) break;
                    parentWorker = this.parentWorkerByCommittedJob[committedJob];
                }
                return;
            }
            int worker = this.matchWorkerByJob[minSlackJob];
            this.committedWorkers[worker] = true;
            int j = 0;
            while (true) {
                double slack;
                if (j >= this.dim) continue block0;
                if (this.parentWorkerByCommittedJob[j] == -1 && this.minSlackValueByJob[j] > (slack = this.costMatrix[worker].get(j) - this.labelByWorker[worker] - this.labelByJob[j])) {
                    this.minSlackValueByJob[j] = slack;
                    this.minSlackWorkerByJob[j] = worker;
                }
                ++j;
            }
            break;
        }
    }

    protected int fetchUnmatchedWorker() {
        int w;
        for (w = 0; w < this.dim && this.matchJobByWorker[w] != -1; ++w) {
        }
        return w;
    }

    protected void greedyMatch() {
        for (int w = 0; w < this.dim; ++w) {
            for (int j = 0; j < this.dim; ++j) {
                if (this.matchJobByWorker[w] != -1 || this.matchWorkerByJob[j] != -1 || this.costMatrix[w].get(j) - this.labelByWorker[w] - this.labelByJob[j] != 0.0) continue;
                this.match(w, j);
            }
        }
    }

    protected void initializePhase(int w) {
        Arrays.fill(this.committedWorkers, false);
        Arrays.fill(this.parentWorkerByCommittedJob, -1);
        this.committedWorkers[w] = true;
        for (int j = 0; j < this.dim; ++j) {
            this.minSlackValueByJob[j] = this.costMatrix[w].get(j) - this.labelByWorker[w] - this.labelByJob[j];
            this.minSlackWorkerByJob[j] = w;
        }
    }

    protected void match(int w, int j) {
        this.matchJobByWorker[w] = j;
        this.matchWorkerByJob[j] = w;
    }

    protected void reduce() {
        int j;
        int w;
        for (int w2 = 0; w2 < this.dim; ++w2) {
            int j2;
            double min2 = Double.POSITIVE_INFINITY;
            for (j2 = 0; j2 < this.dim; ++j2) {
                if (!(this.costMatrix[w2].get(j2) < min2)) continue;
                min2 = this.costMatrix[w2].get(j2);
            }
            for (j2 = 0; j2 < this.dim; ++j2) {
                this.costMatrix[w2].set(j2, this.costMatrix[w2].get(j2) - min2);
            }
        }
        double[] min3 = new double[this.dim];
        for (int j3 = 0; j3 < this.dim; ++j3) {
            min3[j3] = Double.POSITIVE_INFINITY;
        }
        for (w = 0; w < this.dim; ++w) {
            for (j = 0; j < this.dim; ++j) {
                if (!(this.costMatrix[w].get(j) < min3[j])) continue;
                min3[j] = this.costMatrix[w].get(j);
            }
        }
        for (w = 0; w < this.dim; ++w) {
            for (j = 0; j < this.dim; ++j) {
                this.costMatrix[w].set(j, this.costMatrix[w].get(j) - min3[j]);
            }
        }
    }

    protected void updateLabeling(double slack) {
        for (int w = 0; w < this.dim; ++w) {
            if (!this.committedWorkers[w]) continue;
            int n = w;
            this.labelByWorker[n] = this.labelByWorker[n] + slack;
        }
        for (int j = 0; j < this.dim; ++j) {
            if (this.parentWorkerByCommittedJob[j] != -1) {
                int n = j;
                this.labelByJob[n] = this.labelByJob[n] - slack;
                continue;
            }
            int n = j;
            this.minSlackValueByJob[n] = this.minSlackValueByJob[n] - slack;
        }
    }

    public int[] nextChild() {
        int currentJobAssigned = this.matchJobByWorker[0];
        this.costMatrix[0].set(currentJobAssigned, 2.147483647E9);
        this.matchWorkerByJob[currentJobAssigned] = -1;
        this.matchJobByWorker[0] = -1;
        this.minSlackValueByJob[currentJobAssigned] = 2.147483647E9;
        this.initializePhase(0);
        this.executePhase();
        int[] result = Arrays.copyOf(this.matchJobByWorker, this.rows);
        return result;
    }
}

