/*
 * Decompiled with CFR 0.152.
 */
package graphql.schema.idl;

import graphql.GraphQLError;
import graphql.InvalidSyntaxError;
import graphql.PublicApi;
import graphql.language.Definition;
import graphql.language.Document;
import graphql.language.SDLDefinition;
import graphql.parser.InvalidSyntaxException;
import graphql.parser.Parser;
import graphql.parser.ParserEnvironment;
import graphql.parser.ParserOptions;
import graphql.schema.idl.TypeDefinitionRegistry;
import graphql.schema.idl.errors.NonSDLDefinitionError;
import graphql.schema.idl.errors.SchemaProblem;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

@PublicApi
public class SchemaParser {
    public TypeDefinitionRegistry parse(File file) throws SchemaProblem {
        try {
            return this.parse(Files.newBufferedReader(file.toPath(), Charset.defaultCharset()));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public TypeDefinitionRegistry parse(InputStream inputStream) throws SchemaProblem {
        return this.parse(new InputStreamReader(inputStream));
    }

    public TypeDefinitionRegistry parse(Reader reader) throws SchemaProblem {
        return this.parse(reader, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public TypeDefinitionRegistry parse(Reader reader, ParserOptions parserOptions) throws SchemaProblem {
        try (Reader input = reader;){
            TypeDefinitionRegistry typeDefinitionRegistry = this.parseImpl(input, parserOptions);
            return typeDefinitionRegistry;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public TypeDefinitionRegistry parse(String schemaInput) throws SchemaProblem {
        return this.parseImpl(new StringReader(schemaInput));
    }

    public TypeDefinitionRegistry parseImpl(Reader schemaInput) {
        return this.parseImpl(schemaInput, null);
    }

    private TypeDefinitionRegistry parseImpl(Reader schemaInput, ParserOptions parseOptions) {
        try {
            if (parseOptions == null) {
                parseOptions = ParserOptions.getDefaultSdlParserOptions();
            }
            ParserEnvironment parserEnvironment = ParserEnvironment.newParserEnvironment().document(schemaInput).parserOptions(parseOptions).build();
            Document document = Parser.parse(parserEnvironment);
            return this.buildRegistry(document);
        }
        catch (InvalidSyntaxException e) {
            throw this.handleParseException(e.toInvalidSyntaxError());
        }
    }

    private SchemaProblem handleParseException(InvalidSyntaxError invalidSyntaxError) throws RuntimeException {
        return new SchemaProblem(Collections.singletonList(invalidSyntaxError));
    }

    public TypeDefinitionRegistry buildRegistry(Document document) {
        ArrayList<GraphQLError> errors2 = new ArrayList<GraphQLError>();
        TypeDefinitionRegistry typeRegistry = new TypeDefinitionRegistry();
        List<Definition> definitions = document.getDefinitions();
        for (Definition definition : definitions) {
            if (definition instanceof SDLDefinition) {
                typeRegistry.add((SDLDefinition)definition).ifPresent(errors2::add);
                continue;
            }
            errors2.add(new NonSDLDefinitionError(definition));
        }
        if (errors2.size() > 0) {
            throw new SchemaProblem(errors2);
        }
        return typeRegistry;
    }
}

