/*
 * Decompiled with CFR 0.152.
 */
package graphql.schema.idl;

import graphql.Assert;
import graphql.Directives;
import graphql.DirectivesUtil;
import graphql.GraphQLContext;
import graphql.PublicApi;
import graphql.execution.ValuesResolver;
import graphql.language.AbstractDescribedNode;
import graphql.language.AstPrinter;
import graphql.language.Description;
import graphql.language.Document;
import graphql.language.SchemaDefinition;
import graphql.language.TypeDefinition;
import graphql.schema.DefaultGraphqlTypeComparatorRegistry;
import graphql.schema.GraphQLAppliedDirective;
import graphql.schema.GraphQLAppliedDirectiveArgument;
import graphql.schema.GraphQLArgument;
import graphql.schema.GraphQLDirective;
import graphql.schema.GraphQLDirectiveContainer;
import graphql.schema.GraphQLEnumType;
import graphql.schema.GraphQLEnumValueDefinition;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLFieldsContainer;
import graphql.schema.GraphQLInputFieldsContainer;
import graphql.schema.GraphQLInputObjectField;
import graphql.schema.GraphQLInputObjectType;
import graphql.schema.GraphQLInputType;
import graphql.schema.GraphQLInterfaceType;
import graphql.schema.GraphQLNamedOutputType;
import graphql.schema.GraphQLNamedSchemaElement;
import graphql.schema.GraphQLNamedType;
import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLOutputType;
import graphql.schema.GraphQLScalarType;
import graphql.schema.GraphQLSchema;
import graphql.schema.GraphQLSchemaElement;
import graphql.schema.GraphQLType;
import graphql.schema.GraphQLTypeUtil;
import graphql.schema.GraphQLUnionType;
import graphql.schema.GraphqlTypeComparatorEnvironment;
import graphql.schema.GraphqlTypeComparatorRegistry;
import graphql.schema.InputValueWithState;
import graphql.schema.idl.DirectiveInfo;
import graphql.schema.idl.ScalarInfo;
import graphql.schema.idl.SchemaParser;
import graphql.schema.idl.TypeDefinitionRegistry;
import graphql.schema.idl.UnExecutableSchemaGenerator;
import graphql.schema.visibility.DefaultGraphqlFieldVisibility;
import graphql.schema.visibility.GraphqlFieldVisibility;
import graphql.util.EscapeUtil;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;

@PublicApi
public class SchemaPrinter {
    private static final GraphQLAppliedDirective DeprecatedAppliedDirective4Printing = ((GraphQLAppliedDirective.Builder)GraphQLAppliedDirective.newDirective().name("deprecated")).build();
    public static final Predicate<String> ExcludeGraphQLSpecifiedDirectivesPredicate = d -> !DirectiveInfo.isGraphqlSpecifiedDirective(d);
    private final Map<Class<?>, SchemaElementPrinter<?>> printers = new LinkedHashMap();
    private final Options options;

    public SchemaPrinter() {
        this(Options.defaultOptions());
    }

    public SchemaPrinter(Options options) {
        this.options = options;
        this.printers.put(GraphQLSchema.class, this.schemaPrinter());
        this.printers.put(GraphQLDirective.class, this.directivePrinter());
        this.printers.put(GraphQLObjectType.class, this.objectPrinter());
        this.printers.put(GraphQLEnumType.class, this.enumPrinter());
        this.printers.put(GraphQLScalarType.class, this.scalarPrinter());
        this.printers.put(GraphQLInterfaceType.class, this.interfacePrinter());
        this.printers.put(GraphQLUnionType.class, this.unionPrinter());
        this.printers.put(GraphQLInputObjectType.class, this.inputObjectPrinter());
    }

    public String print(Document schemaIDL) {
        TypeDefinitionRegistry registry = new SchemaParser().buildRegistry(schemaIDL);
        return this.print(UnExecutableSchemaGenerator.makeUnExecutableSchema(registry));
    }

    public String print(GraphQLSchema schema) {
        StringWriter sw = new StringWriter();
        PrintWriter out = new PrintWriter(sw);
        GraphqlFieldVisibility visibility = schema.getCodeRegistry().getFieldVisibility();
        this.printer(schema.getClass()).print(out, schema, visibility);
        Comparator<? super GraphQLSchemaElement> comparator = this.getComparator(GraphQLSchemaElement.class, null);
        Stream directivesAndTypes = Stream.concat(schema.getAllTypesAsList().stream(), this.getSchemaDirectives(schema).stream());
        List elements = directivesAndTypes.map(e -> e).filter(this.options.getIncludeSchemaElement()).sorted(comparator).collect(Collectors.toList());
        for (GraphQLSchemaElement element : elements) {
            this.printSchemaElement(out, element, visibility);
        }
        return SchemaPrinter.trimNewLineChars(sw.toString());
    }

    private boolean isIntrospectionType(GraphQLNamedType type) {
        return !this.options.isIncludeIntrospectionTypes() && type.getName().startsWith("__");
    }

    private SchemaElementPrinter<GraphQLScalarType> scalarPrinter() {
        return (out, type, visibility) -> {
            boolean printScalar;
            if (!this.options.isIncludeScalars()) {
                return;
            }
            if (ScalarInfo.isGraphqlSpecifiedScalar(type)) {
                printScalar = false;
                if (!ScalarInfo.isGraphqlSpecifiedScalar(type)) {
                    printScalar = true;
                }
            } else {
                printScalar = true;
            }
            if (printScalar) {
                if (this.shouldPrintAsAst(type.getDefinition())) {
                    this.printAsAst(out, type.getDefinition(), type.getExtensionDefinitions());
                } else {
                    this.printComments(out, type, "");
                    out.format("scalar %s%s\n\n", type.getName(), this.directivesString((Class<? extends GraphQLSchemaElement>)GraphQLScalarType.class, (GraphQLDirectiveContainer)type));
                }
            }
        };
    }

    private SchemaElementPrinter<GraphQLEnumType> enumPrinter() {
        return (out, type, visibility) -> {
            if (this.isIntrospectionType((GraphQLNamedType)type)) {
                return;
            }
            Comparator<? super GraphQLSchemaElement> comparator = this.getComparator(GraphQLEnumType.class, GraphQLEnumValueDefinition.class);
            if (this.shouldPrintAsAst(type.getDefinition())) {
                this.printAsAst(out, type.getDefinition(), type.getExtensionDefinitions());
            } else {
                this.printComments(out, type, "");
                out.format("enum %s%s", type.getName(), this.directivesString((Class<? extends GraphQLSchemaElement>)GraphQLEnumType.class, (GraphQLDirectiveContainer)type));
                List values2 = type.getValues().stream().sorted(comparator).collect(Collectors.toList());
                if (values2.size() > 0) {
                    out.format(" {\n", new Object[0]);
                    for (GraphQLEnumValueDefinition enumValueDefinition : values2) {
                        this.printComments(out, enumValueDefinition, "  ");
                        out.format("  %s%s\n", enumValueDefinition.getName(), this.directivesString(GraphQLEnumValueDefinition.class, enumValueDefinition.isDeprecated(), enumValueDefinition));
                    }
                    out.format("}", new Object[0]);
                }
                out.format("\n\n", new Object[0]);
            }
        };
    }

    private void printFieldDefinitions(PrintWriter out, Comparator<? super GraphQLSchemaElement> comparator, List<GraphQLFieldDefinition> fieldDefinitions) {
        if (fieldDefinitions.size() == 0) {
            return;
        }
        out.format(" {\n", new Object[0]);
        fieldDefinitions.stream().filter(this.options.getIncludeSchemaElement()).sorted(comparator).forEach(fd -> {
            this.printComments(out, fd, "  ");
            out.format("  %s%s: %s%s\n", fd.getName(), this.argsString(GraphQLFieldDefinition.class, fd.getArguments()), this.typeString(fd.getType()), this.directivesString((Class<? extends GraphQLSchemaElement>)GraphQLFieldDefinition.class, fd.isDeprecated(), (GraphQLDirectiveContainer)fd));
        });
        out.format("}", new Object[0]);
    }

    private SchemaElementPrinter<GraphQLInterfaceType> interfacePrinter() {
        return (out, type, visibility) -> {
            if (this.isIntrospectionType((GraphQLNamedType)type)) {
                return;
            }
            if (this.shouldPrintAsAst(type.getDefinition())) {
                this.printAsAst(out, type.getDefinition(), type.getExtensionDefinitions());
            } else {
                this.printComments(out, type, "");
                if (type.getInterfaces().isEmpty()) {
                    out.format("interface %s%s", type.getName(), this.directivesString((Class<? extends GraphQLSchemaElement>)GraphQLInterfaceType.class, (GraphQLDirectiveContainer)type));
                } else {
                    Comparator<? super GraphQLSchemaElement> implementsComparator = this.getComparator(GraphQLInterfaceType.class, GraphQLOutputType.class);
                    Stream<String> interfaceNames = type.getInterfaces().stream().sorted(implementsComparator).map(GraphQLNamedSchemaElement::getName);
                    out.format("interface %s implements %s%s", type.getName(), interfaceNames.collect(Collectors.joining(" & ")), this.directivesString((Class<? extends GraphQLSchemaElement>)GraphQLInterfaceType.class, (GraphQLDirectiveContainer)type));
                }
                Comparator<? super GraphQLSchemaElement> comparator = this.getComparator(GraphQLInterfaceType.class, GraphQLFieldDefinition.class);
                this.printFieldDefinitions(out, comparator, visibility.getFieldDefinitions((GraphQLFieldsContainer)type));
                out.format("\n\n", new Object[0]);
            }
        };
    }

    private SchemaElementPrinter<GraphQLUnionType> unionPrinter() {
        return (out, type, visibility) -> {
            if (this.isIntrospectionType((GraphQLNamedType)type)) {
                return;
            }
            Comparator<? super GraphQLSchemaElement> comparator = this.getComparator(GraphQLUnionType.class, GraphQLOutputType.class);
            if (this.shouldPrintAsAst(type.getDefinition())) {
                this.printAsAst(out, type.getDefinition(), type.getExtensionDefinitions());
            } else {
                this.printComments(out, type, "");
                out.format("union %s%s = ", type.getName(), this.directivesString((Class<? extends GraphQLSchemaElement>)GraphQLUnionType.class, (GraphQLDirectiveContainer)type));
                List types = type.getTypes().stream().sorted(comparator).collect(Collectors.toList());
                for (int i = 0; i < types.size(); ++i) {
                    GraphQLNamedOutputType objectType = (GraphQLNamedOutputType)types.get(i);
                    if (i > 0) {
                        out.format(" | ", new Object[0]);
                    }
                    out.format("%s", objectType.getName());
                }
                out.format("\n\n", new Object[0]);
            }
        };
    }

    private SchemaElementPrinter<GraphQLDirective> directivePrinter() {
        return (out, directive, visibility) -> {
            if (this.options.isIncludeDirectiveDefinitions()) {
                String s2 = this.directiveDefinition((GraphQLDirective)directive);
                out.format("%s", s2);
                out.print("\n\n");
            }
        };
    }

    private SchemaElementPrinter<GraphQLObjectType> objectPrinter() {
        return (out, type, visibility) -> {
            if (this.isIntrospectionType((GraphQLNamedType)type)) {
                return;
            }
            if (this.shouldPrintAsAst(type.getDefinition())) {
                this.printAsAst(out, type.getDefinition(), type.getExtensionDefinitions());
            } else {
                this.printComments(out, type, "");
                if (type.getInterfaces().isEmpty()) {
                    out.format("type %s%s", type.getName(), this.directivesString((Class<? extends GraphQLSchemaElement>)GraphQLObjectType.class, (GraphQLDirectiveContainer)type));
                } else {
                    Comparator<? super GraphQLSchemaElement> implementsComparator = this.getComparator(GraphQLObjectType.class, GraphQLOutputType.class);
                    Stream<String> interfaceNames = type.getInterfaces().stream().sorted(implementsComparator).map(GraphQLNamedSchemaElement::getName);
                    out.format("type %s implements %s%s", type.getName(), interfaceNames.collect(Collectors.joining(" & ")), this.directivesString((Class<? extends GraphQLSchemaElement>)GraphQLObjectType.class, (GraphQLDirectiveContainer)type));
                }
                Comparator<? super GraphQLSchemaElement> comparator = this.getComparator(GraphQLObjectType.class, GraphQLFieldDefinition.class);
                this.printFieldDefinitions(out, comparator, visibility.getFieldDefinitions((GraphQLFieldsContainer)type));
                out.format("\n\n", new Object[0]);
            }
        };
    }

    private SchemaElementPrinter<GraphQLInputObjectType> inputObjectPrinter() {
        return (out, type, visibility) -> {
            if (this.isIntrospectionType((GraphQLNamedType)type)) {
                return;
            }
            if (this.shouldPrintAsAst(type.getDefinition())) {
                this.printAsAst(out, type.getDefinition(), type.getExtensionDefinitions());
            } else {
                this.printComments(out, type, "");
                Comparator<? super GraphQLSchemaElement> comparator = this.getComparator(GraphQLInputObjectType.class, GraphQLInputObjectField.class);
                out.format("input %s%s", type.getName(), this.directivesString((Class<? extends GraphQLSchemaElement>)GraphQLInputObjectType.class, (GraphQLDirectiveContainer)type));
                List<GraphQLInputObjectField> inputObjectFields = visibility.getFieldDefinitions((GraphQLInputFieldsContainer)type);
                if (inputObjectFields.size() > 0) {
                    out.format(" {\n", new Object[0]);
                    inputObjectFields.stream().filter(this.options.getIncludeSchemaElement()).sorted(comparator).forEach(fd -> {
                        this.printComments(out, fd, "  ");
                        out.format("  %s: %s", fd.getName(), this.typeString(fd.getType()));
                        if (fd.hasSetDefaultValue()) {
                            InputValueWithState defaultValue = fd.getInputFieldDefaultValue();
                            String astValue = SchemaPrinter.printAst(defaultValue, fd.getType());
                            out.format(" = %s", astValue);
                        }
                        out.print(this.directivesString((Class<? extends GraphQLSchemaElement>)GraphQLInputObjectField.class, fd.isDeprecated(), (GraphQLDirectiveContainer)fd));
                        out.format("\n", new Object[0]);
                    });
                    out.format("}", new Object[0]);
                }
                out.format("\n\n", new Object[0]);
            }
        };
    }

    private boolean shouldPrintAsAst(TypeDefinition<?> definition) {
        return this.options.isUseAstDefinitions() && definition != null;
    }

    private void printAsAst(PrintWriter out, TypeDefinition<?> definition, List<? extends TypeDefinition<?>> extensions) {
        out.printf("%s\n", AstPrinter.printAst(definition));
        if (extensions != null) {
            for (TypeDefinition<?> extension : extensions) {
                out.printf("\n%s\n", AstPrinter.printAst(extension));
            }
        }
        out.print('\n');
    }

    private static String printAst(InputValueWithState value, GraphQLInputType type) {
        return AstPrinter.printAst(ValuesResolver.valueToLiteral(value, type, GraphQLContext.getDefault(), Locale.getDefault()));
    }

    private SchemaElementPrinter<GraphQLSchema> schemaPrinter() {
        return (out, schema, visibility) -> {
            GraphQLObjectType queryType = schema.getQueryType();
            GraphQLObjectType mutationType = schema.getMutationType();
            GraphQLObjectType subscriptionType = schema.getSubscriptionType();
            boolean needsSchemaPrinted = this.options.isIncludeSchemaDefinition();
            if (!needsSchemaPrinted) {
                if (queryType != null && !queryType.getName().equals("Query")) {
                    needsSchemaPrinted = true;
                }
                if (mutationType != null && !mutationType.getName().equals("Mutation")) {
                    needsSchemaPrinted = true;
                }
                if (subscriptionType != null && !subscriptionType.getName().equals("Subscription")) {
                    needsSchemaPrinted = true;
                }
            }
            if (needsSchemaPrinted) {
                if (this.hasDescription(schema)) {
                    out.print(this.printComments(schema, ""));
                }
                List<GraphQLAppliedDirective> directives = DirectivesUtil.toAppliedDirectives(schema.getSchemaAppliedDirectives(), schema.getSchemaDirectives());
                out.format("schema %s{\n", this.directivesString(GraphQLSchemaElement.class, false, directives));
                if (queryType != null) {
                    out.format("  query: %s\n", queryType.getName());
                }
                if (mutationType != null) {
                    out.format("  mutation: %s\n", mutationType.getName());
                }
                if (subscriptionType != null) {
                    out.format("  subscription: %s\n", subscriptionType.getName());
                }
                out.format("}\n\n", new Object[0]);
            }
        };
    }

    private List<GraphQLDirective> getSchemaDirectives(GraphQLSchema schema) {
        Predicate<GraphQLDirective> includePredicate = d -> this.options.getIncludeDirective().test(d.getName());
        return schema.getDirectives().stream().filter(includePredicate).filter(this.options.getIncludeSchemaElement()).collect(Collectors.toList());
    }

    String typeString(GraphQLType rawType) {
        return GraphQLTypeUtil.simplePrint(rawType);
    }

    String argsString(List<GraphQLArgument> arguments) {
        return this.argsString(null, arguments);
    }

    String argsString(Class<? extends GraphQLSchemaElement> parent, List<GraphQLArgument> arguments) {
        boolean hasDescriptions = arguments.stream().anyMatch(this::hasDescription);
        String halfPrefix = hasDescriptions ? "  " : "";
        String prefix = hasDescriptions ? "    " : "";
        int count = 0;
        StringBuilder sb = new StringBuilder();
        Comparator<? super GraphQLSchemaElement> comparator = this.getComparator(parent, GraphQLArgument.class);
        arguments = arguments.stream().sorted(comparator).filter(this.options.getIncludeSchemaElement()).collect(Collectors.toList());
        for (GraphQLArgument argument : arguments) {
            if (count == 0) {
                sb.append("(");
            } else {
                sb.append(",");
                if (!hasDescriptions) {
                    sb.append(" ");
                }
            }
            if (hasDescriptions) {
                sb.append("\n");
            }
            sb.append(this.printComments(argument, prefix));
            sb.append(prefix).append(argument.getName()).append(": ").append(this.typeString(argument.getType()));
            if (argument.hasSetDefaultValue()) {
                InputValueWithState defaultValue = argument.getArgumentDefaultValue();
                sb.append(" = ");
                sb.append(SchemaPrinter.printAst(defaultValue, argument.getType()));
            }
            DirectivesUtil.toAppliedDirectives(argument).stream().filter(this.options.getIncludeSchemaElement()).map(this::directiveString).filter(it -> !it.isEmpty()).forEach(directiveString -> sb.append(" ").append((String)directiveString));
            ++count;
        }
        if (count > 0) {
            if (hasDescriptions) {
                sb.append("\n");
            }
            sb.append(halfPrefix).append(")");
        }
        return sb.toString();
    }

    public String directivesString(Class<? extends GraphQLSchemaElement> parentType, GraphQLDirectiveContainer directiveContainer) {
        return this.directivesString(parentType, false, directiveContainer);
    }

    String directivesString(Class<? extends GraphQLSchemaElement> parentType, boolean isDeprecated, GraphQLDirectiveContainer directiveContainer) {
        List<GraphQLAppliedDirective> directives = DirectivesUtil.toAppliedDirectives(directiveContainer);
        return this.directivesString(parentType, isDeprecated, directives);
    }

    private String directivesString(Class<? extends GraphQLSchemaElement> parentType, boolean isDeprecated, List<GraphQLAppliedDirective> directives) {
        if (isDeprecated) {
            directives = this.addDeprecatedDirectiveIfNeeded(directives);
        }
        if ((directives = directives.stream().filter(directive -> this.options.getIncludeDirective().test(directive.getName()) || this.isDeprecatedDirective((GraphQLAppliedDirective)directive)).filter(this.options.getIncludeSchemaElement()).collect(Collectors.toList())).isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        if (parentType != GraphQLSchemaElement.class) {
            sb.append(" ");
        }
        Comparator<? super GraphQLSchemaElement> comparator = this.getComparator(parentType, GraphQLAppliedDirective.class);
        directives = directives.stream().sorted(comparator).collect(Collectors.toList());
        for (int i = 0; i < directives.size(); ++i) {
            GraphQLAppliedDirective directive2 = directives.get(i);
            sb.append(this.directiveString(directive2));
            if (i >= directives.size() - 1) continue;
            sb.append(" ");
        }
        return sb.toString();
    }

    private String directiveString(GraphQLAppliedDirective directive) {
        if (!this.options.getIncludeSchemaElement().test(directive)) {
            return "";
        }
        if (!this.options.getIncludeDirective().test(directive.getName()) && !this.isDeprecatedDirective(directive)) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        sb.append("@").append(directive.getName());
        Comparator<? super GraphQLSchemaElement> comparator = this.getComparator(GraphQLAppliedDirective.class, GraphQLAppliedDirectiveArgument.class);
        List<GraphQLAppliedDirectiveArgument> args2 = directive.getArguments();
        args2 = args2.stream().filter(arg -> arg.getArgumentValue().isSet()).sorted(comparator).collect(Collectors.toList());
        if (!args2.isEmpty()) {
            sb.append("(");
            for (int i = 0; i < args2.size(); ++i) {
                GraphQLAppliedDirectiveArgument arg2 = args2.get(i);
                String argValue = null;
                if (arg2.hasSetValue()) {
                    argValue = SchemaPrinter.printAst(arg2.getArgumentValue(), arg2.getType());
                }
                if (SchemaPrinter.isNullOrEmpty(argValue)) continue;
                sb.append(arg2.getName());
                sb.append(" : ");
                sb.append(argValue);
                if (i >= args2.size() - 1) continue;
                sb.append(", ");
            }
            sb.append(")");
        }
        return sb.toString();
    }

    private boolean isDeprecatedDirective(GraphQLAppliedDirective directive) {
        return directive.getName().equals(Directives.DeprecatedDirective.getName());
    }

    private boolean hasDeprecatedDirective(List<GraphQLAppliedDirective> directives) {
        return directives.stream().filter(this::isDeprecatedDirective).count() == 1L;
    }

    private List<GraphQLAppliedDirective> addDeprecatedDirectiveIfNeeded(List<GraphQLAppliedDirective> directives) {
        if (!this.hasDeprecatedDirective(directives)) {
            directives = new ArrayList<GraphQLAppliedDirective>(directives);
            directives.add(DeprecatedAppliedDirective4Printing);
        }
        return directives;
    }

    private String directiveDefinition(GraphQLDirective directive) {
        StringBuilder sb = new StringBuilder();
        StringWriter sw = new StringWriter();
        this.printComments(new PrintWriter(sw), directive, "");
        sb.append(sw);
        sb.append("directive @").append(directive.getName());
        Comparator<? super GraphQLSchemaElement> comparator = this.getComparator(GraphQLDirective.class, GraphQLArgument.class);
        List<GraphQLArgument> args2 = directive.getArguments();
        args2 = args2.stream().filter(this.options.getIncludeSchemaElement()).sorted(comparator).collect(Collectors.toList());
        sb.append(this.argsString(GraphQLDirective.class, args2));
        if (directive.isRepeatable()) {
            sb.append(" repeatable");
        }
        sb.append(" on ");
        String locations = directive.validLocations().stream().map(Enum::name).collect(Collectors.joining(" | "));
        sb.append(locations);
        return sb.toString();
    }

    private <T> SchemaElementPrinter<T> printer(Class<?> clazz) {
        SchemaElementPrinter<Object> schemaElementPrinter = this.printers.get(clazz);
        if (schemaElementPrinter == null) {
            Class<?> superClazz = clazz.getSuperclass();
            schemaElementPrinter = superClazz != Object.class ? this.printer(superClazz) : (out, type, visibility) -> out.print("Type not implemented : " + type + "\n");
            this.printers.put(clazz, schemaElementPrinter);
        }
        return schemaElementPrinter;
    }

    public String print(GraphQLType type) {
        StringWriter sw = new StringWriter();
        PrintWriter out = new PrintWriter(sw);
        this.printSchemaElement(out, type, DefaultGraphqlFieldVisibility.DEFAULT_FIELD_VISIBILITY);
        return SchemaPrinter.trimNewLineChars(sw.toString());
    }

    public String print(List<GraphQLSchemaElement> elements) {
        StringWriter sw = new StringWriter();
        PrintWriter out = new PrintWriter(sw);
        for (GraphQLSchemaElement element : elements) {
            if (element instanceof GraphQLDirective) {
                out.print(this.print((GraphQLDirective)element));
                continue;
            }
            if (element instanceof GraphQLType) {
                this.printSchemaElement(out, element, DefaultGraphqlFieldVisibility.DEFAULT_FIELD_VISIBILITY);
                continue;
            }
            Assert.assertShouldNeverHappen("How did we miss a %s", element.getClass());
        }
        return SchemaPrinter.trimNewLineChars(sw.toString());
    }

    public String print(GraphQLDirective graphQLDirective) {
        return this.directiveDefinition(graphQLDirective);
    }

    private void printSchemaElement(PrintWriter out, GraphQLSchemaElement schemaElement, GraphqlFieldVisibility visibility) {
        SchemaElementPrinter<GraphQLSchemaElement> printer = this.printer(schemaElement.getClass());
        printer.print(out, schemaElement, visibility);
    }

    private String printComments(Object graphQLType, String prefix) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        this.printComments(pw, graphQLType, prefix);
        return sw.toString();
    }

    private void printComments(PrintWriter out, Object graphQLType, String prefix) {
        String descriptionText = this.getDescription(graphQLType);
        if (SchemaPrinter.isNullOrEmpty(descriptionText)) {
            return;
        }
        List<String> lines = Arrays.asList(descriptionText.split("\n"));
        if (this.options.isDescriptionsAsHashComments()) {
            this.printMultiLineHashDescription(out, prefix, lines);
        } else if (!lines.isEmpty()) {
            if (lines.size() > 1) {
                this.printMultiLineDescription(out, prefix, lines);
            } else {
                this.printSingleLineDescription(out, prefix, lines.get(0));
            }
        }
    }

    private void printMultiLineHashDescription(PrintWriter out, String prefix, List<String> lines) {
        lines.forEach(l -> out.printf("%s#%s\n", prefix, l));
    }

    private void printMultiLineDescription(PrintWriter out, String prefix, List<String> lines) {
        out.printf("%s\"\"\"\n", prefix);
        lines.forEach(l -> {
            String escapedTripleQuotes = l.replaceAll("\"\"\"", "\\\\\"\"\"");
            out.printf("%s%s\n", prefix, escapedTripleQuotes);
        });
        out.printf("%s\"\"\"\n", prefix);
    }

    private void printSingleLineDescription(PrintWriter out, String prefix, String s2) {
        String desc = EscapeUtil.escapeJsonString(s2);
        out.printf("%s\"%s\"\n", prefix, desc);
    }

    private boolean hasDescription(Object descriptionHolder) {
        String description = this.getDescription(descriptionHolder);
        return !SchemaPrinter.isNullOrEmpty(description);
    }

    private String getDescription(Object descriptionHolder) {
        if (descriptionHolder instanceof GraphQLObjectType) {
            GraphQLObjectType type = (GraphQLObjectType)descriptionHolder;
            return this.description(type.getDescription(), Optional.ofNullable(type.getDefinition()).map(AbstractDescribedNode::getDescription).orElse(null));
        }
        if (descriptionHolder instanceof GraphQLEnumType) {
            GraphQLEnumType type = (GraphQLEnumType)descriptionHolder;
            return this.description(type.getDescription(), Optional.ofNullable(type.getDefinition()).map(AbstractDescribedNode::getDescription).orElse(null));
        }
        if (descriptionHolder instanceof GraphQLFieldDefinition) {
            GraphQLFieldDefinition type = (GraphQLFieldDefinition)descriptionHolder;
            return this.description(type.getDescription(), Optional.ofNullable(type.getDefinition()).map(AbstractDescribedNode::getDescription).orElse(null));
        }
        if (descriptionHolder instanceof GraphQLEnumValueDefinition) {
            GraphQLEnumValueDefinition type = (GraphQLEnumValueDefinition)descriptionHolder;
            return this.description(type.getDescription(), Optional.ofNullable(type.getDefinition()).map(AbstractDescribedNode::getDescription).orElse(null));
        }
        if (descriptionHolder instanceof GraphQLUnionType) {
            GraphQLUnionType type = (GraphQLUnionType)descriptionHolder;
            return this.description(type.getDescription(), Optional.ofNullable(type.getDefinition()).map(AbstractDescribedNode::getDescription).orElse(null));
        }
        if (descriptionHolder instanceof GraphQLInputObjectType) {
            GraphQLInputObjectType type = (GraphQLInputObjectType)descriptionHolder;
            return this.description(type.getDescription(), Optional.ofNullable(type.getDefinition()).map(AbstractDescribedNode::getDescription).orElse(null));
        }
        if (descriptionHolder instanceof GraphQLInputObjectField) {
            GraphQLInputObjectField type = (GraphQLInputObjectField)descriptionHolder;
            return this.description(type.getDescription(), Optional.ofNullable(type.getDefinition()).map(AbstractDescribedNode::getDescription).orElse(null));
        }
        if (descriptionHolder instanceof GraphQLInterfaceType) {
            GraphQLInterfaceType type = (GraphQLInterfaceType)descriptionHolder;
            return this.description(type.getDescription(), Optional.ofNullable(type.getDefinition()).map(AbstractDescribedNode::getDescription).orElse(null));
        }
        if (descriptionHolder instanceof GraphQLScalarType) {
            GraphQLScalarType type = (GraphQLScalarType)descriptionHolder;
            return this.description(type.getDescription(), Optional.ofNullable(type.getDefinition()).map(AbstractDescribedNode::getDescription).orElse(null));
        }
        if (descriptionHolder instanceof GraphQLArgument) {
            GraphQLArgument type = (GraphQLArgument)descriptionHolder;
            return this.description(type.getDescription(), Optional.ofNullable(type.getDefinition()).map(AbstractDescribedNode::getDescription).orElse(null));
        }
        if (descriptionHolder instanceof GraphQLDirective) {
            GraphQLDirective type = (GraphQLDirective)descriptionHolder;
            return this.description(type.getDescription(), null);
        }
        if (descriptionHolder instanceof GraphQLSchema) {
            GraphQLSchema type = (GraphQLSchema)descriptionHolder;
            return this.description(type.getDescription(), Optional.ofNullable(type.getDefinition()).map(SchemaDefinition::getDescription).orElse(null));
        }
        return (String)Assert.assertShouldNeverHappen();
    }

    String description(String runtimeDescription, Description descriptionAst) {
        String descriptionText = runtimeDescription;
        if (SchemaPrinter.isNullOrEmpty(descriptionText) && descriptionAst != null) {
            descriptionText = descriptionAst.getContent();
        }
        return descriptionText;
    }

    private Comparator<? super GraphQLSchemaElement> getComparator(Class<? extends GraphQLSchemaElement> parentType, Class<? extends GraphQLSchemaElement> elementType) {
        GraphqlTypeComparatorEnvironment environment = GraphqlTypeComparatorEnvironment.newEnvironment().parentType(parentType).elementType(elementType).build();
        return this.options.comparatorRegistry.getComparator(environment);
    }

    private static String trimNewLineChars(String s2) {
        if (s2.endsWith("\n\n")) {
            s2 = s2.substring(0, s2.length() - 1);
        }
        return s2;
    }

    private static boolean isNullOrEmpty(String s2) {
        return s2 == null || s2.isEmpty();
    }

    private static interface SchemaElementPrinter<T> {
        public void print(PrintWriter var1, T var2, GraphqlFieldVisibility var3);
    }

    public static class Options {
        private final boolean includeIntrospectionTypes;
        private final boolean includeScalars;
        private final boolean useAstDefinitions;
        private final boolean includeSchemaDefinition;
        private final boolean includeDirectiveDefinitions;
        private final boolean descriptionsAsHashComments;
        private final Predicate<String> includeDirective;
        private final Predicate<GraphQLSchemaElement> includeSchemaElement;
        private final GraphqlTypeComparatorRegistry comparatorRegistry;

        private Options(boolean includeIntrospectionTypes, boolean includeScalars, boolean includeSchemaDefinition, boolean includeDirectiveDefinitions, boolean useAstDefinitions, boolean descriptionsAsHashComments, Predicate<String> includeDirective, Predicate<GraphQLSchemaElement> includeSchemaElement, GraphqlTypeComparatorRegistry comparatorRegistry) {
            this.includeIntrospectionTypes = includeIntrospectionTypes;
            this.includeScalars = includeScalars;
            this.includeSchemaDefinition = includeSchemaDefinition;
            this.includeDirectiveDefinitions = includeDirectiveDefinitions;
            this.includeDirective = includeDirective;
            this.useAstDefinitions = useAstDefinitions;
            this.descriptionsAsHashComments = descriptionsAsHashComments;
            this.comparatorRegistry = comparatorRegistry;
            this.includeSchemaElement = includeSchemaElement;
        }

        public boolean isIncludeIntrospectionTypes() {
            return this.includeIntrospectionTypes;
        }

        public boolean isIncludeScalars() {
            return this.includeScalars;
        }

        public boolean isIncludeSchemaDefinition() {
            return this.includeSchemaDefinition;
        }

        public boolean isIncludeDirectiveDefinitions() {
            return this.includeDirectiveDefinitions;
        }

        public Predicate<String> getIncludeDirective() {
            return this.includeDirective;
        }

        public Predicate<GraphQLSchemaElement> getIncludeSchemaElement() {
            return this.includeSchemaElement;
        }

        public boolean isDescriptionsAsHashComments() {
            return this.descriptionsAsHashComments;
        }

        public GraphqlTypeComparatorRegistry getComparatorRegistry() {
            return this.comparatorRegistry;
        }

        public boolean isUseAstDefinitions() {
            return this.useAstDefinitions;
        }

        public static Options defaultOptions() {
            return new Options(false, true, false, true, false, false, directive -> true, element -> true, DefaultGraphqlTypeComparatorRegistry.defaultComparators());
        }

        public Options includeIntrospectionTypes(boolean flag) {
            return new Options(flag, this.includeScalars, this.includeSchemaDefinition, this.includeDirectiveDefinitions, this.useAstDefinitions, this.descriptionsAsHashComments, this.includeDirective, this.includeSchemaElement, this.comparatorRegistry);
        }

        public Options includeScalarTypes(boolean flag) {
            return new Options(this.includeIntrospectionTypes, flag, this.includeSchemaDefinition, this.includeDirectiveDefinitions, this.useAstDefinitions, this.descriptionsAsHashComments, this.includeDirective, this.includeSchemaElement, this.comparatorRegistry);
        }

        public Options includeSchemaDefinition(boolean flag) {
            return new Options(this.includeIntrospectionTypes, this.includeScalars, flag, this.includeDirectiveDefinitions, this.useAstDefinitions, this.descriptionsAsHashComments, this.includeDirective, this.includeSchemaElement, this.comparatorRegistry);
        }

        public Options includeDirectiveDefinitions(boolean flag) {
            return new Options(this.includeIntrospectionTypes, this.includeScalars, this.includeSchemaDefinition, flag, this.useAstDefinitions, this.descriptionsAsHashComments, this.includeDirective, this.includeSchemaElement, this.comparatorRegistry);
        }

        public Options includeDirectives(boolean flag) {
            return new Options(this.includeIntrospectionTypes, this.includeScalars, this.includeSchemaDefinition, this.includeDirectiveDefinitions, this.useAstDefinitions, this.descriptionsAsHashComments, directive -> flag, this.includeSchemaElement, this.comparatorRegistry);
        }

        public Options includeDirectives(Predicate<String> includeDirective) {
            return new Options(this.includeIntrospectionTypes, this.includeScalars, this.includeSchemaDefinition, this.includeDirectiveDefinitions, this.useAstDefinitions, this.descriptionsAsHashComments, includeDirective, this.includeSchemaElement, this.comparatorRegistry);
        }

        public Options includeSchemaElement(Predicate<GraphQLSchemaElement> includeSchemaElement) {
            Assert.assertNotNull(includeSchemaElement);
            return new Options(this.includeIntrospectionTypes, this.includeScalars, this.includeSchemaDefinition, this.includeDirectiveDefinitions, this.useAstDefinitions, this.descriptionsAsHashComments, this.includeDirective, includeSchemaElement, this.comparatorRegistry);
        }

        public Options useAstDefinitions(boolean flag) {
            return new Options(this.includeIntrospectionTypes, this.includeScalars, this.includeSchemaDefinition, this.includeDirectiveDefinitions, flag, this.descriptionsAsHashComments, this.includeDirective, this.includeSchemaElement, this.comparatorRegistry);
        }

        public Options descriptionsAsHashComments(boolean flag) {
            return new Options(this.includeIntrospectionTypes, this.includeScalars, this.includeSchemaDefinition, this.includeDirectiveDefinitions, this.useAstDefinitions, flag, this.includeDirective, this.includeSchemaElement, this.comparatorRegistry);
        }

        public Options setComparators(GraphqlTypeComparatorRegistry comparatorRegistry) {
            return new Options(this.includeIntrospectionTypes, this.includeScalars, this.includeSchemaDefinition, this.includeDirectiveDefinitions, this.useAstDefinitions, this.descriptionsAsHashComments, this.includeDirective, this.includeSchemaElement, comparatorRegistry);
        }
    }
}

