/*
 * Decompiled with CFR 0.152.
 */
package io.github.bonigarcia.wdm.online;

import io.github.bonigarcia.wdm.config.Architecture;
import io.github.bonigarcia.wdm.config.Config;
import io.github.bonigarcia.wdm.config.DriverManagerType;
import io.github.bonigarcia.wdm.config.OperatingSystem;
import io.github.bonigarcia.wdm.config.WebDriverManagerException;
import io.github.bonigarcia.wdm.online.HttpClient;
import io.github.bonigarcia.wdm.versions.VersionDetector;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.MethodHandles;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.function.Function;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Downloader {
    static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    HttpClient httpClient;
    Config config;
    Function<File, List<File>> postDownloadFunction;

    public Downloader(HttpClient httpClient, Config config, Function<File, List<File>> postDownloadFunction) {
        this.httpClient = httpClient;
        this.config = config;
        this.postDownloadFunction = postDownloadFunction;
    }

    public synchronized String download(URL url2, String driverVersion, String driverName, DriverManagerType driverManagerType) throws IOException {
        File targetFile = this.getTarget(driverVersion, driverName, driverManagerType, url2);
        Optional<File> driver = this.checkDriver(driverName, targetFile);
        if (!driver.isPresent()) {
            driver = this.downloadAndExtract(url2, targetFile);
        }
        return driver.get().toString();
    }

    public File getTarget(String driverVersion, String driverName, DriverManagerType driverManagerType, URL url2) {
        String zip2 = url2.getFile().substring(url2.getFile().lastIndexOf(47));
        String cachePath = this.config.getCacheFolder().getAbsolutePath();
        OperatingSystem os = this.config.getOperatingSystem();
        String architecture = this.config.getArchitecture().toString().toLowerCase(Locale.ROOT);
        int majorDriverVersion = Integer.parseInt(VersionDetector.getMajorVersion(driverVersion));
        if (os.isWin() && majorDriverVersion < 115 && (driverManagerType == DriverManagerType.CHROME || driverManagerType == DriverManagerType.CHROMIUM)) {
            log.trace("{} in Windows is only available for 32 bits architecture", (Object)driverName);
            architecture = "32";
        }
        String osName = os.getName();
        if (this.config.getArchitecture() == Architecture.ARM64) {
            osName = String.valueOf(osName) + "-";
        }
        String target = this.config.isAvoidOutputTree() ? String.valueOf(cachePath) + zip2 : String.valueOf(cachePath) + File.separator + driverName + File.separator + osName + architecture + File.separator + driverVersion + zip2;
        log.trace("Target file for URL {} driver version {} = {}", url2, driverVersion, target);
        return new File(target);
    }

    private Optional<File> downloadAndExtract(URL url2, File targetFile) throws IOException {
        log.info("Downloading {}", (Object)url2);
        File targetFolder = targetFile.getParentFile();
        File tempDir = this.config.isAvoidTmpFolder() ? targetFolder : Files.createTempDirectory("", new FileAttribute[0]).toFile();
        File temporaryFile = new File(tempDir, targetFile.getName());
        log.trace("Target folder {} ... using temporal file {}", (Object)targetFolder, (Object)temporaryFile);
        FileUtils.copyInputStreamToFile(this.httpClient.execute(this.httpClient.createHttpGet(url2)).getEntity().getContent(), temporaryFile);
        List<File> extractedFiles = this.extract(temporaryFile);
        File resultingDriver = new File(targetFolder, extractedFiles.iterator().next().getName());
        boolean driverExists = resultingDriver.exists();
        if (!(driverExists && !this.config.isForceDownload() || this.config.isAvoidTmpFolder())) {
            if (driverExists) {
                log.debug("Overriding former driver {}", (Object)resultingDriver);
                Downloader.deleteFile(resultingDriver);
            }
            for (File f : extractedFiles) {
                FileUtils.moveFileToDirectory(f, targetFolder, true);
            }
        }
        if (!this.config.isExecutable(resultingDriver)) {
            this.setFileExecutable(resultingDriver);
        }
        if (!this.config.isAvoidTmpFolder()) {
            this.deleteFolder(tempDir);
        }
        log.trace("Driver after extraction {}", (Object)resultingDriver);
        return Optional.of(resultingDriver);
    }

    private Optional<File> checkDriver(String driverName, File targetFile) {
        File parentFolder = targetFile.getParentFile();
        if (parentFolder.exists() && !this.config.isForceDownload()) {
            Collection<File> listFiles = FileUtils.listFiles(parentFolder, null, true);
            for (File file : listFiles) {
                if (!file.getName().startsWith(driverName) || !this.config.isExecutable(file)) continue;
                log.trace("Using {} previously downloaded", (Object)driverName);
                return Optional.of(file);
            }
            log.trace("{} does not exist in cache", (Object)driverName);
        }
        return Optional.empty();
    }

    private List<File> extract(File compressedFile) throws IOException {
        boolean extractFile;
        String fileName = compressedFile.getName().toLowerCase(Locale.ROOT);
        boolean bl = extractFile = !fileName.endsWith("exe") && !fileName.endsWith("jar");
        if (extractFile) {
            log.info("Extracting driver from compressed file {}", (Object)fileName);
        }
        if (fileName.endsWith("tar.gz")) {
            this.unTarGz(compressedFile);
        } else if (fileName.endsWith("gz")) {
            this.unGzip(compressedFile);
        } else if (fileName.endsWith("zip")) {
            this.unZip(compressedFile);
        }
        if (extractFile) {
            Downloader.deleteFile(compressedFile);
        }
        return this.postDownloadFunction.apply(compressedFile);
    }

    private void unZip(File compressedFile) throws IOException {
        File file = null;
        Throwable throwable = null;
        Object var4_5 = null;
        try (ZipFile zipFolder = new ZipFile(compressedFile);){
            Enumeration<? extends ZipEntry> enu = zipFolder.entries();
            while (enu.hasMoreElements()) {
                ZipEntry zipEntry = enu.nextElement();
                String name = zipEntry.getName();
                long size = zipEntry.getSize();
                long compressedSize = zipEntry.getCompressedSize();
                log.trace("Unzipping {} (size: {} KB, compressed size: {} KB)", name, size, compressedSize);
                file = new File(compressedFile.getParentFile(), name);
                if (!file.exists() || this.config.isForceDownload()) {
                    if (name.endsWith("/")) {
                        file.mkdirs();
                        continue;
                    }
                    File parent = file.getParentFile();
                    if (parent != null) {
                        parent.mkdirs();
                    }
                    Throwable throwable2 = null;
                    Object var15_16 = null;
                    try (InputStream is = zipFolder.getInputStream(zipEntry);){
                        FileUtils.copyInputStreamToFile(is, file);
                    }
                    catch (Throwable throwable3) {
                        if (throwable2 == null) {
                            throwable2 = throwable3;
                        } else if (throwable2 != throwable3) {
                            throwable2.addSuppressed(throwable3);
                        }
                        throw throwable2;
                    }
                    this.setFileExecutable(file);
                    continue;
                }
                log.debug("{} already exists", (Object)file);
            }
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
    }

    private void unGzip(File archive) throws IOException {
        int iDot;
        log.trace("UnGzip {}", (Object)archive);
        String fileName = archive.getName();
        int iDash = fileName.indexOf(45);
        if (iDash != -1) {
            fileName = fileName.substring(0, iDash);
        }
        if ((iDot = fileName.indexOf(46)) != -1) {
            fileName = fileName.substring(0, iDot);
        }
        File target = new File(archive.getParentFile(), fileName);
        Throwable throwable = null;
        Object var7_8 = null;
        try (GZIPInputStream in = new GZIPInputStream(new FileInputStream(archive));){
            Throwable throwable2 = null;
            Object var10_13 = null;
            try (FileOutputStream out = new FileOutputStream(target);){
                int c = in.read();
                while (c != -1) {
                    out.write(c);
                    c = in.read();
                }
            }
            catch (Throwable throwable3) {
                if (throwable2 == null) {
                    throwable2 = throwable3;
                } else if (throwable2 != throwable3) {
                    throwable2.addSuppressed(throwable3);
                }
                throw throwable2;
            }
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
        if (!target.getName().toLowerCase(Locale.ROOT).contains(".exe") && target.exists()) {
            this.setFileExecutable(target);
        }
    }

    /*
     * Exception decompiling
     */
    public void unTarGz(File tarGzFile) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [19[UNCONDITIONALDOLOOP]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected void setFileExecutable(File file) {
        if (!file.setExecutable(true)) {
            log.warn("Error setting file {} as executable", (Object)file);
        }
    }

    public void renameFile(File from, File to) {
        log.trace("Renaming file from {} to {}", (Object)from, (Object)to);
        if (to.exists()) {
            Downloader.deleteFile(to);
        }
        if (!from.renameTo(to)) {
            log.warn("Error renaming file from {} to {}", (Object)from, (Object)to);
        }
    }

    public static void deleteFile(File file) {
        log.trace("Deleting file {}", (Object)file);
        try {
            Files.delete(file.toPath());
        }
        catch (IOException e) {
            throw new WebDriverManagerException(e);
        }
    }

    public void deleteFolder(File folder) {
        if (folder.isDirectory()) {
            log.trace("Deleting folder {}", (Object)folder);
            try {
                FileUtils.deleteDirectory(folder);
            }
            catch (IOException e) {
                throw new WebDriverManagerException(e);
            }
        } else {
            log.trace("{} cannot be deleted since it is not a directory", (Object)folder);
        }
    }
}

