/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.metrics.internal.state;

import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.context.Context;
import io.opentelemetry.sdk.common.InstrumentationScopeInfo;
import io.opentelemetry.sdk.common.export.MemoryMode;
import io.opentelemetry.sdk.internal.ThrottlingLogger;
import io.opentelemetry.sdk.metrics.View;
import io.opentelemetry.sdk.metrics.data.AggregationTemporality;
import io.opentelemetry.sdk.metrics.data.ExemplarData;
import io.opentelemetry.sdk.metrics.data.MetricData;
import io.opentelemetry.sdk.metrics.data.PointData;
import io.opentelemetry.sdk.metrics.internal.aggregator.Aggregator;
import io.opentelemetry.sdk.metrics.internal.aggregator.AggregatorFactory;
import io.opentelemetry.sdk.metrics.internal.descriptor.InstrumentDescriptor;
import io.opentelemetry.sdk.metrics.internal.descriptor.MetricDescriptor;
import io.opentelemetry.sdk.metrics.internal.exemplar.ExemplarFilter;
import io.opentelemetry.sdk.metrics.internal.export.RegisteredReader;
import io.opentelemetry.sdk.metrics.internal.state.Measurement;
import io.opentelemetry.sdk.metrics.internal.state.MetricStorage;
import io.opentelemetry.sdk.metrics.internal.state.ObjectPool;
import io.opentelemetry.sdk.metrics.internal.state.PooledHashMap;
import io.opentelemetry.sdk.metrics.internal.view.AttributesProcessor;
import io.opentelemetry.sdk.metrics.internal.view.RegisteredView;
import io.opentelemetry.sdk.resources.Resource;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

final class AsynchronousMetricStorage<T extends PointData, U extends ExemplarData>
implements MetricStorage {
    private static final Logger logger = Logger.getLogger(AsynchronousMetricStorage.class.getName());
    private final ThrottlingLogger throttlingLogger = new ThrottlingLogger(logger);
    private final RegisteredReader registeredReader;
    private final MetricDescriptor metricDescriptor;
    private final AggregationTemporality aggregationTemporality;
    private final Aggregator<T, U> aggregator;
    private final AttributesProcessor attributesProcessor;
    private final int maxCardinality;
    private Map<Attributes, T> points;
    private Map<Attributes, T> lastPoints;
    private final ObjectPool<T> reusablePointsPool;
    private final ArrayList<T> reusableResultList = new ArrayList();
    private final MemoryMode memoryMode;

    private AsynchronousMetricStorage(RegisteredReader registeredReader, MetricDescriptor metricDescriptor, Aggregator<T, U> aggregator, AttributesProcessor attributesProcessor, int maxCardinality) {
        this.registeredReader = registeredReader;
        this.metricDescriptor = metricDescriptor;
        this.aggregationTemporality = registeredReader.getReader().getAggregationTemporality(metricDescriptor.getSourceInstrument().getType());
        this.memoryMode = registeredReader.getReader().getMemoryMode();
        this.aggregator = aggregator;
        this.attributesProcessor = attributesProcessor;
        this.maxCardinality = maxCardinality - 1;
        this.reusablePointsPool = new ObjectPool<PointData>(aggregator::createReusablePoint);
        if (this.memoryMode == MemoryMode.REUSABLE_DATA) {
            this.lastPoints = new PooledHashMap<Attributes, T>();
            this.points = new PooledHashMap<Attributes, T>();
        } else {
            this.lastPoints = new HashMap<Attributes, T>();
            this.points = new HashMap<Attributes, T>();
        }
    }

    static <T extends PointData, U extends ExemplarData> AsynchronousMetricStorage<T, U> create(RegisteredReader registeredReader, RegisteredView registeredView, InstrumentDescriptor instrumentDescriptor) {
        View view = registeredView.getView();
        MetricDescriptor metricDescriptor = MetricDescriptor.create(view, registeredView.getViewSourceInfo(), instrumentDescriptor);
        Aggregator aggregator = ((AggregatorFactory)((Object)view.getAggregation())).createAggregator(instrumentDescriptor, ExemplarFilter.alwaysOff(), registeredReader.getReader().getMemoryMode());
        return new AsynchronousMetricStorage(registeredReader, metricDescriptor, aggregator, registeredView.getViewAttributesProcessor(), registeredView.getCardinalityLimit());
    }

    void record(Measurement measurement) {
        Context context = Context.current();
        Attributes processedAttributes = this.attributesProcessor.process(measurement.attributes(), context);
        long start2 = this.aggregationTemporality == AggregationTemporality.DELTA ? this.registeredReader.getLastCollectEpochNanos() : measurement.startEpochNanos();
        measurement = measurement.withAttributes(processedAttributes).withStartEpochNanos(start2);
        this.recordPoint(processedAttributes, measurement);
    }

    private void recordPoint(Attributes attributes, Measurement measurement) {
        PointData dataPoint;
        if (this.points.size() >= this.maxCardinality) {
            this.throttlingLogger.log(Level.WARNING, "Instrument " + this.metricDescriptor.getSourceInstrument().getName() + " has exceeded the maximum allowed cardinality (" + this.maxCardinality + ").");
            attributes = MetricStorage.CARDINALITY_OVERFLOW;
            measurement = measurement.withAttributes(attributes);
        } else if (this.points.containsKey(attributes)) {
            this.throttlingLogger.log(Level.WARNING, "Instrument " + this.metricDescriptor.getSourceInstrument().getName() + " has recorded multiple values for the same attributes: " + attributes);
            return;
        }
        if (this.memoryMode == MemoryMode.REUSABLE_DATA) {
            dataPoint = (PointData)this.reusablePointsPool.borrowObject();
            this.aggregator.toPoint(measurement, dataPoint);
        } else {
            dataPoint = this.aggregator.toPoint(measurement);
        }
        this.points.put(attributes, dataPoint);
    }

    @Override
    public MetricDescriptor getMetricDescriptor() {
        return this.metricDescriptor;
    }

    public RegisteredReader getRegisteredReader() {
        return this.registeredReader;
    }

    @Override
    public MetricData collect(Resource resource, InstrumentationScopeInfo instrumentationScopeInfo, long startEpochNanos, long epochNanos) {
        Collection<T> result;
        if (this.memoryMode == MemoryMode.REUSABLE_DATA) {
            this.reusableResultList.forEach(this.reusablePointsPool::returnObject);
            this.reusableResultList.clear();
        }
        if (this.aggregationTemporality == AggregationTemporality.DELTA) {
            Map<Attributes, T> points = this.points;
            Map<Attributes, T> lastPoints = this.lastPoints;
            ArrayList<Object> deltaPoints = this.memoryMode == MemoryMode.REUSABLE_DATA ? this.reusableResultList : new ArrayList();
            points.forEach((k, v) -> {
                PointData deltaPoint;
                PointData lastPoint = (PointData)lastPoints.get(k);
                if (lastPoint == null) {
                    if (this.memoryMode == MemoryMode.REUSABLE_DATA) {
                        deltaPoint = (PointData)this.reusablePointsPool.borrowObject();
                        this.aggregator.copyPoint((PointData)v, deltaPoint);
                    } else {
                        deltaPoint = v;
                    }
                } else if (this.memoryMode == MemoryMode.REUSABLE_DATA) {
                    this.aggregator.diffInPlace(lastPoint, (PointData)v);
                    deltaPoint = lastPoint;
                    lastPoints.remove(k);
                } else {
                    deltaPoint = this.aggregator.diff(lastPoint, (PointData)v);
                }
                deltaPoints.add(deltaPoint);
            });
            if (this.memoryMode == MemoryMode.REUSABLE_DATA) {
                lastPoints.forEach((k, v) -> this.reusablePointsPool.returnObject((PointData)v));
                lastPoints.clear();
                this.points = lastPoints;
            } else {
                this.points = new HashMap<Attributes, T>();
            }
            this.lastPoints = points;
            result = deltaPoints;
        } else if (this.memoryMode == MemoryMode.REUSABLE_DATA) {
            this.points.forEach((k, v) -> this.reusableResultList.add(v));
            this.points.clear();
            result = this.reusableResultList;
        } else {
            result = this.points.values();
            this.points = new HashMap<Attributes, T>();
        }
        return this.aggregator.toMetricData(resource, instrumentationScopeInfo, this.metricDescriptor, result, this.aggregationTemporality);
    }

    @Override
    public boolean isEmpty() {
        return this.aggregator == Aggregator.drop();
    }
}

