/*
 * Decompiled with CFR 0.152.
 */
package io.ous.jtoml;

import io.ous.jtoml.impl.ObjectDeserializer;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TomlTable
extends HashMap<String, Object> {
    public Object get(String key, Object ... keys2) throws IllegalArgumentException {
        Object value = this.get(key);
        if (keys2 != null) {
            for (Object key2 : keys2) {
                if (value instanceof TomlTable) {
                    value = ((TomlTable)value).get(key2);
                    continue;
                }
                if (value instanceof List && key2 instanceof Integer) {
                    value = ((List)value).get((Integer)key2);
                    continue;
                }
                throw new IllegalArgumentException(key2 + " is not a valid property under a " + value.getClass().getName());
            }
        }
        return value;
    }

    public Object getValue(String bar, Object ... keys2) {
        return this.get(bar, keys2);
    }

    public String getString(String name, Object ... keys2) throws ClassCastException {
        return (String)this.get(name, keys2);
    }

    public Long getLong(String name, Object ... keys2) throws ClassCastException {
        return (Long)this.get(name, keys2);
    }

    public Double getDouble(String name, Object ... keys2) throws ClassCastException {
        return (Double)this.get(name, keys2);
    }

    public Date getDate(String name, Object ... keys2) throws ClassCastException {
        return (Date)this.get(name, keys2);
    }

    public List<?> getList(String name, Object ... keys2) throws ClassCastException {
        return (List)this.get(name, keys2);
    }

    public List<TomlTable> getArrayTable(String name, Object ... keys2) throws ClassCastException {
        return (List)this.get(name, keys2);
    }

    public Boolean getBoolean(String name, Object ... keys2) throws ClassCastException {
        return (Boolean)this.get(name, keys2);
    }

    public TomlTable getTomlTable(String name, Object ... keys2) throws ClassCastException {
        return (TomlTable)this.get(name, keys2);
    }

    public <T extends Enum<T>> T getAsEnum(Class<T> type, String name, Object ... keys2) {
        Object value = this.get(name, keys2);
        return ObjectDeserializer.getInstance().toEnum(type, value);
    }

    public <T> T asObject(Class<T> type) {
        return ObjectDeserializer.getInstance().create(type, this);
    }

    public Map<String, Object> toMap() {
        return Collections.unmodifiableMap(this);
    }
}

