/*
 * Decompiled with CFR 0.152.
 */
package io.ous.jtoml.impl;

import io.ous.jtoml.ParseException;
import io.ous.jtoml.Toml;
import io.ous.jtoml.TomlTable;
import io.ous.jtoml.impl.SymbolToken;
import io.ous.jtoml.impl.Token;
import io.ous.jtoml.impl.Tokenizer;
import io.ous.jtoml.impl.ValuedToken;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Parser {
    private final Tokenizer parsedTokens;
    private final TomlTable output;

    public Parser(Reader reader) throws IOException {
        this(reader, new Toml());
    }

    public Parser(Reader reader, TomlTable toml) throws IOException {
        this.parsedTokens = Tokenizer.parse(reader);
        this.output = toml;
    }

    public TomlTable parse() {
        TomlTable currentTomlTable = this.output;
        while (this.parsedTokens.hasNext()) {
            try {
                Token token = this.parsedTokens.peek().token;
                if (token == SymbolToken.Newline) {
                    this.parsedTokens.next();
                    continue;
                }
                if (token == SymbolToken.SquareLeft) {
                    this.parsedTokens.next();
                    if (this.parsedTokens.nextIfMatch(SymbolToken.SquareLeft)) {
                        currentTomlTable = this.onArrayTable();
                        continue;
                    }
                    currentTomlTable = this.onTable();
                    continue;
                }
                if (token.getType() == Token.TokenType.Key || token.getType() == Token.TokenType.BasicString) {
                    this.onAssignment(currentTomlTable);
                    if (this.parsedTokens.nextIfMatch(SymbolToken.Newline)) continue;
                    throw this.error("Newline expected after assignment");
                }
                throw this.error("Unexpected token " + token);
            }
            catch (ParseException pe) {
                throw pe;
            }
            catch (Exception e) {
                throw this.parsedTokens.error("Unknown error", e);
            }
        }
        return this.output;
    }

    private void onAssignment(TomlTable currentTomlTable) {
        List<String> parts = this.readKeyParts(SymbolToken.Equals);
        String name = parts.remove(parts.size() - 1);
        TomlTable createIn = this.travelIn(currentTomlTable, parts);
        if (createIn.containsKey(name)) {
            throw this.error("Cannot overwrite key " + name);
        }
        Object value = this.readValue();
        createIn.put(name, value);
    }

    void removeNewlines() {
        while (this.parsedTokens.hasNext() && this.parsedTokens.peek().token == SymbolToken.Newline) {
            this.parsedTokens.next();
        }
    }

    private List<Object> readArray() {
        ArrayList<Object> ret = new ArrayList<Object>();
        this.removeNewlines();
        if (this.parsedTokens.peek().token == SymbolToken.SquareRight) {
            this.parsedTokens.next();
            return ret;
        }
        Class<?> type = null;
        while (true) {
            Object value = this.readValue();
            Class<?> currentType = value.getClass();
            if (type == null) {
                type = currentType;
            } else if (!type.equals(currentType)) {
                throw this.error("Mixing types in array is disallowed, " + type.getName() + "!=" + currentType.getName());
            }
            ret.add(value);
            this.removeNewlines();
            if (!this.parsedTokens.nextIfMatch(SymbolToken.Comma)) break;
            this.removeNewlines();
        }
        if (!this.parsedTokens.nextIfMatch(SymbolToken.SquareRight)) {
            throw this.error("Unexpected token " + this.parsedTokens.peek() + " between array values");
        }
        return ret;
    }

    private TomlTable readInlineTable() {
        TomlTable ret = new TomlTable();
        if (this.parsedTokens.nextIfMatch(SymbolToken.CurlyRight)) {
            return ret;
        }
        do {
            this.onAssignment(ret);
        } while (this.parsedTokens.nextIfMatch(SymbolToken.Comma));
        if (!this.parsedTokens.nextIfMatch(SymbolToken.CurlyRight)) {
            throw this.error("After assignment, ',' or '}' are expected in an inline table.");
        }
        return ret;
    }

    private Object readValue() {
        Token token = this.parsedTokens.next().token;
        if (token instanceof ValuedToken) {
            return ((ValuedToken)token).getValue();
        }
        if (token == SymbolToken.SquareLeft) {
            return this.readArray();
        }
        if (token == SymbolToken.CurlyLeft) {
            return this.readInlineTable();
        }
        throw this.error("Unexpected token " + token);
    }

    private List<String> readKeyParts(SymbolToken end) {
        ArrayList<String> parts;
        block4: {
            Token dotOrEnd;
            parts = new ArrayList<String>();
            do {
                String key;
                Token keyPart = this.parsedTokens.next().token;
                switch (keyPart.getType()) {
                    case Key: 
                    case BasicString: {
                        key = (String)((ValuedToken)keyPart).getValue();
                        break;
                    }
                    default: {
                        throw this.error("Key can only have bare keys or basic strings");
                    }
                }
                parts.add(key);
                dotOrEnd = this.parsedTokens.next().token;
                if (dotOrEnd == end) break block4;
            } while (dotOrEnd == SymbolToken.Dot);
            throw this.error("Expected '" + end + "' or '.', not " + dotOrEnd);
        }
        return parts;
    }

    private TomlTable diveFromRoot(List<String> names) {
        return this.travelIn(this.output, names);
    }

    private TomlTable travelIn(TomlTable start2, List<String> names) {
        TomlTable current = start2;
        for (String part : names) {
            Object value = current.get(part);
            if (value == null) {
                TomlTable child = new TomlTable();
                current.put(part, child);
                current = child;
                continue;
            }
            if (value instanceof TomlTable) {
                current = (TomlTable)value;
                continue;
            }
            if (value instanceof List) {
                List tableArray = (List)value;
                if (tableArray.isEmpty()) {
                    throw this.error("Cannot add to an already defined array");
                }
                Object arrayItem = tableArray.get(tableArray.size() - 1);
                if (arrayItem == null || !(arrayItem instanceof TomlTable)) {
                    throw this.error("There is already a non Table Array under " + names);
                }
                current = (TomlTable)arrayItem;
                continue;
            }
            throw this.error(names + " already has a non-table or array table value named " + part);
        }
        return current;
    }

    private TomlTable onTable() {
        List<String> parts = this.readKeyParts(SymbolToken.SquareRight);
        String last = parts.remove(parts.size() - 1);
        TomlTable in = this.diveFromRoot(parts);
        if (in.containsKey(last)) {
            throw this.error("Cannot overwrite existing value '" + last + "' with atable");
        }
        TomlTable value = new TomlTable();
        in.put(last, value);
        return value;
    }

    private TomlTable onArrayTable() {
        List<String> parts = this.readKeyParts(SymbolToken.SquareRight);
        if (!this.parsedTokens.nextIfMatch(SymbolToken.SquareRight)) {
            throw this.error("Array table must end with ]]");
        }
        String tableName = parts.remove(parts.size() - 1);
        TomlTable currentTomlTable = this.diveFromRoot(parts);
        List<?> tableArray = currentTomlTable.getList(tableName, new Object[0]);
        if (tableArray == null) {
            tableArray = new ArrayList();
            currentTomlTable.put(tableName, tableArray);
        } else if (!tableArray.isEmpty() && !(tableArray.get(0) instanceof TomlTable)) {
            throw this.error("Cannot add TableArray to an existing Array of other value type.");
        }
        currentTomlTable = new TomlTable();
        tableArray.add(currentTomlTable);
        return currentTomlTable;
    }

    private ParseException error(String msg) {
        Tokenizer.ParsedToken lastSeen = this.parsedTokens.lastSeen();
        return new ParseException(msg, lastSeen.line, lastSeen.chars);
    }
}

