/*
 * Decompiled with CFR 0.152.
 */
package io.ous.jtoml.impl;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

class StringCharacterIterator {
    private final String value;
    protected int at;

    public StringCharacterIterator(String value) {
        this.value = value;
        this.at = 0;
    }

    public String peekIfMatches(Pattern pattern) {
        String rest = this.peekAll();
        Matcher matcher = pattern.matcher(rest);
        if (matcher.find()) {
            return matcher.group();
        }
        return null;
    }

    public String nextIfMatches(Pattern pattern) {
        String ret = this.peekIfMatches(pattern);
        if (ret != null) {
            this.advance(ret.length());
        }
        return ret;
    }

    public int length() {
        return this.value.length();
    }

    public int length(String seq) {
        return seq.length();
    }

    public Character peek() {
        return Character.valueOf(this.value.charAt(this.at));
    }

    public String peek(int count) {
        return this.value.substring(this.at, this.at + count);
    }

    public String peekAll() {
        return this.value.substring(this.at);
    }

    protected boolean seqEquals(String a, String b) {
        return a == null ? a == b : a.equals(b);
    }

    public boolean hasNext() {
        return this.hasNext(1);
    }

    public boolean hasNext(int count) {
        return this.at + count - 1 < this.length();
    }

    public char next() {
        char value = this.peek().charValue();
        ++this.at;
        return value;
    }

    public String next(int count) {
        String ret = this.peek(count);
        this.at += count;
        return ret;
    }

    public boolean peekIfSeqEquals(String check2) {
        int length = this.length(check2);
        return this.hasNext(length) && this.seqEquals(this.peek(length), check2);
    }

    public boolean peekIfEquals(char check2) {
        if (!this.hasNext()) {
            return false;
        }
        char peek = this.peek().charValue();
        return peek == check2;
    }

    public boolean nextIfEquals(char check2) {
        if (this.peekIfEquals(check2)) {
            this.next(1);
            return true;
        }
        return false;
    }

    public boolean nextIfSeqEquals(String check2) {
        if (this.peekIfSeqEquals(check2)) {
            this.next(this.length(check2));
            return true;
        }
        return false;
    }

    public void advance(int length) {
        this.at += length;
    }

    public int currentIndex() {
        return this.at;
    }
}

