/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v121.security.model;

import java.util.Arrays;
import org.openqa.selenium.devtools.DevToolsException;
import org.openqa.selenium.json.JsonInput;

public enum MixedContentType {
    BLOCKABLE("blockable"),
    OPTIONALLY_BLOCKABLE("optionally-blockable"),
    NONE("none");

    private String value;

    private MixedContentType(String value) {
        this.value = value;
    }

    public static MixedContentType fromString(String s2) {
        return Arrays.stream(MixedContentType.values()).filter(rs -> rs.value.equalsIgnoreCase(s2)).findFirst().orElseThrow(() -> new DevToolsException("Given value " + s2 + " is not found within MixedContentType "));
    }

    public String toString() {
        return this.value;
    }

    public String toJson() {
        return this.value;
    }

    private static MixedContentType fromJson(JsonInput input) {
        return MixedContentType.fromString(input.nextString());
    }
}

