/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v121.serviceworker.model;

import java.lang.reflect.Type;
import java.util.Objects;
import org.openqa.selenium.devtools.v121.serviceworker.model.RegistrationID;
import org.openqa.selenium.json.JsonInput;

public class ServiceWorkerErrorMessage {
    private final String errorMessage;
    private final RegistrationID registrationId;
    private final String versionId;
    private final String sourceURL;
    private final Integer lineNumber;
    private final Integer columnNumber;

    public ServiceWorkerErrorMessage(String errorMessage, RegistrationID registrationId, String versionId, String sourceURL, Integer lineNumber, Integer columnNumber) {
        this.errorMessage = Objects.requireNonNull(errorMessage, "errorMessage is required");
        this.registrationId = Objects.requireNonNull(registrationId, "registrationId is required");
        this.versionId = Objects.requireNonNull(versionId, "versionId is required");
        this.sourceURL = Objects.requireNonNull(sourceURL, "sourceURL is required");
        this.lineNumber = Objects.requireNonNull(lineNumber, "lineNumber is required");
        this.columnNumber = Objects.requireNonNull(columnNumber, "columnNumber is required");
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public RegistrationID getRegistrationId() {
        return this.registrationId;
    }

    public String getVersionId() {
        return this.versionId;
    }

    public String getSourceURL() {
        return this.sourceURL;
    }

    public Integer getLineNumber() {
        return this.lineNumber;
    }

    public Integer getColumnNumber() {
        return this.columnNumber;
    }

    private static ServiceWorkerErrorMessage fromJson(JsonInput input) {
        String errorMessage = null;
        RegistrationID registrationId = null;
        String versionId = null;
        String sourceURL = null;
        Integer lineNumber = 0;
        Integer columnNumber = 0;
        input.beginObject();
        block16: while (input.hasNext()) {
            switch (input.nextName()) {
                case "errorMessage": {
                    errorMessage = input.nextString();
                    continue block16;
                }
                case "registrationId": {
                    registrationId = (RegistrationID)input.read((Type)((Object)RegistrationID.class));
                    continue block16;
                }
                case "versionId": {
                    versionId = input.nextString();
                    continue block16;
                }
                case "sourceURL": {
                    sourceURL = input.nextString();
                    continue block16;
                }
                case "lineNumber": {
                    lineNumber = input.nextNumber().intValue();
                    continue block16;
                }
                case "columnNumber": {
                    columnNumber = input.nextNumber().intValue();
                    continue block16;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new ServiceWorkerErrorMessage(errorMessage, registrationId, versionId, sourceURL, lineNumber, columnNumber);
    }
}

