/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v121.webauthn.model;

import java.util.Arrays;
import org.openqa.selenium.devtools.DevToolsException;
import org.openqa.selenium.json.JsonInput;

public enum Ctap2Version {
    CTAP2_0("ctap2_0"),
    CTAP2_1("ctap2_1");

    private String value;

    private Ctap2Version(String value) {
        this.value = value;
    }

    public static Ctap2Version fromString(String s2) {
        return Arrays.stream(Ctap2Version.values()).filter(rs -> rs.value.equalsIgnoreCase(s2)).findFirst().orElseThrow(() -> new DevToolsException("Given value " + s2 + " is not found within Ctap2Version "));
    }

    public String toString() {
        return this.value;
    }

    public String toJson() {
        return this.value;
    }

    private static Ctap2Version fromJson(JsonInput input) {
        return Ctap2Version.fromString(input.nextString());
    }
}

