/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v122.heapprofiler;

import java.lang.reflect.Type;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.openqa.selenium.Beta;
import org.openqa.selenium.devtools.Command;
import org.openqa.selenium.devtools.ConverterFunctions;
import org.openqa.selenium.devtools.Event;
import org.openqa.selenium.devtools.v122.heapprofiler.model.HeapSnapshotObjectId;
import org.openqa.selenium.devtools.v122.heapprofiler.model.LastSeenObjectId;
import org.openqa.selenium.devtools.v122.heapprofiler.model.ReportHeapSnapshotProgress;
import org.openqa.selenium.devtools.v122.heapprofiler.model.SamplingHeapProfile;
import org.openqa.selenium.devtools.v122.runtime.model.RemoteObject;
import org.openqa.selenium.devtools.v122.runtime.model.RemoteObjectId;

@Beta
public class HeapProfiler {
    public static Command<Void> addInspectedHeapObject(HeapSnapshotObjectId heapObjectId) {
        Objects.requireNonNull(heapObjectId, "heapObjectId is required");
        LinkedHashMap<String, HeapSnapshotObjectId> params = new LinkedHashMap<String, HeapSnapshotObjectId>();
        params.put("heapObjectId", heapObjectId);
        return new Command<Void>("HeapProfiler.addInspectedHeapObject", Map.copyOf(params));
    }

    public static Command<Void> collectGarbage() {
        LinkedHashMap params = new LinkedHashMap();
        return new Command<Void>("HeapProfiler.collectGarbage", Map.copyOf(params));
    }

    public static Command<Void> disable() {
        LinkedHashMap params = new LinkedHashMap();
        return new Command<Void>("HeapProfiler.disable", Map.copyOf(params));
    }

    public static Command<Void> enable() {
        LinkedHashMap params = new LinkedHashMap();
        return new Command<Void>("HeapProfiler.enable", Map.copyOf(params));
    }

    public static Command<HeapSnapshotObjectId> getHeapObjectId(RemoteObjectId objectId) {
        Objects.requireNonNull(objectId, "objectId is required");
        LinkedHashMap<String, RemoteObjectId> params = new LinkedHashMap<String, RemoteObjectId>();
        params.put("objectId", objectId);
        return new Command<HeapSnapshotObjectId>("HeapProfiler.getHeapObjectId", Map.copyOf(params), ConverterFunctions.map("heapSnapshotObjectId", HeapSnapshotObjectId.class));
    }

    public static Command<RemoteObject> getObjectByHeapObjectId(HeapSnapshotObjectId objectId, Optional<String> objectGroup) {
        Objects.requireNonNull(objectId, "objectId is required");
        LinkedHashMap<String, HeapSnapshotObjectId> params = new LinkedHashMap<String, HeapSnapshotObjectId>();
        params.put("objectId", objectId);
        objectGroup.ifPresent(p -> params.put("objectGroup", (HeapSnapshotObjectId)p));
        return new Command<RemoteObject>("HeapProfiler.getObjectByHeapObjectId", Map.copyOf(params), ConverterFunctions.map("result", RemoteObject.class));
    }

    public static Command<SamplingHeapProfile> getSamplingProfile() {
        LinkedHashMap params = new LinkedHashMap();
        return new Command<SamplingHeapProfile>("HeapProfiler.getSamplingProfile", Map.copyOf(params), ConverterFunctions.map("profile", SamplingHeapProfile.class));
    }

    public static Command<Void> startSampling(Optional<Number> samplingInterval, Optional<Boolean> includeObjectsCollectedByMajorGC, Optional<Boolean> includeObjectsCollectedByMinorGC) {
        LinkedHashMap params = new LinkedHashMap();
        samplingInterval.ifPresent(p -> params.put("samplingInterval", p));
        includeObjectsCollectedByMajorGC.ifPresent(p -> params.put("includeObjectsCollectedByMajorGC", p));
        includeObjectsCollectedByMinorGC.ifPresent(p -> params.put("includeObjectsCollectedByMinorGC", p));
        return new Command<Void>("HeapProfiler.startSampling", Map.copyOf(params));
    }

    public static Command<Void> startTrackingHeapObjects(Optional<Boolean> trackAllocations) {
        LinkedHashMap params = new LinkedHashMap();
        trackAllocations.ifPresent(p -> params.put("trackAllocations", p));
        return new Command<Void>("HeapProfiler.startTrackingHeapObjects", Map.copyOf(params));
    }

    public static Command<SamplingHeapProfile> stopSampling() {
        LinkedHashMap params = new LinkedHashMap();
        return new Command<SamplingHeapProfile>("HeapProfiler.stopSampling", Map.copyOf(params), ConverterFunctions.map("profile", SamplingHeapProfile.class));
    }

    public static Command<Void> stopTrackingHeapObjects(Optional<Boolean> reportProgress, Optional<Boolean> treatGlobalObjectsAsRoots, Optional<Boolean> captureNumericValue, Optional<Boolean> exposeInternals) {
        LinkedHashMap params = new LinkedHashMap();
        reportProgress.ifPresent(p -> params.put("reportProgress", p));
        treatGlobalObjectsAsRoots.ifPresent(p -> params.put("treatGlobalObjectsAsRoots", p));
        captureNumericValue.ifPresent(p -> params.put("captureNumericValue", p));
        exposeInternals.ifPresent(p -> params.put("exposeInternals", p));
        return new Command<Void>("HeapProfiler.stopTrackingHeapObjects", Map.copyOf(params));
    }

    public static Command<Void> takeHeapSnapshot(Optional<Boolean> reportProgress, Optional<Boolean> treatGlobalObjectsAsRoots, Optional<Boolean> captureNumericValue, Optional<Boolean> exposeInternals) {
        LinkedHashMap params = new LinkedHashMap();
        reportProgress.ifPresent(p -> params.put("reportProgress", p));
        treatGlobalObjectsAsRoots.ifPresent(p -> params.put("treatGlobalObjectsAsRoots", p));
        captureNumericValue.ifPresent(p -> params.put("captureNumericValue", p));
        exposeInternals.ifPresent(p -> params.put("exposeInternals", p));
        return new Command<Void>("HeapProfiler.takeHeapSnapshot", Map.copyOf(params));
    }

    public static Event<String> addHeapSnapshotChunk() {
        return new Event<String>("HeapProfiler.addHeapSnapshotChunk", ConverterFunctions.map("chunk", String.class));
    }

    public static Event<List<Integer>> heapStatsUpdate() {
        return new Event<List<Integer>>("HeapProfiler.heapStatsUpdate", ConverterFunctions.map("statsUpdate", input -> input.readArray((Type)((Object)Integer.class))));
    }

    public static Event<LastSeenObjectId> lastSeenObjectId() {
        return new Event<LastSeenObjectId>("HeapProfiler.lastSeenObjectId", input -> (LastSeenObjectId)input.read((Type)((Object)LastSeenObjectId.class)));
    }

    public static Event<ReportHeapSnapshotProgress> reportHeapSnapshotProgress() {
        return new Event<ReportHeapSnapshotProgress>("HeapProfiler.reportHeapSnapshotProgress", input -> (ReportHeapSnapshotProgress)input.read((Type)((Object)ReportHeapSnapshotProgress.class)));
    }

    public static Event<Void> resetProfiles() {
        return new Event<Void>("HeapProfiler.resetProfiles", ConverterFunctions.empty());
    }
}

