/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v122.webaudio;

import java.lang.reflect.Type;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.openqa.selenium.Beta;
import org.openqa.selenium.devtools.Command;
import org.openqa.selenium.devtools.ConverterFunctions;
import org.openqa.selenium.devtools.Event;
import org.openqa.selenium.devtools.v122.webaudio.model.AudioListener;
import org.openqa.selenium.devtools.v122.webaudio.model.AudioListenerWillBeDestroyed;
import org.openqa.selenium.devtools.v122.webaudio.model.AudioNode;
import org.openqa.selenium.devtools.v122.webaudio.model.AudioNodeWillBeDestroyed;
import org.openqa.selenium.devtools.v122.webaudio.model.AudioParam;
import org.openqa.selenium.devtools.v122.webaudio.model.AudioParamWillBeDestroyed;
import org.openqa.selenium.devtools.v122.webaudio.model.BaseAudioContext;
import org.openqa.selenium.devtools.v122.webaudio.model.ContextRealtimeData;
import org.openqa.selenium.devtools.v122.webaudio.model.GraphObjectId;
import org.openqa.selenium.devtools.v122.webaudio.model.NodeParamConnected;
import org.openqa.selenium.devtools.v122.webaudio.model.NodeParamDisconnected;
import org.openqa.selenium.devtools.v122.webaudio.model.NodesConnected;
import org.openqa.selenium.devtools.v122.webaudio.model.NodesDisconnected;

@Beta
public class WebAudio {
    public static Command<Void> enable() {
        LinkedHashMap params = new LinkedHashMap();
        return new Command<Void>("WebAudio.enable", Map.copyOf(params));
    }

    public static Command<Void> disable() {
        LinkedHashMap params = new LinkedHashMap();
        return new Command<Void>("WebAudio.disable", Map.copyOf(params));
    }

    public static Command<ContextRealtimeData> getRealtimeData(GraphObjectId contextId) {
        Objects.requireNonNull(contextId, "contextId is required");
        LinkedHashMap<String, GraphObjectId> params = new LinkedHashMap<String, GraphObjectId>();
        params.put("contextId", contextId);
        return new Command<ContextRealtimeData>("WebAudio.getRealtimeData", Map.copyOf(params), ConverterFunctions.map("realtimeData", ContextRealtimeData.class));
    }

    public static Event<BaseAudioContext> contextCreated() {
        return new Event<BaseAudioContext>("WebAudio.contextCreated", ConverterFunctions.map("context", BaseAudioContext.class));
    }

    public static Event<GraphObjectId> contextWillBeDestroyed() {
        return new Event<GraphObjectId>("WebAudio.contextWillBeDestroyed", ConverterFunctions.map("contextId", GraphObjectId.class));
    }

    public static Event<BaseAudioContext> contextChanged() {
        return new Event<BaseAudioContext>("WebAudio.contextChanged", ConverterFunctions.map("context", BaseAudioContext.class));
    }

    public static Event<AudioListener> audioListenerCreated() {
        return new Event<AudioListener>("WebAudio.audioListenerCreated", ConverterFunctions.map("listener", AudioListener.class));
    }

    public static Event<AudioListenerWillBeDestroyed> audioListenerWillBeDestroyed() {
        return new Event<AudioListenerWillBeDestroyed>("WebAudio.audioListenerWillBeDestroyed", input -> (AudioListenerWillBeDestroyed)input.read((Type)((Object)AudioListenerWillBeDestroyed.class)));
    }

    public static Event<AudioNode> audioNodeCreated() {
        return new Event<AudioNode>("WebAudio.audioNodeCreated", ConverterFunctions.map("node", AudioNode.class));
    }

    public static Event<AudioNodeWillBeDestroyed> audioNodeWillBeDestroyed() {
        return new Event<AudioNodeWillBeDestroyed>("WebAudio.audioNodeWillBeDestroyed", input -> (AudioNodeWillBeDestroyed)input.read((Type)((Object)AudioNodeWillBeDestroyed.class)));
    }

    public static Event<AudioParam> audioParamCreated() {
        return new Event<AudioParam>("WebAudio.audioParamCreated", ConverterFunctions.map("param", AudioParam.class));
    }

    public static Event<AudioParamWillBeDestroyed> audioParamWillBeDestroyed() {
        return new Event<AudioParamWillBeDestroyed>("WebAudio.audioParamWillBeDestroyed", input -> (AudioParamWillBeDestroyed)input.read((Type)((Object)AudioParamWillBeDestroyed.class)));
    }

    public static Event<NodesConnected> nodesConnected() {
        return new Event<NodesConnected>("WebAudio.nodesConnected", input -> (NodesConnected)input.read((Type)((Object)NodesConnected.class)));
    }

    public static Event<NodesDisconnected> nodesDisconnected() {
        return new Event<NodesDisconnected>("WebAudio.nodesDisconnected", input -> (NodesDisconnected)input.read((Type)((Object)NodesDisconnected.class)));
    }

    public static Event<NodeParamConnected> nodeParamConnected() {
        return new Event<NodeParamConnected>("WebAudio.nodeParamConnected", input -> (NodeParamConnected)input.read((Type)((Object)NodeParamConnected.class)));
    }

    public static Event<NodeParamDisconnected> nodeParamDisconnected() {
        return new Event<NodeParamDisconnected>("WebAudio.nodeParamDisconnected", input -> (NodeParamDisconnected)input.read((Type)((Object)NodeParamDisconnected.class)));
    }
}

