/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v85.fetch.model;

import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import org.openqa.selenium.Beta;
import org.openqa.selenium.devtools.DevToolsException;
import org.openqa.selenium.json.JsonInput;

@Beta
public class AuthChallenge {
    private final Optional<Source> source;
    private final String origin;
    private final String scheme;
    private final String realm;

    public AuthChallenge(Optional<Source> source, String origin, String scheme2, String realm) {
        this.source = source;
        this.origin = Objects.requireNonNull(origin, "origin is required");
        this.scheme = Objects.requireNonNull(scheme2, "scheme is required");
        this.realm = Objects.requireNonNull(realm, "realm is required");
    }

    public Optional<Source> getSource() {
        return this.source;
    }

    public String getOrigin() {
        return this.origin;
    }

    public String getScheme() {
        return this.scheme;
    }

    public String getRealm() {
        return this.realm;
    }

    private static AuthChallenge fromJson(JsonInput input) {
        Optional<Source> source = Optional.empty();
        String origin = null;
        String scheme2 = null;
        String realm = null;
        input.beginObject();
        block12: while (input.hasNext()) {
            switch (input.nextName()) {
                case "source": {
                    source = Optional.ofNullable(Source.fromString(input.nextString()));
                    continue block12;
                }
                case "origin": {
                    origin = input.nextString();
                    continue block12;
                }
                case "scheme": {
                    scheme2 = input.nextString();
                    continue block12;
                }
                case "realm": {
                    realm = input.nextString();
                    continue block12;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new AuthChallenge(source, origin, scheme2, realm);
    }

    public static enum Source {
        SERVER("Server"),
        PROXY("Proxy");

        private String value;

        private Source(String value) {
            this.value = value;
        }

        public static Source fromString(String s2) {
            return Arrays.stream(Source.values()).filter(rs -> rs.value.equalsIgnoreCase(s2)).findFirst().orElseThrow(() -> new DevToolsException("Given value " + s2 + " is not found within Source "));
        }

        public String toString() {
            return this.value;
        }

        public String toJson() {
            return this.value;
        }

        private static Source fromJson(JsonInput input) {
            return Source.fromString(input.nextString());
        }
    }
}

