/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v85.network.model;

import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import org.openqa.selenium.devtools.DevToolsException;
import org.openqa.selenium.devtools.v85.runtime.model.StackTrace;
import org.openqa.selenium.json.JsonInput;

public class Initiator {
    private final Type type;
    private final Optional<StackTrace> stack;
    private final Optional<String> url;
    private final Optional<Number> lineNumber;

    public Initiator(Type type, Optional<StackTrace> stack, Optional<String> url2, Optional<Number> lineNumber) {
        this.type = Objects.requireNonNull(type, "type is required");
        this.stack = stack;
        this.url = url2;
        this.lineNumber = lineNumber;
    }

    public Type getType() {
        return this.type;
    }

    public Optional<StackTrace> getStack() {
        return this.stack;
    }

    public Optional<String> getUrl() {
        return this.url;
    }

    public Optional<Number> getLineNumber() {
        return this.lineNumber;
    }

    private static Initiator fromJson(JsonInput input) {
        Type type = null;
        Optional<StackTrace> stack = Optional.empty();
        Optional<String> url2 = Optional.empty();
        Optional<Number> lineNumber = Optional.empty();
        input.beginObject();
        block12: while (input.hasNext()) {
            switch (input.nextName()) {
                case "type": {
                    type = Type.fromString(input.nextString());
                    continue block12;
                }
                case "stack": {
                    stack = Optional.ofNullable((StackTrace)input.read((java.lang.reflect.Type)((Object)StackTrace.class)));
                    continue block12;
                }
                case "url": {
                    url2 = Optional.ofNullable(input.nextString());
                    continue block12;
                }
                case "lineNumber": {
                    lineNumber = Optional.ofNullable(input.nextNumber());
                    continue block12;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new Initiator(type, stack, url2, lineNumber);
    }

    public static enum Type {
        PARSER("parser"),
        SCRIPT("script"),
        PRELOAD("preload"),
        SIGNEDEXCHANGE("SignedExchange"),
        OTHER("other");

        private String value;

        private Type(String value) {
            this.value = value;
        }

        public static Type fromString(String s2) {
            return Arrays.stream(Type.values()).filter(rs -> rs.value.equalsIgnoreCase(s2)).findFirst().orElseThrow(() -> new DevToolsException("Given value " + s2 + " is not found within Type "));
        }

        public String toString() {
            return this.value;
        }

        public String toJson() {
            return this.value;
        }

        private static Type fromJson(JsonInput input) {
            return Type.fromString(input.nextString());
        }
    }
}

