/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.docker;

import java.time.Duration;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openqa.selenium.docker.ContainerId;
import org.openqa.selenium.docker.ContainerInfo;
import org.openqa.selenium.docker.ContainerLogs;
import org.openqa.selenium.docker.DockerProtocol;
import org.openqa.selenium.internal.Require;

public class Container {
    private static final Logger LOG = Logger.getLogger(Container.class.getName());
    private final DockerProtocol protocol;
    private final ContainerId id;
    private boolean running;

    public Container(DockerProtocol protocol, ContainerId id) {
        this.protocol = Require.nonNull("Protocol", protocol);
        this.id = Require.nonNull("Container id", id);
        this.running = false;
        LOG.info("Created container " + id);
    }

    public ContainerId getId() {
        return this.id;
    }

    public void start() {
        LOG.info("Starting container " + this.getId());
        this.protocol.startContainer(this.id);
        this.running = true;
    }

    public void stop(Duration timeout) {
        Require.nonNull("Timeout to wait for", timeout);
        if (this.running) {
            LOG.info("Stopping container " + this.getId());
            try {
                this.protocol.stopContainer(this.id, timeout);
                this.running = false;
            }
            catch (RuntimeException e) {
                LOG.log(Level.WARNING, "Unable to stop container: " + e.getMessage(), e);
            }
        }
    }

    public ContainerInfo inspect() {
        LOG.info("Inspecting container " + this.getId());
        return this.protocol.inspectContainer(this.getId());
    }

    public ContainerLogs getLogs() {
        if (this.running) {
            LOG.info("Getting logs " + this.getId());
            return this.protocol.getContainerLogs(this.getId());
        }
        return new ContainerLogs(this.getId(), new ArrayList<String>());
    }
}

