/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.grid.config;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSortedSet;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.openqa.selenium.grid.config.Config;
import org.openqa.selenium.internal.Require;

public class MapConfig
implements Config {
    private final Map<String, Map<String, Object>> raw;

    public MapConfig(Map<String, Object> raw) {
        Require.nonNull("Underlying map", raw);
        ImmutableMap.Builder<String, ImmutableMap<String, Object>> builder = ImmutableMap.builder();
        for (Map.Entry<String, Object> entry : raw.entrySet()) {
            if (!(entry.getValue() instanceof Map)) continue;
            ImmutableMap<String, Object> values2 = ((Map)entry.getValue()).entrySet().stream().filter(e -> e.getKey() instanceof String).collect(ImmutableMap.toImmutableMap(e -> String.valueOf(e.getKey()), Map.Entry::getValue));
            builder.put(entry.getKey(), values2);
        }
        this.raw = builder.build();
    }

    @Override
    public Optional<List<String>> getAll(String section, String option) {
        Require.nonNull("Section name", section);
        Require.nonNull("Option name", option);
        Map<String, Object> rawSection = this.raw.get(section);
        if (rawSection == null) {
            return Optional.empty();
        }
        Object value = rawSection.get(option);
        if (value == null) {
            return Optional.empty();
        }
        if (value instanceof Collection) {
            Collection collection = (Collection)value;
            if (collection.stream().anyMatch(item -> item instanceof Map)) {
                return Optional.of((List)collection.stream().map(item -> (Map)item).map(this::toEntryList).flatMap(Collection::stream).collect(ImmutableList.toImmutableList()));
            }
            return Optional.of((List)collection.stream().filter(item -> !(item instanceof Collection)).map(String::valueOf).collect(ImmutableList.toImmutableList()));
        }
        if (value instanceof Map) {
            return Optional.of(this.toEntryList((Map)value));
        }
        return Optional.of(ImmutableList.of(String.valueOf(value)));
    }

    @Override
    public Set<String> getSectionNames() {
        return ImmutableSet.copyOf(this.raw.keySet());
    }

    @Override
    public Set<String> getOptions(String section) {
        Require.nonNull("Section name to get options for", section);
        Map values2 = this.raw.getOrDefault(section, ImmutableMap.of());
        return ImmutableSortedSet.copyOf(values2.keySet());
    }
}

