/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.grid.distributor.remote;

import java.net.URL;
import java.util.function.Supplier;
import java.util.logging.Logger;
import org.openqa.selenium.SessionNotCreatedException;
import org.openqa.selenium.grid.data.CreateSessionResponse;
import org.openqa.selenium.grid.data.DistributorStatus;
import org.openqa.selenium.grid.data.NodeId;
import org.openqa.selenium.grid.data.SessionRequest;
import org.openqa.selenium.grid.distributor.Distributor;
import org.openqa.selenium.grid.node.Node;
import org.openqa.selenium.grid.security.AddSecretFilter;
import org.openqa.selenium.grid.security.Secret;
import org.openqa.selenium.grid.web.Values;
import org.openqa.selenium.internal.Either;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.remote.http.Contents;
import org.openqa.selenium.remote.http.Filter;
import org.openqa.selenium.remote.http.HttpClient;
import org.openqa.selenium.remote.http.HttpHandler;
import org.openqa.selenium.remote.http.HttpMethod;
import org.openqa.selenium.remote.http.HttpRequest;
import org.openqa.selenium.remote.http.HttpResponse;
import org.openqa.selenium.remote.tracing.HttpTracing;
import org.openqa.selenium.remote.tracing.Tracer;

public class RemoteDistributor
extends Distributor {
    private static final Logger LOG = Logger.getLogger("Selenium Distributor (Remote)");
    private final HttpHandler client;
    private final Filter addSecret;

    public RemoteDistributor(Tracer tracer, HttpClient.Factory factory, URL url2, Secret registrationSecret) {
        super(tracer, factory, registrationSecret);
        this.client = factory.createClient(url2);
        this.addSecret = new AddSecretFilter(registrationSecret);
    }

    @Override
    public boolean isReady() {
        try {
            return this.client.execute(new HttpRequest(HttpMethod.GET, "/readyz")).isSuccessful();
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public RemoteDistributor add(Node node) {
        HttpRequest request = new HttpRequest(HttpMethod.POST, "/se/grid/distributor/node");
        HttpTracing.inject(this.tracer, this.tracer.getCurrentContext(), request);
        request.setContent((Supplier)Contents.asJson(node.getStatus()));
        HttpResponse response = this.client.with(this.addSecret).execute(request);
        Values.get(response, Void.class);
        LOG.info(String.format("Added node %s.", node.getId()));
        return this;
    }

    @Override
    public boolean drain(NodeId nodeId) {
        Require.nonNull("Node ID", nodeId);
        HttpRequest request = new HttpRequest(HttpMethod.POST, "/se/grid/distributor/node/" + nodeId + "/drain");
        HttpTracing.inject(this.tracer, this.tracer.getCurrentContext(), request);
        request.setContent((Supplier)Contents.asJson(nodeId));
        HttpResponse response = this.client.with(this.addSecret).execute(request);
        return (Boolean)Values.get(response, Boolean.class);
    }

    @Override
    public void remove(NodeId nodeId) {
        Require.nonNull("Node ID", nodeId);
        HttpRequest request = new HttpRequest(HttpMethod.DELETE, "/se/grid/distributor/node/" + nodeId);
        HttpTracing.inject(this.tracer, this.tracer.getCurrentContext(), request);
        HttpResponse response = this.client.with(this.addSecret).execute(request);
        Values.get(response, Void.class);
    }

    @Override
    public DistributorStatus getStatus() {
        HttpRequest request = new HttpRequest(HttpMethod.GET, "/se/grid/distributor/status");
        HttpTracing.inject(this.tracer, this.tracer.getCurrentContext(), request);
        HttpResponse response = this.client.execute(request);
        return (DistributorStatus)Values.get(response, DistributorStatus.class);
    }

    @Override
    public Either<SessionNotCreatedException, CreateSessionResponse> newSession(SessionRequest sessionRequest) throws SessionNotCreatedException {
        HttpRequest req = (HttpRequest)new HttpRequest(HttpMethod.POST, "/se/grid/distributor/session").setContent((Supplier)Contents.asJson(sessionRequest));
        HttpTracing.inject(this.tracer, this.tracer.getCurrentContext(), req);
        HttpResponse res = this.client.execute(req);
        if (res.isSuccessful()) {
            return Either.right((CreateSessionResponse)Values.get(res, CreateSessionResponse.class));
        }
        return Either.left((SessionNotCreatedException)Values.get(res, SessionNotCreatedException.class));
    }
}

