/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.grid.router;

import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.openqa.selenium.grid.data.Availability;
import org.openqa.selenium.grid.data.DistributorStatus;
import org.openqa.selenium.grid.data.NodeId;
import org.openqa.selenium.grid.distributor.Distributor;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.remote.http.Contents;
import org.openqa.selenium.remote.http.HttpHandler;
import org.openqa.selenium.remote.http.HttpRequest;
import org.openqa.selenium.remote.http.HttpResponse;
import org.openqa.selenium.remote.tracing.AttributeKey;
import org.openqa.selenium.remote.tracing.AttributeMap;
import org.openqa.selenium.remote.tracing.HttpTracing;
import org.openqa.selenium.remote.tracing.Span;
import org.openqa.selenium.remote.tracing.Status;
import org.openqa.selenium.remote.tracing.Tags;
import org.openqa.selenium.remote.tracing.Tracer;

class GridStatusHandler
implements HttpHandler {
    private static final ExecutorService EXECUTOR_SERVICE = Executors.newCachedThreadPool(r -> {
        Thread thread2 = new Thread(r, "Grid status executor");
        thread2.setDaemon(true);
        return thread2;
    });
    private final Tracer tracer;
    private final Distributor distributor;

    GridStatusHandler(Tracer tracer, Distributor distributor) {
        this.tracer = Require.nonNull("Tracer", tracer);
        this.distributor = Require.nonNull("Distributor", distributor);
    }

    /*
     * Loose catch block
     */
    @Override
    public HttpResponse execute(HttpRequest req) {
        Throwable throwable2222;
        Span span = HttpTracing.newSpanAsChildOf(this.tracer, req, "grid.status");
        try {
            DistributorStatus status;
            AttributeMap attributeMap = this.tracer.createAttributeMap();
            attributeMap.put(AttributeKey.LOGGER_CLASS.getKey(), this.getClass().getName());
            Tags.HTTP_REQUEST.accept(span, req);
            Tags.HTTP_REQUEST_EVENT.accept(attributeMap, req);
            try {
                status = EXECUTOR_SERVICE.submit(span.wrap(this.distributor::getStatus)).get(2L, TimeUnit.SECONDS);
            }
            catch (ExecutionException | TimeoutException e) {
                span.setAttribute(AttributeKey.ERROR.getKey(), true);
                span.setStatus(Status.CANCELLED);
                Tags.EXCEPTION.accept(attributeMap, e);
                attributeMap.put(AttributeKey.EXCEPTION_MESSAGE.getKey(), "Error or timeout while getting Distributor status: " + e.getMessage());
                HttpResponse response = (HttpResponse)new HttpResponse().setContent((Supplier)Contents.asJson(ImmutableMap.of("value", ImmutableMap.of("ready", false, "message", "Unable to read distributor status."))));
                Tags.HTTP_RESPONSE.accept(span, response);
                Tags.HTTP_RESPONSE_EVENT.accept(attributeMap, response);
                span.addEvent(AttributeKey.EXCEPTION_EVENT.getKey(), attributeMap);
                HttpResponse httpResponse = response;
                if (span != null) {
                    span.close();
                }
                return httpResponse;
            }
            catch (InterruptedException e) {
                span.setAttribute(AttributeKey.ERROR.getKey(), true);
                span.setStatus(Status.ABORTED);
                Tags.EXCEPTION.accept(attributeMap, e);
                attributeMap.put(AttributeKey.EXCEPTION_MESSAGE.getKey(), "Interruption while getting distributor status: " + e.getMessage());
                HttpResponse response = (HttpResponse)new HttpResponse().setContent((Supplier)Contents.asJson(ImmutableMap.of("value", ImmutableMap.of("ready", false, "message", "Reading distributor status was interrupted."))));
                Tags.HTTP_RESPONSE.accept(span, response);
                Tags.HTTP_RESPONSE_EVENT.accept(attributeMap, response);
                span.addEvent(AttributeKey.EXCEPTION_EVENT.getKey(), attributeMap);
                Thread.currentThread().interrupt();
                HttpResponse httpResponse = response;
                if (span != null) {
                    span.close();
                }
                return httpResponse;
            }
            boolean ready = status.getNodes().stream().anyMatch(nodeStatus -> Availability.UP.equals((Object)nodeStatus.getAvailability()) && nodeStatus.hasCapacity());
            List nodeResults = status.getNodes().stream().map(node -> new ImmutableMap.Builder<String, NodeId>().put("id", node.getNodeId()).put("uri", (NodeId)((Object)node.getExternalUri())).put("maxSessions", (NodeId)((Object)Integer.valueOf(node.getMaxSessionCount()))).put("osInfo", (NodeId)((Object)node.getOsInfo())).put("heartbeatPeriod", (Map<String, String>)node.getHeartbeatPeriod().toMillis()).put("availability", (Map<String, String>)((Object)node.getAvailability())).put("version", (Map<String, String>)((Object)node.getVersion())).put("slots", (Map<String, String>)((Object)node.getSlots())).build()).collect(Collectors.toList());
            ImmutableMap.Builder<String, Object> value = ImmutableMap.builder();
            value.put("ready", ready);
            value.put("message", ready ? "Selenium Grid ready." : "Selenium Grid not ready.");
            value.put("nodes", nodeResults);
            HttpResponse res = (HttpResponse)new HttpResponse().setContent((Supplier)Contents.asJson(ImmutableMap.of("value", value.build())));
            Tags.HTTP_RESPONSE.accept(span, res);
            Tags.HTTP_RESPONSE_EVENT.accept(attributeMap, res);
            attributeMap.put("grid.status", ready);
            span.setStatus(Status.OK);
            span.addEvent("Computed grid status", attributeMap);
            HttpResponse httpResponse = res;
            return httpResponse;
            {
                catch (Throwable throwable2222) {
                    throw throwable2222;
                }
            }
        }
        finally {
            if (span != null) {
                try {
                    span.close();
                }
                catch (Throwable throwable3) {
                    throwable2222.addSuppressed(throwable3);
                }
            }
        }
    }
}

