/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.grid.web;

import com.google.common.net.MediaType;
import java.io.UncheckedIOException;
import java.util.Map;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.json.Json;
import org.openqa.selenium.remote.http.Contents;
import org.openqa.selenium.remote.http.HttpHandler;
import org.openqa.selenium.remote.http.HttpMethod;
import org.openqa.selenium.remote.http.HttpRequest;
import org.openqa.selenium.remote.http.HttpResponse;

public class StatusBasedReadinessCheck
implements HttpHandler {
    private static final Logger LOG = Logger.getLogger(StatusBasedReadinessCheck.class.getName());
    private static final Json JSON = new Json();
    private final HttpHandler handler;
    private final HttpMethod method;
    private final String url;

    public StatusBasedReadinessCheck(HttpHandler handler, HttpMethod method, String url2) {
        this.handler = Require.nonNull("handler", handler);
        this.method = Require.nonNull("HTTP method", method);
        this.url = Require.nonNull("URL for status", url2);
    }

    @Override
    public HttpResponse execute(HttpRequest req) throws UncheckedIOException {
        try {
            Object ready;
            HttpResponse response = this.handler.execute(new HttpRequest(this.method, this.url));
            Map valueWrapped = (Map)JSON.toType(Contents.string(response), Json.MAP_TYPE);
            Object value = valueWrapped.get("value");
            if (value instanceof Map && Boolean.TRUE.equals(ready = ((Map)value).get("ready"))) {
                return new HttpResponse().setStatus(204);
            }
            return (HttpResponse)((HttpResponse)new HttpResponse().setStatus(500).setHeader("Content-Type", MediaType.PLAIN_TEXT_UTF_8.toString())).setContent((Supplier)Contents.utf8String("Unable to determine status of server from " + valueWrapped));
        }
        catch (Exception e) {
            LOG.log(Level.WARNING, "Unable to read status", e);
            return (HttpResponse)((HttpResponse)new HttpResponse().setStatus(500).setHeader("Content-Type", MediaType.PLAIN_TEXT_UTF_8.toString())).setContent((Supplier)Contents.utf8String("Unable to determine status of server"));
        }
    }
}

