/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.json;

import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.json.JsonException;
import org.openqa.selenium.json.JsonInput;
import org.openqa.selenium.json.JsonTypeCoercer;
import org.openqa.selenium.json.PropertySetting;
import org.openqa.selenium.json.TypeCoercer;

class ObjectCoercer
extends TypeCoercer {
    private final JsonTypeCoercer coercer;

    ObjectCoercer(JsonTypeCoercer coercer) {
        this.coercer = Require.nonNull("Type coercer", coercer);
    }

    @Override
    public boolean test(Class type) {
        return Object.class.equals((Object)type);
    }

    @Override
    public BiFunction<JsonInput, PropertySetting, Object> apply(Type type) {
        return (jsonInput, setting) -> {
            Class target;
            switch (jsonInput.peek()) {
                case BOOLEAN: {
                    target = Boolean.class;
                    break;
                }
                case NAME: 
                case STRING: {
                    target = String.class;
                    break;
                }
                case NUMBER: {
                    target = Number.class;
                    break;
                }
                case START_COLLECTION: {
                    target = List.class;
                    break;
                }
                case START_MAP: {
                    target = Map.class;
                    break;
                }
                default: {
                    throw new JsonException("Object coercer cannot determine proper type: " + jsonInput.peek());
                }
            }
            return this.coercer.coerce((JsonInput)jsonInput, (Type)((Object)target), (PropertySetting)((Object)setting));
        };
    }
}

