/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.net;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.regex.Pattern;
import org.openqa.selenium.internal.Require;

public class Urls {
    private Urls() {
    }

    public static String urlEncode(String value) {
        try {
            return URLEncoder.encode(value, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static URL fromUri(URI uri2) {
        try {
            return uri2.toURL();
        }
        catch (MalformedURLException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static URI from(String rawUri) {
        Require.nonNull("URL to convert", rawUri);
        try {
            int colonIndex = rawUri.indexOf(58);
            int slashIndex = rawUri.indexOf(47);
            if (slashIndex == -1 && colonIndex == -1) {
                return Urls.createHttpUri(rawUri);
            }
            if (colonIndex != -1) {
                if (colonIndex == 0) {
                    return Urls.createHttpUri(rawUri);
                }
                if (Pattern.matches("\\d+", rawUri.substring(0, colonIndex))) {
                    return Urls.createHttpUri(rawUri);
                }
            }
            return new URI(rawUri);
        }
        catch (URISyntaxException e) {
            throw new UncheckedIOException(new IOException(e));
        }
    }

    private static URI createHttpUri(String rawHost) {
        int slashIndex = rawHost.indexOf(47);
        String host2 = slashIndex == -1 ? rawHost : rawHost.substring(0, slashIndex);
        String path = slashIndex == -1 ? null : rawHost.substring(slashIndex);
        try {
            return new URI("http", host2, path, null);
        }
        catch (URISyntaxException e) {
            throw new UncheckedIOException(new IOException(e));
        }
    }
}

