/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote.http;

import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.remote.http.Contents;
import org.openqa.selenium.remote.http.HttpHeader;

abstract class HttpMessage<M extends HttpMessage<M>> {
    private final Map<String, List<String>> headers = new HashMap<String, List<String>>();
    private final Map<String, Object> attributes = new HashMap<String, Object>();
    private Supplier<InputStream> content = Contents.empty();

    HttpMessage() {
    }

    public Object getAttribute(String key) {
        return this.attributes.get(key);
    }

    public M setAttribute(String key, Object value) {
        this.attributes.put(key, value);
        return this.self();
    }

    public M removeAttribute(String key) {
        this.attributes.remove(key);
        return this.self();
    }

    public Iterable<String> getAttributeNames() {
        return Set.copyOf(this.attributes.keySet());
    }

    public void forEachHeader(BiConsumer<String, String> action) {
        this.headers.forEach((name, values2) -> values2.forEach(value -> action.accept((String)name, (String)value)));
    }

    public Iterable<String> getHeaderNames() {
        return Collections.unmodifiableCollection(this.headers.keySet());
    }

    public Iterable<String> getHeaders(String name) {
        return this.headers.entrySet().stream().filter(e -> Objects.nonNull(e.getKey())).filter(e -> ((String)e.getKey()).equalsIgnoreCase(name.toLowerCase())).flatMap(e -> ((List)e.getValue()).stream()).collect(Collectors.toList());
    }

    public String getHeader(String name) {
        return this.headers.entrySet().stream().filter(e -> Objects.nonNull(e.getKey())).filter(e -> ((String)e.getKey()).equalsIgnoreCase(name.toLowerCase())).flatMap(e -> ((List)e.getValue()).stream()).findFirst().orElse(null);
    }

    public M setHeader(String name, String value) {
        return ((HttpMessage)this.removeHeader(name)).addHeader(name, value);
    }

    public M addHeader(String name, String value) {
        this.headers.computeIfAbsent(name, n -> new ArrayList()).add(value);
        return this.self();
    }

    public M removeHeader(String name) {
        this.headers.keySet().removeIf(header -> header.equalsIgnoreCase(name));
        return this.self();
    }

    public Charset getContentEncoding() {
        Charset charset = StandardCharsets.UTF_8;
        try {
            String contentType = this.getHeader(HttpHeader.ContentType.getName());
            if (contentType != null) {
                return Arrays.stream(contentType.split(";")).map(e -> e.trim().toLowerCase()).filter(e -> e.startsWith("charset=")).map(e -> e.substring(e.indexOf(61) + 1)).map(Charset::forName).findFirst().orElse(StandardCharsets.UTF_8);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return charset;
    }

    public M setContent(Supplier<InputStream> supplier) {
        this.content = Require.nonNull("Supplier", supplier);
        return this.self();
    }

    public Supplier<InputStream> getContent() {
        return this.content;
    }

    private M self() {
        return (M)this;
    }
}

