/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote.http;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.remote.http.HttpMessage;
import org.openqa.selenium.remote.http.HttpMethod;

public class HttpRequest
extends HttpMessage<HttpRequest> {
    private final HttpMethod method;
    private final String uri;
    private final Map<String, List<String>> queryParameters = new LinkedHashMap<String, List<String>>();

    public HttpRequest(HttpMethod method, String uri2) {
        this.method = method;
        this.uri = uri2;
    }

    public String getUri() {
        return this.uri;
    }

    public HttpMethod getMethod() {
        return this.method;
    }

    public String getQueryParameter(String name) {
        Iterable<String> allParams = this.getQueryParameters(name);
        if (allParams == null) {
            return null;
        }
        Iterator<String> iterator2 = allParams.iterator();
        return iterator2.hasNext() ? iterator2.next() : null;
    }

    public HttpRequest addQueryParameter(String name, String value) {
        this.queryParameters.computeIfAbsent(Require.nonNull("Name", name), n -> new ArrayList()).add(Require.nonNull("Value", value));
        return this;
    }

    public Iterable<String> getQueryParameterNames() {
        return this.queryParameters.keySet();
    }

    public Iterable<String> getQueryParameters(String name) {
        return this.queryParameters.get(name);
    }

    public String toString() {
        return "(" + this.getMethod() + ") " + this.getUri();
    }
}

