/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote.http.jdk;

import com.google.auto.service.AutoService;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.lang.invoke.LambdaMetafactory;
import java.net.Authenticator;
import java.net.PasswordAuthentication;
import java.net.ProtocolException;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.SocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.http.HttpClient;
import java.net.http.HttpResponse;
import java.net.http.HttpTimeoutException;
import java.net.http.WebSocket;
import java.nio.ByteBuffer;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLContext;
import org.openqa.selenium.Credentials;
import org.openqa.selenium.TimeoutException;
import org.openqa.selenium.UsernameAndPassword;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.remote.http.BinaryMessage;
import org.openqa.selenium.remote.http.ClientConfig;
import org.openqa.selenium.remote.http.CloseMessage;
import org.openqa.selenium.remote.http.ConnectionFailedException;
import org.openqa.selenium.remote.http.HttpClient;
import org.openqa.selenium.remote.http.HttpClientName;
import org.openqa.selenium.remote.http.HttpHandler;
import org.openqa.selenium.remote.http.HttpMethod;
import org.openqa.selenium.remote.http.HttpRequest;
import org.openqa.selenium.remote.http.HttpResponse;
import org.openqa.selenium.remote.http.Message;
import org.openqa.selenium.remote.http.TextMessage;
import org.openqa.selenium.remote.http.WebSocket;
import org.openqa.selenium.remote.http.jdk.JdkHttpMessages;

public class JdkHttpClient
implements HttpClient {
    public static final Logger LOG = Logger.getLogger(JdkHttpClient.class.getName());
    private final JdkHttpMessages messages;
    private final HttpHandler handler;
    private java.net.http.HttpClient client;
    private final List<WebSocket> websockets;
    private final ExecutorService executorService;
    private final Duration readTimeout;

    JdkHttpClient(ClientConfig config) {
        String version;
        SSLContext sslContext;
        Objects.requireNonNull(config, "Client config must be set");
        this.messages = new JdkHttpMessages(config);
        this.readTimeout = config.readTimeout();
        this.websockets = new ArrayList<WebSocket>();
        this.handler = config.filter().andFinally(this::execute0);
        this.executorService = Executors.newCachedThreadPool();
        HttpClient.Builder builder = java.net.http.HttpClient.newBuilder().connectTimeout(config.connectionTimeout()).followRedirects(HttpClient.Redirect.NEVER).executor(this.executorService);
        Credentials credentials = config.credentials();
        String info = config.baseUri().getUserInfo();
        if (info != null && !info.trim().isEmpty()) {
            String[] parts = info.split(":", 2);
            final String username = parts[0];
            final String password = parts.length > 1 ? parts[1] : null;
            Authenticator authenticator = new Authenticator(){

                @Override
                protected PasswordAuthentication getPasswordAuthentication() {
                    return new PasswordAuthentication(username, password.toCharArray());
                }
            };
            builder = builder.authenticator(authenticator);
        } else if (credentials != null) {
            if (!(credentials instanceof UsernameAndPassword)) {
                throw new IllegalArgumentException("Credentials must be a user name and password: " + credentials);
            }
            final UsernameAndPassword uap = (UsernameAndPassword)credentials;
            Authenticator authenticator = new Authenticator(){

                @Override
                protected PasswordAuthentication getPasswordAuthentication() {
                    return new PasswordAuthentication(uap.username(), uap.password().toCharArray());
                }
            };
            builder = builder.authenticator(authenticator);
        }
        final Proxy proxy = config.proxy();
        if (proxy != null) {
            ProxySelector proxySelector = new ProxySelector(){

                @Override
                public List<Proxy> select(URI uri2) {
                    if (proxy == null) {
                        return List.of();
                    }
                    if (uri2.getScheme().toLowerCase().startsWith("http")) {
                        return List.of(proxy);
                    }
                    return List.of();
                }

                @Override
                public void connectFailed(URI uri2, SocketAddress sa, IOException ioe) {
                }
            };
            builder = builder.proxy(proxySelector);
        }
        if ((sslContext = config.sslContext()) != null) {
            builder.sslContext(sslContext);
        }
        if ((version = config.version()) != null) {
            builder.version(HttpClient.Version.valueOf(version));
        }
        this.client = builder.build();
    }

    @Override
    public WebSocket openSocket(HttpRequest request, final WebSocket.Listener listener) {
        java.net.http.WebSocket underlyingSocket;
        URI uri2;
        try {
            uri2 = this.getWebSocketUri(request);
        }
        catch (URISyntaxException e) {
            throw new ConnectionFailedException("JdkWebSocket initial request execution error", e);
        }
        CompletableFuture<java.net.http.WebSocket> webSocketCompletableFuture = this.client.newWebSocketBuilder().buildAsync(uri2, new WebSocket.Listener(){
            final StringBuilder builder = new StringBuilder();
            final ByteArrayOutputStream buffer = new ByteArrayOutputStream();

            @Override
            public CompletionStage<?> onText(java.net.http.WebSocket webSocket, CharSequence data, boolean last) {
                LOG.fine("Text message received. Appending data");
                this.builder.append(data);
                if (last) {
                    LOG.log(Level.FINE, "Final part of text message received. Calling listener with {0}", this.builder);
                    listener.onText(this.builder.toString());
                    this.builder.setLength(0);
                }
                webSocket.request(1L);
                return null;
            }

            @Override
            public CompletionStage<?> onBinary(java.net.http.WebSocket webSocket, ByteBuffer data, boolean last) {
                LOG.fine("Binary data received. Appending data");
                byte[] ary = new byte[8192];
                while (data.hasRemaining()) {
                    int n = Math.min(ary.length, data.remaining());
                    data.get(ary, 0, n);
                    this.buffer.write(ary, 0, n);
                }
                if (last) {
                    LOG.log(Level.FINE, "Final part of binary data received. Calling listener with {0} bytes of data", this.buffer.size());
                    listener.onBinary(this.buffer.toByteArray());
                    this.buffer.reset();
                }
                webSocket.request(1L);
                return null;
            }

            @Override
            public CompletionStage<?> onClose(java.net.http.WebSocket webSocket, int statusCode, String reason) {
                LOG.fine("Closing websocket");
                listener.onClose(statusCode, reason);
                return null;
            }

            @Override
            public void onError(java.net.http.WebSocket webSocket, Throwable error) {
                LOG.log(Level.FINE, "An error has occurred: " + error.getMessage(), error);
                listener.onError(error);
            }
        });
        try {
            underlyingSocket = webSocketCompletableFuture.get(this.readTimeout.toMillis(), TimeUnit.MILLISECONDS);
        }
        catch (CancellationException e) {
            throw new ConnectionFailedException("JdkWebSocket initial request canceled", e);
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            throw new ConnectionFailedException("JdkWebSocket initial request execution error", cause != null ? cause : e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ConnectionFailedException("JdkWebSocket initial request interrupted", e);
        }
        catch (java.util.concurrent.TimeoutException e) {
            webSocketCompletableFuture.cancel(true);
            throw new ConnectionFailedException("JdkWebSocket initial request timeout", e);
        }
        WebSocket websocket = new WebSocket(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Loose catch block
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public WebSocket send(Message message) {
                Supplier<CompletableFuture> makeCall;
                if (message instanceof BinaryMessage) {
                    BinaryMessage binaryMessage = (BinaryMessage)message;
                    LOG.fine("Sending binary message");
                    makeCall = () -> underlyingSocket.sendBinary(ByteBuffer.wrap(binaryMessage.data()), true);
                } else if (message instanceof TextMessage) {
                    TextMessage textMessage = (TextMessage)message;
                    LOG.log(Level.FINE, "Sending text message: {0}", textMessage.text());
                    makeCall = () -> underlyingSocket.sendText(textMessage.text(), true);
                } else {
                    if (!(message instanceof CloseMessage)) throw new IllegalArgumentException("Unsupported message type: " + message);
                    CloseMessage closeMessage = (CloseMessage)message;
                    if (underlyingSocket.isOutputClosed()) {
                        LOG.fine("Output is closed, not sending close message");
                        return this;
                    }
                    int statusCode = closeMessage.code() == -1 ? 1000 : closeMessage.code();
                    LOG.log(Level.FINE, "Sending close message, statusCode {0}, reason: {1}", new Object[]{statusCode, closeMessage.reason()});
                    makeCall = () -> underlyingSocket.sendClose(statusCode, closeMessage.reason());
                }
                java.net.http.WebSocket webSocket = underlyingSocket;
                synchronized (webSocket) {
                    long start2 = System.currentTimeMillis();
                    CompletableFuture future = makeCall.get();
                    try {
                        future.get(JdkHttpClient.this.readTimeout.toMillis(), TimeUnit.MILLISECONDS);
                    }
                    catch (CancellationException e) {
                        try {
                            throw new WebDriverException(e.getMessage(), e);
                            catch (ExecutionException e2) {
                                Throwable cause = e2.getCause();
                                if (cause != null) throw new WebDriverException(cause);
                                throw new WebDriverException(e2);
                            }
                            catch (InterruptedException e3) {
                                Thread.currentThread().interrupt();
                                throw new WebDriverException(e3.getMessage());
                            }
                            catch (java.util.concurrent.TimeoutException e4) {
                                throw new TimeoutException(e4);
                            }
                        }
                        catch (Throwable throwable) {
                            LOG.log(Level.FINE, "Websocket response to {0} read in {1}ms", new Object[]{message, System.currentTimeMillis() - start2});
                            throw throwable;
                        }
                    }
                    LOG.log(Level.FINE, "Websocket response to {0} read in {1}ms", new Object[]{message, System.currentTimeMillis() - start2});
                    return this;
                }
            }

            @Override
            public void close() {
                LOG.fine("Closing websocket");
                this.send(new CloseMessage(1000, "WebDriver closing socket"));
            }
        };
        this.websockets.add(websocket);
        return websocket;
    }

    private URI getWebSocketUri(HttpRequest request) throws URISyntaxException {
        URI uri2 = this.messages.getRawUri(request);
        if ("http".equalsIgnoreCase(uri2.getScheme())) {
            uri2 = new URI("ws", uri2.getUserInfo(), uri2.getHost(), uri2.getPort(), uri2.getPath(), uri2.getQuery(), uri2.getFragment());
        } else if ("https".equalsIgnoreCase(uri2.getScheme())) {
            uri2 = new URI("wss", uri2.getUserInfo(), uri2.getHost(), uri2.getPort(), uri2.getPath(), uri2.getQuery(), uri2.getFragment());
        }
        return uri2;
    }

    @Override
    public HttpResponse execute(HttpRequest req) throws UncheckedIOException {
        return this.handler.execute(req);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private HttpResponse execute0(HttpRequest req) throws UncheckedIOException {
        Objects.requireNonNull(req, "Request");
        JdkHttpClient.LOG.log(Level.FINE, "Executing request: {0}", req);
        start = System.currentTimeMillis();
        byteHandler = HttpResponse.BodyHandlers.ofByteArray();
        try {
            method = req.getMethod();
            rawUri = this.messages.getRawUri(req);
            i = 0;
lbl10:
            // 2 sources

            while (true) {
                if (i >= 100) throw new ProtocolException("Too many redirects: 101");
                request = this.messages.createRequest(req, method, rawUri);
                future = this.client.sendAsync(request, byteHandler);
                try {
                    response = future.get(this.readTimeout.toMillis(), TimeUnit.MILLISECONDS);
                }
                catch (CancellationException e) {
                    throw new WebDriverException(e.getMessage(), e);
                }
                catch (ExecutionException e) {
                    cause = e.getCause();
                    if (cause instanceof HttpTimeoutException) {
                        throw new TimeoutException(cause);
                    }
                    if (cause instanceof IOException) {
                        throw (IOException)cause;
                    }
                    if (cause instanceof RuntimeException) {
                        throw (RuntimeException)cause;
                    }
                    if (cause != null) {
                        v0 = cause;
                        throw new WebDriverException(v0);
                    }
                    v0 = e;
                    throw new WebDriverException(v0);
                }
                catch (java.util.concurrent.TimeoutException e) {
                    future.cancel(true);
                    throw new TimeoutException(e);
                }
                switch (response.statusCode()) {
                    case 303: {
                        method = HttpMethod.GET;
                    }
                    case 301: 
                    case 302: 
                    case 307: 
                    case 308: {
                        location = rawUri.resolve(response.headers().firstValue("location").orElseThrow((Supplier<ProtocolException>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$execute0$0(java.net.http.HttpResponse ), ()Ljava/net/ProtocolException;)(response)));
                        if ("https".equalsIgnoreCase(rawUri.getScheme()) && !"https".equalsIgnoreCase(location.getScheme())) {
                            throw new SecurityException("Downgrade from secure to insecure connection.");
                        }
                        if ("wss".equalsIgnoreCase(rawUri.getScheme()) && !"wss".equalsIgnoreCase(location.getScheme())) {
                            throw new SecurityException("Downgrade from secure to insecure connection.");
                        }
                        rawUri = location;
                        ** break;
                    }
                }
                var12_17 = this.messages.createResponse(response);
                break;
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
        catch (Throwable var13_18) {
            JdkHttpClient.LOG.log(Level.FINE, "Ending request {0} in {1}ms", new Object[]{req, System.currentTimeMillis() - start});
            throw var13_18;
        }
        JdkHttpClient.LOG.log(Level.FINE, "Ending request {0} in {1}ms", new Object[]{req, System.currentTimeMillis() - start});
        return var12_17;
lbl-1000:
        // 1 sources

        {
            ++i;
            ** continue;
        }
    }

    @Override
    public void close() {
        if (this.client == null) {
            return;
        }
        this.client = null;
        for (WebSocket websocket : this.websockets) {
            try {
                websocket.close();
            }
            catch (Exception e) {
                LOG.log(Level.WARNING, "failed to close the websocket: " + websocket, e);
            }
        }
        this.executorService.shutdownNow();
    }

    private static /* synthetic */ ProtocolException lambda$execute0$0(java.net.http.HttpResponse response) {
        return new ProtocolException("HTTP " + response.statusCode() + " without 'location' header set");
    }

    @HttpClientName(value="jdk-http-client")
    @AutoService(value={HttpClient.Factory.class})
    public static class Factory
    implements HttpClient.Factory {
        @Override
        public HttpClient createClient(ClientConfig config) {
            Objects.requireNonNull(config, "Client config must be set");
            return new JdkHttpClient(config);
        }
    }
}

