/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote.service;

import java.io.Closeable;
import java.io.IOException;
import java.net.ConnectException;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.concurrent.ExecutorServices;
import org.openqa.selenium.remote.Command;
import org.openqa.selenium.remote.CommandInfo;
import org.openqa.selenium.remote.HttpCommandExecutor;
import org.openqa.selenium.remote.Response;
import org.openqa.selenium.remote.http.ClientConfig;
import org.openqa.selenium.remote.service.DriverService;

public class DriverCommandExecutor
extends HttpCommandExecutor
implements Closeable {
    private static final String NAME = "Driver Command Executor";
    private final DriverService service;
    private final ExecutorService executorService = Executors.newFixedThreadPool(2, r -> {
        Thread thread2 = new Thread(r);
        thread2.setName(NAME);
        thread2.setDaemon(true);
        return thread2;
    });

    public DriverCommandExecutor(DriverService service) {
        this(service, ClientConfig.defaultConfig());
    }

    public DriverCommandExecutor(DriverService service, ClientConfig clientConfig) {
        this(service, Collections.emptyMap(), clientConfig);
    }

    public DriverCommandExecutor(DriverService service, Map<String, CommandInfo> additionalCommands, ClientConfig clientConfig) {
        super(additionalCommands, service.getUrl(), DriverCommandExecutor.computeClientConfigWithBaseURI(clientConfig, service));
        this.service = service;
    }

    private static ClientConfig computeClientConfigWithBaseURI(ClientConfig clientConfig, DriverService service) {
        try {
            return clientConfig.baseUri(service.getUrl().toURI());
        }
        catch (URISyntaxException e) {
            return clientConfig;
        }
    }

    @Override
    public Response execute(Command command) throws IOException {
        boolean newlyStarted = false;
        if ("newSession".equals(command.getName())) {
            boolean wasRunningBefore = this.service.isRunning();
            this.service.start();
            boolean bl = newlyStarted = !wasRunningBefore && this.service.isRunning();
        }
        if ("quit".equals(command.getName())) {
            CompletableFuture<Response> commandComplete = CompletableFuture.supplyAsync(() -> {
                try {
                    return this.invokeExecute(command);
                }
                catch (Throwable t2) {
                    Throwable rootCause = DriverCommandExecutor.rootCause(t2);
                    if (rootCause instanceof IllegalStateException && "Closed".equals(rootCause.getMessage())) {
                        return null;
                    }
                    if (rootCause instanceof ConnectException && "Connection refused".equals(rootCause.getMessage())) {
                        throw new WebDriverException("The driver server has unexpectedly died!", t2);
                    }
                    if (t2 instanceof Error) {
                        throw (Error)t2;
                    }
                    if (t2 instanceof RuntimeException) {
                        throw (RuntimeException)t2;
                    }
                    throw new WebDriverException(t2);
                }
            }, this.executorService);
            CompletableFuture<Response> processFinished = CompletableFuture.supplyAsync(() -> {
                try {
                    this.service.process.waitFor(this.service.getTimeout());
                }
                catch (InterruptedException ex) {
                    Thread.currentThread().interrupt();
                }
                return null;
            }, this.executorService);
            try {
                Response response = (Response)CompletableFuture.anyOf(commandComplete, processFinished).get(this.service.getTimeout().toMillis() * 2L, TimeUnit.MILLISECONDS);
                this.service.stop();
                Response response2 = response;
                return response2;
            }
            catch (ExecutionException | TimeoutException e) {
                throw new WebDriverException("Timed out waiting for driver server to stop.", e);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new WebDriverException("Timed out waiting for driver server to stop.", e);
            }
            finally {
                this.close();
            }
        }
        try {
            return this.invokeExecute(command);
        }
        catch (Throwable t2) {
            Throwable rootCause = DriverCommandExecutor.rootCause(t2);
            if (rootCause instanceof ConnectException && "Connection refused".equals(rootCause.getMessage()) && !this.service.isRunning()) {
                throw new WebDriverException("The driver server has unexpectedly died!", t2);
            }
            if (newlyStarted && this.service.isRunning()) {
                try {
                    this.service.stop();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (t2 instanceof Error) {
                throw (Error)t2;
            }
            if (t2 instanceof RuntimeException) {
                throw (RuntimeException)t2;
            }
            throw new WebDriverException(t2);
        }
    }

    private static Throwable rootCause(Throwable throwable) {
        Throwable cause = throwable;
        for (int i = 0; i < 99; ++i) {
            Throwable peek = cause.getCause();
            if (peek == null) {
                return cause;
            }
            cause = peek;
        }
        throw new IllegalArgumentException("to many causes or recursive causes");
    }

    Response invokeExecute(Command command) throws IOException {
        return super.execute(command);
    }

    @Override
    public void close() {
        ExecutorServices.shutdownGracefully(NAME, this.executorService);
    }
}

