/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote.tracing;

import java.net.URL;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.remote.http.ClientConfig;
import org.openqa.selenium.remote.http.HttpClient;
import org.openqa.selenium.remote.http.HttpRequest;
import org.openqa.selenium.remote.http.HttpResponse;
import org.openqa.selenium.remote.http.WebSocket;
import org.openqa.selenium.remote.tracing.HttpTracing;
import org.openqa.selenium.remote.tracing.Span;
import org.openqa.selenium.remote.tracing.Tags;
import org.openqa.selenium.remote.tracing.Tracer;

public class TracedHttpClient
implements HttpClient {
    private final Tracer tracer;
    private final HttpClient delegate;

    private TracedHttpClient(Tracer tracer, HttpClient delegate) {
        this.tracer = Require.nonNull("Tracer", tracer);
        this.delegate = Require.nonNull("Actual handler", delegate);
    }

    @Override
    public WebSocket openSocket(HttpRequest request, WebSocket.Listener listener) {
        return this.delegate.openSocket(request, listener);
    }

    @Override
    public HttpResponse execute(HttpRequest req) {
        try (Span span = HttpTracing.newSpanAsChildOf(this.tracer, req, "httpclient.execute");){
            Tags.KIND.accept(span, Span.Kind.CLIENT);
            Tags.HTTP_REQUEST.accept(span, req);
            this.tracer.getPropagator().inject(span, req, (r, key, value) -> r.setHeader(key, value));
            HttpResponse response = this.delegate.execute(req);
            Tags.HTTP_RESPONSE.accept(span, response);
            HttpResponse httpResponse = response;
            return httpResponse;
        }
    }

    @Override
    public void close() {
        this.delegate.close();
    }

    public static class Factory
    implements HttpClient.Factory {
        private final Tracer tracer;
        private final HttpClient.Factory delegate;

        public Factory(Tracer tracer, HttpClient.Factory delegate) {
            this.tracer = Require.nonNull("Tracer", tracer);
            this.delegate = Require.nonNull("Actual handler", delegate);
        }

        @Override
        public HttpClient createClient(ClientConfig config) {
            HttpClient client = this.delegate.createClient(config);
            return new TracedHttpClient(this.tracer, client);
        }

        @Override
        public HttpClient createClient(URL url2) {
            HttpClient client = this.delegate.createClient(url2);
            return new TracedHttpClient(this.tracer, client);
        }
    }
}

