/*
 * Decompiled with CFR 0.152.
 */
package zmq;

import java.io.IOException;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.nio.channels.SelectableChannel;
import java.nio.channels.Selector;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.zeromq.ZMQException;
import zmq.Command;
import zmq.IMailbox;
import zmq.Mailbox;
import zmq.Msg;
import zmq.Options;
import zmq.Reaper;
import zmq.SocketBase;
import zmq.ZError;
import zmq.ZObject;
import zmq.io.IOThread;
import zmq.pipe.Pipe;
import zmq.socket.Sockets;
import zmq.util.Errno;
import zmq.util.MultiMap;
import zmq.util.function.BiFunction;

public class Ctx {
    private static final int WAIT_FOREVER = -1;
    private boolean active = true;
    private final List<SocketBase> sockets;
    private final Deque<Integer> emptySlots;
    private final AtomicBoolean starting = new AtomicBoolean(true);
    private volatile boolean terminating = false;
    private final Lock slotSync;
    private final List<Selector> selectors = new ArrayList<Selector>();
    private Reaper reaper = null;
    private final List<IOThread> ioThreads;
    private int slotCount = 0;
    private IMailbox[] slots = null;
    private final Mailbox termMailbox;
    private final Map<String, Endpoint> endpoints;
    private final Lock endpointsSync;
    private static final AtomicInteger maxSocketId = new AtomicInteger(0);
    private int maxSockets = 1024;
    private int ioThreadCount = 1;
    private BiFunction<Runnable, String, Thread> threadFactory;
    private boolean blocky = true;
    private final Lock optSync;
    private final Lock selectorSync = new ReentrantLock();
    static final int TERM_TID = 0;
    private static final int REAPER_TID = 1;
    private final MultiMap<String, PendingConnection> pendingConnections = new MultiMap();
    private boolean ipv6 = false;
    private final Errno errno = new Errno();
    private Thread.UncaughtExceptionHandler exhandler = Thread.getDefaultUncaughtExceptionHandler();
    private Thread.UncaughtExceptionHandler exnotification = (t2, e) -> e.printStackTrace();
    private ChannelForwardHolder forwardHolder = null;

    public Ctx() {
        this.threadFactory = this::createThread;
        this.slotSync = new ReentrantLock();
        this.endpointsSync = new ReentrantLock();
        this.optSync = new ReentrantLock();
        this.termMailbox = new Mailbox(this, "terminater", -1);
        this.emptySlots = new ArrayDeque<Integer>();
        this.ioThreads = new ArrayList<IOThread>();
        this.sockets = new ArrayList<SocketBase>();
        this.endpoints = new HashMap<String, Endpoint>();
    }

    private void destroy() throws IOException {
        assert (this.sockets.isEmpty());
        for (IOThread it : this.ioThreads) {
            it.stop();
        }
        for (IOThread it : this.ioThreads) {
            it.close();
        }
        this.ioThreads.clear();
        this.selectorSync.lock();
        try {
            for (Selector selector : this.selectors) {
                if (selector == null) continue;
                selector.close();
            }
            this.selectors.clear();
        }
        finally {
            this.selectorSync.unlock();
        }
        if (this.reaper != null) {
            this.reaper.close();
        }
        this.termMailbox.close();
        this.active = false;
    }

    public boolean isActive() {
        return this.active;
    }

    @Deprecated
    public boolean checkTag() {
        return this.active;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void terminate() {
        this.slotSync.lock();
        try {
            for (Map.Entry<PendingConnection, String> pending : this.pendingConnections.entries()) {
                SocketBase s2 = this.createSocket(0);
                assert (s2 != null);
                s2.bind(pending.getValue());
                s2.close();
            }
            if (!this.starting.get()) {
                boolean restarted = this.terminating;
                this.terminating = true;
                if (!restarted) {
                    for (SocketBase socket : this.sockets) {
                        socket.stop();
                    }
                    if (this.sockets.isEmpty()) {
                        this.reaper.stop();
                    }
                }
            }
        }
        finally {
            this.slotSync.unlock();
        }
        if (!this.starting.get()) {
            Command cmd = this.termMailbox.recv(-1L);
            if (cmd == null) {
                throw new ZMQException(this.errno.get());
            }
            assert (cmd.type == Command.Type.DONE) : cmd;
            this.slotSync.lock();
            try {
                assert (this.sockets.isEmpty());
            }
            finally {
                this.slotSync.unlock();
            }
        }
        try {
            this.destroy();
        }
        catch (IOException e) {
            throw new ZError.IOException(e);
        }
    }

    final void shutdown() {
        this.slotSync.lock();
        try {
            if (!this.starting.get() && !this.terminating) {
                this.terminating = true;
                for (SocketBase socket : this.sockets) {
                    socket.stop();
                }
                if (this.sockets.isEmpty()) {
                    this.reaper.stop();
                }
            }
        }
        finally {
            this.slotSync.unlock();
        }
    }

    private void chechStarted() {
        if (!this.starting.get()) {
            throw new IllegalStateException("Already started");
        }
    }

    public void setUncaughtExceptionHandler(Thread.UncaughtExceptionHandler handler) {
        this.chechStarted();
        this.exhandler = handler;
    }

    public Thread.UncaughtExceptionHandler getUncaughtExceptionHandler() {
        return this.exhandler;
    }

    public void setNotificationExceptionHandler(Thread.UncaughtExceptionHandler handler) {
        this.chechStarted();
        this.exnotification = handler;
    }

    public Thread.UncaughtExceptionHandler getNotificationExceptionHandler() {
        return this.exnotification;
    }

    public void setThreadFactory(BiFunction<Runnable, String, Thread> threadFactory) {
        this.chechStarted();
        this.threadFactory = threadFactory;
    }

    public BiFunction<Runnable, String, Thread> getThreadFactory() {
        return this.threadFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean set(int option, int optval) {
        if (option == 2 && optval >= 1) {
            this.chechStarted();
            this.optSync.lock();
            try {
                this.maxSockets = optval;
            }
            finally {
                this.optSync.unlock();
            }
        } else if (option == 1 && optval >= 0) {
            this.chechStarted();
            this.optSync.lock();
            try {
                this.ioThreadCount = optval;
            }
            finally {
                this.optSync.unlock();
            }
        } else if (option == 70 && optval >= 0) {
            this.optSync.lock();
            try {
                this.blocky = optval != 0;
            }
            finally {
                this.optSync.unlock();
            }
        } else if (option == 42 && optval >= 0) {
            this.optSync.lock();
            try {
                this.ipv6 = optval != 0;
            }
            finally {
                this.optSync.unlock();
            }
        } else {
            return false;
        }
        return true;
    }

    public int get(int option) {
        int rc;
        if (option == 2) {
            rc = this.maxSockets;
        } else if (option == 1) {
            rc = this.ioThreadCount;
        } else if (option == 70) {
            rc = this.blocky ? 1 : 0;
        } else if (option == 42) {
            rc = this.ipv6 ? 1 : 0;
        } else {
            throw new IllegalArgumentException("option = " + option);
        }
        return rc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SocketBase createSocket(int type) {
        SocketBase s2;
        this.slotSync.lock();
        try {
            int sid;
            if (this.starting.compareAndSet(true, false)) {
                this.initSlots();
            }
            if (this.terminating) {
                throw new ZError.CtxTerminatedException();
            }
            if (this.emptySlots.isEmpty()) {
                throw new ZMQException(156384819);
            }
            int slot = this.emptySlots.pollLast();
            s2 = Sockets.create(type, this, slot, sid = maxSocketId.incrementAndGet());
            if (s2 == null) {
                this.emptySlots.addLast(slot);
                SocketBase socketBase = null;
                return socketBase;
            }
            this.sockets.add(s2);
            this.slots[slot] = s2.getMailbox();
        }
        finally {
            this.slotSync.unlock();
        }
        return s2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initSlots() {
        this.slotSync.lock();
        try {
            int i;
            int ios;
            this.optSync.lock();
            try {
                ios = this.ioThreadCount;
                this.slotCount = this.maxSockets + this.ioThreadCount + 2;
            }
            finally {
                this.optSync.unlock();
            }
            this.slots = new IMailbox[this.slotCount];
            this.slots[0] = this.termMailbox;
            this.reaper = new Reaper(this, 1);
            this.slots[1] = this.reaper.getMailbox();
            this.reaper.start();
            for (i = 2; i != ios + 2; ++i) {
                IOThread ioThread = new IOThread(this, i);
                this.ioThreads.add(ioThread);
                this.slots[i] = ioThread.getMailbox();
                ioThread.start();
            }
            for (i = this.slotCount - 1; i >= ios + 2; --i) {
                this.emptySlots.add(i);
                this.slots[i] = null;
            }
        }
        finally {
            this.slotSync.unlock();
        }
    }

    void destroySocket(SocketBase socket) {
        this.slotSync.lock();
        try {
            int tid = socket.getTid();
            this.emptySlots.add(tid);
            this.slots[tid] = null;
            this.sockets.remove(socket);
            if (this.terminating && this.sockets.isEmpty()) {
                this.reaper.stop();
            }
        }
        finally {
            this.slotSync.unlock();
        }
    }

    public Selector createSelector() {
        this.selectorSync.lock();
        try {
            Selector selector = Selector.open();
            assert (selector != null);
            this.selectors.add(selector);
            Selector selector2 = selector;
            return selector2;
        }
        catch (IOException e) {
            throw new ZError.IOException(e);
        }
        finally {
            this.selectorSync.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean closeSelector(Selector selector) {
        this.selectorSync.lock();
        try {
            boolean rc = this.selectors.remove(selector);
            if (rc) {
                try {
                    selector.close();
                }
                catch (IOException e) {
                    throw new ZError.IOException(e);
                }
            }
            boolean bl = rc;
            return bl;
        }
        finally {
            this.selectorSync.unlock();
        }
    }

    ZObject getReaper() {
        return this.reaper;
    }

    void sendCommand(int tid, Command command) {
        this.slots[tid].send(command);
    }

    IOThread chooseIoThread(long affinity) {
        if (this.ioThreads.isEmpty()) {
            return null;
        }
        int minLoad = -1;
        IOThread selectedIoThread = null;
        for (int i = 0; i != this.ioThreads.size(); ++i) {
            if (affinity != 0L && (affinity & 1L << i) <= 0L) continue;
            int load = this.ioThreads.get(i).getLoad();
            if (selectedIoThread != null && load >= minLoad) continue;
            minLoad = load;
            selectedIoThread = this.ioThreads.get(i);
        }
        return selectedIoThread;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean registerEndpoint(String addr, Endpoint endpoint) {
        Endpoint inserted;
        this.endpointsSync.lock();
        try {
            inserted = this.endpoints.put(addr, endpoint);
        }
        finally {
            this.endpointsSync.unlock();
        }
        return inserted == null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean unregisterEndpoint(String addr, SocketBase socket) {
        this.endpointsSync.lock();
        try {
            Endpoint endpoint = this.endpoints.get(addr);
            if (endpoint != null && socket == endpoint.socket) {
                this.endpoints.remove(addr);
                boolean bl = true;
                return bl;
            }
        }
        finally {
            this.endpointsSync.unlock();
        }
        return false;
    }

    void unregisterEndpoints(SocketBase socket) {
        this.endpointsSync.lock();
        try {
            this.endpoints.entrySet().removeIf(e -> ((Endpoint)e.getValue()).socket == socket);
        }
        finally {
            this.endpointsSync.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Endpoint findEndpoint(String addr) {
        Endpoint endpoint;
        this.endpointsSync.lock();
        try {
            endpoint = this.endpoints.get(addr);
            if (endpoint == null) {
                Endpoint endpoint2 = new Endpoint(null, new Options());
                return endpoint2;
            }
            endpoint.socket.incSeqnum();
        }
        finally {
            this.endpointsSync.unlock();
        }
        return endpoint;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void pendConnection(String addr, Endpoint endpoint, Pipe[] pipes) {
        PendingConnection pendingConnection = new PendingConnection(endpoint, pipes[0], pipes[1]);
        this.endpointsSync.lock();
        try {
            Endpoint existing = this.endpoints.get(addr);
            if (existing == null) {
                endpoint.socket.incSeqnum();
                this.pendingConnections.insert(addr, pendingConnection);
            } else {
                this.connectInprocSockets(existing.socket, existing.options, pendingConnection, Side.CONNECT);
            }
        }
        finally {
            this.endpointsSync.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void connectPending(String addr, SocketBase bindSocket) {
        this.endpointsSync.lock();
        try {
            Collection<PendingConnection> pendings = this.pendingConnections.remove(addr);
            if (pendings != null) {
                for (PendingConnection pending : pendings) {
                    this.connectInprocSockets(bindSocket, this.endpoints.get((Object)addr).options, pending, Side.BIND);
                }
            }
        }
        finally {
            this.endpointsSync.unlock();
        }
    }

    private void connectInprocSockets(SocketBase bindSocket, Options bindOptions, PendingConnection pendingConnection, Side side) {
        bindSocket.incSeqnum();
        pendingConnection.bindPipe.setTid(bindSocket.getTid());
        if (!bindOptions.recvIdentity) {
            Msg msg = pendingConnection.bindPipe.read();
            assert (msg != null);
        }
        int sndhwm = 0;
        if (((PendingConnection)pendingConnection).endpoint.options.sendHwm != 0 && bindOptions.recvHwm != 0) {
            sndhwm = ((PendingConnection)pendingConnection).endpoint.options.sendHwm + bindOptions.recvHwm;
        }
        int rcvhwm = 0;
        if (((PendingConnection)pendingConnection).endpoint.options.recvHwm != 0 && bindOptions.sendHwm != 0) {
            rcvhwm = ((PendingConnection)pendingConnection).endpoint.options.recvHwm + bindOptions.sendHwm;
        }
        boolean conflate = ((PendingConnection)pendingConnection).endpoint.options.conflate && (((PendingConnection)pendingConnection).endpoint.options.type == 5 || ((PendingConnection)pendingConnection).endpoint.options.type == 7 || ((PendingConnection)pendingConnection).endpoint.options.type == 8 || ((PendingConnection)pendingConnection).endpoint.options.type == 1 || ((PendingConnection)pendingConnection).endpoint.options.type == 2);
        int[] hwms = new int[]{conflate ? -1 : sndhwm, conflate ? -1 : rcvhwm};
        pendingConnection.connectPipe.setHwms(hwms[1], hwms[0]);
        pendingConnection.bindPipe.setHwms(hwms[0], hwms[1]);
        if (bindOptions.canReceiveDisconnectMsg && bindOptions.disconnectMsg != null) {
            pendingConnection.connectPipe.setDisconnectMsg(bindOptions.disconnectMsg);
        }
        if (side == Side.BIND) {
            Command cmd = new Command(null, Command.Type.BIND, pendingConnection.bindPipe);
            bindSocket.processCommand(cmd);
            bindSocket.sendInprocConnected(((PendingConnection)pendingConnection).endpoint.socket);
        } else {
            pendingConnection.connectPipe.sendBind(bindSocket, pendingConnection.bindPipe, false);
        }
        if (((PendingConnection)pendingConnection).endpoint.options.recvIdentity && ((PendingConnection)pendingConnection).endpoint.socket.isActive()) {
            Msg id = new Msg(bindOptions.identitySize);
            id.put(bindOptions.identity, 0, (int)bindOptions.identitySize);
            id.setFlags(64);
            boolean written = pendingConnection.bindPipe.write(id);
            assert (written);
            pendingConnection.bindPipe.flush();
        }
        if (bindOptions.canSendHelloMsg && bindOptions.helloMsg != null) {
            boolean written = pendingConnection.bindPipe.write(bindOptions.helloMsg);
            assert (written);
            pendingConnection.bindPipe.flush();
        }
    }

    public Errno errno() {
        return this.errno;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int forwardChannel(SelectableChannel channel) {
        Class<ChannelForwardHolder> clazz = ChannelForwardHolder.class;
        synchronized (ChannelForwardHolder.class) {
            if (this.forwardHolder == null) {
                this.forwardHolder = new ChannelForwardHolder();
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            WeakReference<SelectableChannel> ref = new WeakReference<SelectableChannel>(channel, this.forwardHolder.queue);
            int handle2 = this.forwardHolder.handleSource.getAndIncrement();
            this.forwardHolder.map.put(handle2, ref);
            this.forwardHolder.reversemap.put(ref, handle2);
            this.cleanForwarded();
            return handle2;
        }
    }

    SelectableChannel getForwardedChannel(Integer handle2) {
        this.cleanForwarded();
        WeakReference ref = (WeakReference)this.forwardHolder.map.remove(handle2);
        if (ref != null) {
            return (SelectableChannel)ref.get();
        }
        return null;
    }

    private void cleanForwarded() {
        Reference ref;
        while ((ref = this.forwardHolder.queue.poll()) != null) {
            Integer handle2 = (Integer)this.forwardHolder.reversemap.remove(ref);
            this.forwardHolder.map.remove(handle2);
        }
    }

    private Thread createThread(Runnable target, String name) {
        Thread t2 = new Thread(target, name);
        t2.setDaemon(true);
        t2.setUncaughtExceptionHandler(this.getUncaughtExceptionHandler());
        return t2;
    }

    private static class ChannelForwardHolder {
        private final AtomicInteger handleSource = new AtomicInteger(0);
        private final Map<Integer, WeakReference<SelectableChannel>> map = new ConcurrentHashMap<Integer, WeakReference<SelectableChannel>>();
        private final Map<WeakReference<SelectableChannel>, Integer> reversemap = new ConcurrentHashMap<WeakReference<SelectableChannel>, Integer>();
        private final ReferenceQueue<SelectableChannel> queue = new ReferenceQueue();

        private ChannelForwardHolder() {
        }
    }

    public static class Endpoint {
        public final SocketBase socket;
        public final Options options;

        public Endpoint(SocketBase socket, Options options) {
            this.socket = socket;
            this.options = options;
        }
    }

    private static class PendingConnection {
        private final Endpoint endpoint;
        private final Pipe connectPipe;
        private final Pipe bindPipe;

        public PendingConnection(Endpoint endpoint, Pipe connectPipe, Pipe bindPipe) {
            this.endpoint = endpoint;
            this.connectPipe = connectPipe;
            this.bindPipe = bindPipe;
        }
    }

    private static enum Side {
        CONNECT,
        BIND;

    }
}

