/*
 * Decompiled with CFR 0.152.
 */
package zmq.util;

import java.util.Arrays;
import zmq.Msg;

public class Blob {
    private final byte[] buf;

    private Blob(byte[] data) {
        this.buf = data;
    }

    private static Blob createBlob(byte[] data, boolean copy) {
        if (copy) {
            byte[] b = new byte[data.length];
            System.arraycopy(data, 0, b, 0, data.length);
            return new Blob(b);
        }
        return new Blob(data);
    }

    public static Blob createBlob(Msg msg) {
        return Blob.createBlob(msg.data(), true);
    }

    public static Blob createBlob(byte[] data) {
        return Blob.createBlob(data, false);
    }

    public int size() {
        return this.buf.length;
    }

    public byte[] data() {
        return this.buf;
    }

    public boolean equals(Object t2) {
        if (t2 instanceof Blob) {
            return Arrays.equals(this.buf, ((Blob)t2).buf);
        }
        return false;
    }

    public int hashCode() {
        return Arrays.hashCode(this.buf);
    }
}

