/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.custom.improvement.parser;

import com.kms.katalon.core.annotation.Keyword;
import com.kms.katalon.core.ast.GroovyParser;
import com.kms.katalon.core.model.RunningMode;
import com.kms.katalon.core.util.ApplicationRunningMode;
import com.kms.katalon.custom.improvement.cache.ParseKeywordCacheContent;
import com.kms.katalon.custom.improvement.cache.ParseKeywordCacheFile;
import com.kms.katalon.custom.improvement.model.CustomKeywordClass;
import com.kms.katalon.custom.improvement.model.CustomKeywordFile;
import com.kms.katalon.custom.improvement.model.CustomKeywordMethod;
import com.kms.katalon.custom.improvement.model.CustomKeywordParameter;
import com.kms.katalon.custom.improvement.model.ParameterType;
import com.kms.katalon.custom.improvement.parser.ClassNodeToParamTypeConverter;
import com.kms.katalon.custom.improvement.parser.ParseKeywordException;
import com.kms.katalon.custom.improvement.parser.ReadCacheFileException;
import com.kms.katalon.entity.project.ProjectEntity;
import com.kms.katalon.groovy.util.GroovyUtil;
import com.kms.katalon.logging.LogUtil;
import com.kms.katalon.util.groovy.MethodNodeUtil;
import com.kms.katalon.util.jdt.JdtUtil;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.codehaus.groovy.ast.AnnotationNode;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.jdt.groovy.model.GroovyCompilationUnit;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.JavaCore;

public class ProjectCustomKeywordsParser {
    private ProjectEntity project;

    public ProjectCustomKeywordsParser(ProjectEntity project) {
        this.project = project;
    }

    public ParseResult parseKeywordFile(CustomKeywordFile keywordFile) throws ParseKeywordException {
        try {
            if (!this.project.getFolderLocation().equals(keywordFile.getProject().getFolderLocation())) {
                throw new IllegalArgumentException(MessageFormat.format("Keyword file '{0}' does not belong to project.", keywordFile.getFile().getAbsolutePath()));
            }
            IFolder srcFolder = GroovyUtil.getCustomKeywordSourceFolder((ProjectEntity)keywordFile.getProject());
            IFile iFile = srcFolder.getFile((IPath)new Path(keywordFile.getRelativePath()));
            List<CustomKeywordClass> keywordClasses = this.internallyParseKeywordFile(keywordFile, iFile);
            ParseResult result = new ParseResult();
            result.addKeywordClasses(keywordFile, keywordClasses);
            return result;
        }
        catch (ReadCacheFileException | IOException e) {
            throw new ParseKeywordException(e);
        }
    }

    public ParseResult parseAllKeywordFilesInProject() throws ParseKeywordException {
        try {
            ParseResult result = new ParseResult();
            List iFiles = GroovyUtil.getAllCustomKeywordFiles((ProjectEntity)this.project);
            for (IFile iFile : iFiles) {
                CustomKeywordFile keywordFile = CustomKeywordFile.from(this.project, iFile.getLocation().toFile());
                List<CustomKeywordClass> keywordClasses = this.internallyParseKeywordFile(keywordFile, iFile);
                result.addKeywordClasses(keywordFile, keywordClasses);
            }
            return result;
        }
        catch (Exception e) {
            throw new ParseKeywordException(e);
        }
    }

    public boolean hasCustomKeywords() throws ParseKeywordException {
        try {
            List iFiles = GroovyUtil.getAllCustomKeywordFiles((ProjectEntity)this.project);
            Iterator iterator = iFiles.iterator();
            if (iterator.hasNext()) {
                IFile iFile = (IFile)iterator.next();
                CustomKeywordFile keywordFile = CustomKeywordFile.from(this.project, iFile.getLocation().toFile());
                List<CustomKeywordClass> keywordClasses = this.internallyParseKeywordFile(keywordFile, iFile);
                return !keywordClasses.isEmpty();
            }
        }
        catch (Exception e) {
            throw new ParseKeywordException(e);
        }
        return false;
    }

    private List<CustomKeywordClass> internallyParseKeywordFile(CustomKeywordFile keywordFile, IFile iFile) throws IOException, ReadCacheFileException {
        boolean needsReparsing;
        ParseKeywordCacheFile cacheFile = ParseKeywordCacheFile.getOrCreate(keywordFile);
        ParseKeywordCacheContent cacheContent = cacheFile.getCacheContent();
        boolean needsJavadocParsing = this.isGuiMode() && (cacheContent == null || !cacheContent.isJavadocParsed());
        boolean isCacheOutOfDate = cacheContent != null && this.isCacheOutOfDate(keywordFile, cacheFile);
        boolean bl = needsReparsing = cacheContent == null || isCacheOutOfDate || needsJavadocParsing;
        if (needsReparsing) {
            this.parseKeywordFileAndWriteCache(iFile, keywordFile, cacheFile, needsJavadocParsing);
        }
        return (cacheContent = cacheFile.getCacheContent()) != null ? cacheContent.getKeywordClasses() : new ArrayList<CustomKeywordClass>();
    }

    private boolean isCacheOutOfDate(CustomKeywordFile keywordFile, ParseKeywordCacheFile cacheFile) {
        String parseCacheFileContentHash;
        String keywordFileContentHash = keywordFile.getContentHash();
        return !StringUtils.equals((String)keywordFileContentHash, (String)(parseCacheFileContentHash = cacheFile.getCacheContent().getKeywordFileContentHash()));
    }

    private void parseKeywordFileAndWriteCache(IFile iFile, CustomKeywordFile keywordFile, ParseKeywordCacheFile parseCacheFile, boolean needsJavadocParsing) throws IOException {
        List<CustomKeywordClass> keywordClasses = this.parseIFile(iFile, needsJavadocParsing);
        if (keywordClasses != null) {
            ParseKeywordCacheContent cacheContent = new ParseKeywordCacheContent(keywordFile.getContentHash(), keywordClasses);
            cacheContent.setJavadocParsed(needsJavadocParsing);
            parseCacheFile.writeContent(cacheContent);
        }
    }

    private List<CustomKeywordClass> parseIFile(IFile iFile, boolean needsJavadocParsing) {
        ArrayList<CustomKeywordClass> keywordClasses = new ArrayList<CustomKeywordClass>();
        ICompilationUnit unit = JavaCore.createCompilationUnitFrom((IFile)iFile);
        if (!(unit instanceof GroovyCompilationUnit)) {
            return null;
        }
        GroovyCompilationUnit groovyUnit = (GroovyCompilationUnit)unit;
        for (ClassNode classNode : groovyUnit.getModuleNode().getClasses()) {
            CustomKeywordClass keywordClass = this.parseKeywordClassNode(iFile, classNode, needsJavadocParsing);
            keywordClasses.add(keywordClass);
        }
        return keywordClasses;
    }

    private CustomKeywordClass parseKeywordClassNode(IFile iFile, ClassNode classNode, boolean needsJavadocParsing) {
        CustomKeywordClass keywordClass = new CustomKeywordClass(classNode.getName());
        IProject iProject = iFile.getProject();
        for (MethodNode methodNode : classNode.getMethods()) {
            if (methodNode.getAnnotations() == null) continue;
            for (AnnotationNode annotationNode : methodNode.getAnnotations()) {
                if (!this.isKeywordAnnotationNode(annotationNode)) continue;
                CustomKeywordMethod keywordMethod = this.parseKeywordMethodNode(iProject, methodNode, needsJavadocParsing);
                keywordClass.addKeywordMethod(keywordMethod);
            }
        }
        return keywordClass;
    }

    private boolean isKeywordAnnotationNode(AnnotationNode annotationNode) {
        String annotaionClassNodeName = annotationNode.getClassNode().getName();
        return Keyword.class.getName().equals(annotaionClassNodeName) || Keyword.class.getSimpleName().equals(annotaionClassNodeName);
    }

    private CustomKeywordMethod parseKeywordMethodNode(IProject project, MethodNode methodNode, boolean needsJavadocParsing) {
        CustomKeywordMethod keywordMethod = new CustomKeywordMethod(methodNode.getName());
        Parameter[] parameterArray = methodNode.getParameters();
        int n = parameterArray.length;
        int n2 = 0;
        while (n2 < n) {
            Parameter parameter = parameterArray[n2];
            CustomKeywordParameter keywordParameter = new CustomKeywordParameter(parameter.getName());
            ClassNode classNode = parameter.getType();
            ParameterType paramType = ClassNodeToParamTypeConverter.convert(classNode, true);
            keywordParameter.setType(paramType);
            GroovyParser parser = new GroovyParser(new StringBuilder());
            parser.parse(parameter.getInitialExpression());
            keywordParameter.setInitialExpression(parser.getValue());
            keywordMethod.addParameter(keywordParameter);
            ++n2;
        }
        if (needsJavadocParsing) {
            String javadoc = this.findJavadoc(project, methodNode);
            keywordMethod.setJavadoc(javadoc);
        }
        return keywordMethod;
    }

    private boolean isGuiMode() {
        return ApplicationRunningMode.get() == RunningMode.GUI;
    }

    private String findJavadoc(IProject project, MethodNode methodNode) {
        IMethod method;
        block3: {
            try {
                method = JdtUtil.findMethod((IProject)project, (String)methodNode.getDeclaringClass().getName(), (String)methodNode.getName(), (String[])MethodNodeUtil.getParameterTypes((MethodNode)methodNode));
                if (method != null) break block3;
                return "";
            }
            catch (Exception e) {
                LogUtil.printAndLogError((Throwable)e);
                return "";
            }
        }
        return StringUtils.defaultIfBlank((String)JdtUtil.findJavadoc((IJavaElement)method), (String)"");
    }

    public ProjectEntity getProject() {
        return this.project;
    }

    public static class ParseResult {
        private Map<CustomKeywordFile, List<CustomKeywordClass>> keywordClassLookup = new HashMap<CustomKeywordFile, List<CustomKeywordClass>>();

        private ParseResult() {
        }

        private void addKeywordClasses(CustomKeywordFile keywordFile, List<CustomKeywordClass> keywordClasses) {
            this.keywordClassLookup.put(keywordFile, keywordClasses);
        }

        public List<CustomKeywordFile> getKeywordFiles() {
            return new ArrayList<CustomKeywordFile>(this.keywordClassLookup.keySet());
        }

        public List<CustomKeywordClass> getKeywordClassesByFile(CustomKeywordFile keywordFile) {
            return this.keywordClassLookup.get(keywordFile);
        }
    }
}

