/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.custom.improvement.plugin.parser;

import com.kms.katalon.core.annotation.Keyword;
import com.kms.katalon.core.ast.GroovyParser;
import com.kms.katalon.core.exception.KatalonRuntimeException;
import com.kms.katalon.core.util.internal.JsonUtil;
import com.kms.katalon.custom.improvement.model.CustomKeywordClass;
import com.kms.katalon.custom.improvement.model.CustomKeywordMethod;
import com.kms.katalon.custom.improvement.model.CustomKeywordParameter;
import com.kms.katalon.custom.improvement.model.ParameterType;
import com.kms.katalon.custom.improvement.parser.ClassNodeToParamTypeConverter;
import com.kms.katalon.custom.improvement.plugin.model.KeywordsManifest;
import com.kms.katalon.custom.improvement.plugin.parser.NamingMethodVisitor;
import com.kms.katalon.custom.improvement.util.MethodUtils;
import com.kms.katalon.entity.project.ProjectEntity;
import com.kms.katalon.groovy.util.GroovyUtil;
import com.kms.katalon.logging.LogUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import org.assertj.core.internal.bytebuddy.jar.asm.ClassReader;
import org.assertj.core.internal.bytebuddy.jar.asm.ClassVisitor;
import org.codehaus.groovy.ast.AnnotationNode;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.Parameter;
import org.eclipse.core.runtime.CoreException;

public class CustomKeywordPluginsParser {
    private ProjectEntity project;
    private ClassLoader projectClassLoader;

    public CustomKeywordPluginsParser(ProjectEntity projectEntity) {
        this.project = projectEntity;
        try {
            this.projectClassLoader = GroovyUtil.getProjectClassLoader((ProjectEntity)this.project);
        }
        catch (MalformedURLException | CoreException e) {
            throw new KatalonRuntimeException(e);
        }
    }

    public ParseResult parsePluginFiles(List<File> pluginFiles) throws IOException {
        ParseResult parseResult = new ParseResult();
        for (File pluginFile : pluginFiles) {
            JarFile jar;
            block11: {
                jar = new JarFile(pluginFile);
                try {
                    ZipEntry jsonEntry = jar.getEntry("katalon-plugin.json");
                    if (jsonEntry == null) break block11;
                    InputStreamReader reader = new InputStreamReader(jar.getInputStream(jsonEntry));
                    KeywordsManifest manifest = (KeywordsManifest)JsonUtil.fromJson((Reader)reader, KeywordsManifest.class);
                    ArrayList<CustomKeywordClass> keywordClasses = new ArrayList<CustomKeywordClass>();
                    LinkedHashSet<String> keywords = new LinkedHashSet<String>();
                    keywords.addAll(manifest.getKeywords());
                    for (String keyword : keywords) {
                        Class<?> clazz = null;
                        try {
                            clazz = this.projectClassLoader.loadClass(keyword);
                        }
                        catch (ClassNotFoundException e) {
                            LogUtil.logError((Throwable)e, (String)MessageFormat.format("Could not load class: {0} of custom plugin keyword: {1}", keyword, pluginFile.getName()));
                            continue;
                        }
                        CustomKeywordClass keywordClass = this.parseKeywordClass(clazz, keyword);
                        keywordClasses.add(keywordClass);
                    }
                    parseResult.addKeywordClasses(pluginFile, keywordClasses);
                    List<String> listeners = manifest.getListeners();
                    parseResult.addTestListeners(pluginFile, listeners);
                }
                catch (Exception e) {
                    LogUtil.printAndLogError((Throwable)e);
                    jar.close();
                    continue;
                }
                catch (NoClassDefFoundError e) {
                    try {
                        LogUtil.printAndLogError((Throwable)e);
                        continue;
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                    finally {
                        jar.close();
                    }
                }
            }
            jar.close();
        }
        return parseResult;
    }

    private CustomKeywordClass parseKeywordClass(Class<?> clazz, String keywordName) throws IOException {
        ClassNode classNode = new ClassNode(clazz);
        InputStream stream = this.projectClassLoader.getResourceAsStream(String.valueOf(keywordName.replace('.', '/')) + ".class");
        ClassReader classReader = new ClassReader(stream);
        NamingMethodVisitor visitor = new NamingMethodVisitor(clazz);
        classReader.accept((ClassVisitor)visitor, 4);
        CustomKeywordClass keywordClass = new CustomKeywordClass(classNode.getName());
        for (MethodNode methodNode : classNode.getMethods()) {
            if (methodNode.getAnnotations() == null) continue;
            for (AnnotationNode annotationNode : methodNode.getAnnotations()) {
                if (!this.isKeywordAnnotationNode(annotationNode)) continue;
                CustomKeywordMethod keywordMethod = this.parseKeywordMethodNode(methodNode, visitor);
                keywordClass.addKeywordMethod(keywordMethod);
            }
        }
        return keywordClass;
    }

    private boolean isKeywordAnnotationNode(AnnotationNode annotationNode) {
        String annotaionClassNodeName = annotationNode.getClassNode().getName();
        return Keyword.class.getName().equals(annotaionClassNodeName) || Keyword.class.getSimpleName().equals(annotaionClassNodeName);
    }

    private CustomKeywordMethod parseKeywordMethodNode(MethodNode methodNode, NamingMethodVisitor visitor) {
        CustomKeywordMethod keywordMethod = new CustomKeywordMethod(methodNode.getName());
        String typesClassName = MethodUtils.getParametersDescriptor(methodNode);
        String methodName = String.valueOf(methodNode.getName()) + "#" + typesClassName;
        List<String> paramNames = visitor.getParameterNames(methodName);
        Parameter[] parameters = methodNode.getParameters();
        int i = 0;
        while (i < methodNode.getParameters().length) {
            String paramName = paramNames.get(i);
            CustomKeywordParameter keywordParameter = new CustomKeywordParameter(paramName);
            Parameter parameter = parameters[i];
            ClassNode classNode = parameter.getType();
            ParameterType paramType = ClassNodeToParamTypeConverter.convert(classNode, true);
            keywordParameter.setType(paramType);
            GroovyParser parser = new GroovyParser(new StringBuilder());
            parser.parse(parameter.getInitialExpression());
            keywordParameter.setInitialExpression(parser.getValue());
            keywordMethod.addParameter(keywordParameter);
            ++i;
        }
        return keywordMethod;
    }

    public static class ParseResult {
        private Map<File, List<CustomKeywordClass>> keywordClassLookup = new HashMap<File, List<CustomKeywordClass>>();
        private Map<File, List<String>> testListenerLookup = new HashMap<File, List<String>>();

        private ParseResult() {
        }

        public List<File> getPluginFiles() {
            return new ArrayList<File>(this.keywordClassLookup.keySet());
        }

        public List<CustomKeywordClass> getKeywordClassesByFile(File file) {
            return this.keywordClassLookup.get(file);
        }

        private void addKeywordClasses(File pluginFile, List<CustomKeywordClass> keywordClasses) {
            this.keywordClassLookup.put(pluginFile, keywordClasses);
        }

        public List<String> getTestListenersByFile(File file) {
            return this.testListenerLookup.get(file);
        }

        private void addTestListeners(File pluginFile, List<String> testListeners) {
            this.testListenerLookup.put(pluginFile, testListeners);
        }
    }
}

