/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.dal.fileservice.dataprovider;

import com.kms.katalon.dal.IReportDataProvider;
import com.kms.katalon.dal.exception.DALException;
import com.kms.katalon.dal.fileservice.EntityService;
import com.kms.katalon.dal.fileservice.FileServiceConstant;
import com.kms.katalon.dal.fileservice.manager.FolderFileServiceManager;
import com.kms.katalon.dal.fileservice.manager.ReportFileServiceManager;
import com.kms.katalon.entity.file.FileEntity;
import com.kms.katalon.entity.file.IntegratedFileEntity;
import com.kms.katalon.entity.folder.FolderEntity;
import com.kms.katalon.entity.project.ProjectEntity;
import com.kms.katalon.entity.report.ReportCollectionEntity;
import com.kms.katalon.entity.report.ReportEntity;
import com.kms.katalon.entity.testsuite.TestSuiteCollectionEntity;
import com.kms.katalon.entity.testsuite.TestSuiteEntity;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.FileUtils;

public class ReportFileServiceDataProvider
implements IReportDataProvider {
    public String getTemporaryLogDirectory(FileEntity systemFileEntity) throws DALException {
        File systemFileLogDir = new File(FileServiceConstant.TEMP_DIR, systemFileEntity.getIdForDisplay());
        try {
            ReportFileServiceManager.ensureFolderExist(systemFileLogDir);
            return systemFileLogDir.getAbsolutePath();
        }
        catch (Exception e) {
            throw new DALException(e);
        }
    }

    public String getLogDirectory(TestSuiteEntity testSuite, String executionSessionId) throws Exception {
        File testSuiteLogDir = new File(ReportFileServiceManager.getReportFolderOfTestSuite(testSuite.getProject(), testSuite, executionSessionId));
        ReportFileServiceManager.ensureFolderExist(testSuiteLogDir);
        return testSuiteLogDir.getAbsolutePath();
    }

    public ReportEntity getReportEntity(ProjectEntity project, TestSuiteEntity testSuite, String reportName, String executionSessionId) throws Exception {
        File reportFile;
        String testSuiteReportFolderPath = ReportFileServiceManager.getReportFolderOfTestSuite(project, testSuite, executionSessionId);
        FolderEntity parentFolder = FolderFileServiceManager.getFolder(testSuiteReportFolderPath);
        ReportEntity report = ReportFileServiceManager.getReportEntity(String.valueOf(testSuiteReportFolderPath) + File.separator + reportName);
        if (report == null) {
            report = ReportFileServiceManager.createReportEntity(reportName, parentFolder);
        }
        if ((reportFile = new File(report.getId())).exists()) {
            return report;
        }
        return null;
    }

    public List<ReportEntity> listReportEntities(TestSuiteEntity testSuite, ProjectEntity project) throws Exception {
        ArrayList<ReportEntity> lstReport = new ArrayList<ReportEntity>();
        String reportRootFolderPath = FileServiceConstant.getReportRootFolderLocation(project.getFolderLocation());
        File reportRootFolder = new File(reportRootFolderPath);
        File[] reportFoldersByExecutionIds = reportRootFolder.listFiles();
        if (reportFoldersByExecutionIds != null) {
            File[] fileArray = reportFoldersByExecutionIds;
            int n = reportFoldersByExecutionIds.length;
            int n2 = 0;
            while (n2 < n) {
                File[] reportFolders;
                String testSuiteReportFolderPath;
                File testSuiteReportFolder;
                File reportFolderByExecutionId = fileArray[n2];
                if (reportFolderByExecutionId.isDirectory() && (testSuiteReportFolder = new File(testSuiteReportFolderPath = String.valueOf(reportFolderByExecutionId.getAbsolutePath()) + File.separator + testSuite.getIdForDisplay().substring(FileServiceConstant.TEST_SUITE_ROOT_FOLDER_NAME.length() + 1).replace("/", File.separator))).exists() && testSuiteReportFolder.isDirectory() && (reportFolders = testSuiteReportFolder.listFiles()) != null) {
                    File[] fileArray2 = reportFolders;
                    int n3 = reportFolders.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        ReportEntity report;
                        File reportFolder = fileArray2[n4];
                        if (reportFolder.isDirectory() && (report = ReportFileServiceManager.getReportEntity(reportFolder.getAbsolutePath())) != null) {
                            lstReport.add(report);
                        }
                        ++n4;
                    }
                }
                ++n2;
            }
        }
        return lstReport;
    }

    public List<ReportCollectionEntity> listReportCollectionEntities(TestSuiteCollectionEntity testSuiteCollection, ProjectEntity project) throws Exception {
        ArrayList<ReportCollectionEntity> reports = new ArrayList<ReportCollectionEntity>();
        String reportRootFolderPath = FileServiceConstant.getReportRootFolderLocation(project.getFolderLocation());
        File reportRootFolder = new File(reportRootFolderPath);
        File[] reportFoldersByExecutionIds = reportRootFolder.listFiles();
        if (reportFoldersByExecutionIds != null) {
            File[] fileArray = reportFoldersByExecutionIds;
            int n = reportFoldersByExecutionIds.length;
            int n2 = 0;
            while (n2 < n) {
                File[] reportFolders;
                String testSuiteCollectionReportFolderPath;
                File testSuiteReportFolder;
                File reportFolderByExecutionId = fileArray[n2];
                if (reportFolderByExecutionId.isDirectory() && (testSuiteReportFolder = new File(testSuiteCollectionReportFolderPath = String.valueOf(reportFolderByExecutionId.getAbsolutePath()) + File.separator + testSuiteCollection.getIdForDisplay().substring(FileServiceConstant.TEST_SUITE_ROOT_FOLDER_NAME.length() + 1).replace("/", File.separator))).exists() && testSuiteReportFolder.isDirectory() && (reportFolders = testSuiteReportFolder.listFiles()) != null) {
                    File[] fileArray2 = reportFolders;
                    int n3 = reportFolders.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        ReportCollectionEntity report;
                        File reportFolder = fileArray2[n4];
                        if (reportFolder.isDirectory() && (report = ReportFileServiceManager.getReportCollectionEntity(reportFolder.getAbsolutePath())) != null) {
                            reports.add(report);
                        }
                        ++n4;
                    }
                }
                ++n2;
            }
        }
        return reports;
    }

    public String getEntityPk(ReportEntity report) {
        return report.getLocation();
    }

    public void deleteReport(ReportEntity report) throws Exception {
        FileUtils.deleteDirectory((File)new File(report.getLocation()));
    }

    public ReportEntity getReportEntity(String reportPk) throws Exception {
        return ReportFileServiceManager.getReportEntity(reportPk);
    }

    public ReportEntity updateReport(ReportEntity report) throws Exception {
        EntityService.getInstance().saveIntergratedFolderMetadataEntity((IntegratedFileEntity)report);
        return report;
    }

    public FolderEntity getReportFolder(TestSuiteEntity testSuite, ProjectEntity project, String executionSessionId) throws Exception {
        return FolderFileServiceManager.getFolder(ReportFileServiceManager.getReportFolderOfTestSuite(project, testSuite, executionSessionId));
    }

    private String getReportCollectionEntityLocation(ProjectEntity project, TestSuiteCollectionEntity entity, String executionSessionId) throws DALException {
        try {
            String testSuiteCollectionIdWithoutRoot = entity.getIdForDisplay().substring(FileServiceConstant.TEST_SUITE_ROOT_FOLDER_NAME.length() + 1);
            String reportRootFolderPath = FileServiceConstant.getReportRootFolderLocation(project.getFolderLocation());
            return String.valueOf(reportRootFolderPath) + File.separator + executionSessionId + File.separator + testSuiteCollectionIdWithoutRoot;
        }
        catch (Exception e) {
            throw new DALException(e);
        }
    }

    public ReportCollectionEntity newReportCollectionEntity(ProjectEntity project, TestSuiteCollectionEntity tsEntity, String executionSessionId, String newName) throws DALException {
        try {
            File folder = new File(this.getReportCollectionEntityLocation(project, tsEntity, executionSessionId), newName);
            if (!folder.exists()) {
                folder.mkdirs();
            }
            FolderEntity parentFolder = FolderFileServiceManager.getFolder(folder.getAbsolutePath());
            ReportCollectionEntity reportCollection = new ReportCollectionEntity();
            reportCollection.setTestSuiteCollectionId(tsEntity.getIdForDisplay());
            reportCollection.setName(newName);
            reportCollection.setParentFolder(parentFolder);
            reportCollection.setProject(parentFolder.getProject());
            return reportCollection;
        }
        catch (Exception e) {
            throw new DALException(e);
        }
    }

    public ReportCollectionEntity getReportCollectionEntity(ProjectEntity project, TestSuiteCollectionEntity entity, String executionSessionId, String reportName) throws DALException {
        try {
            FolderEntity parentFolder = FolderFileServiceManager.getFolder(String.valueOf(this.getReportCollectionEntityLocation(project, entity, executionSessionId)) + File.separator + reportName);
            return this.getReportCollectionEntity(String.valueOf(parentFolder.getId()) + File.separator + reportName + ".rp");
        }
        catch (Exception e) {
            throw new DALException(e);
        }
    }

    public ReportCollectionEntity getReportCollectionEntity(String id) throws DALException {
        try {
            ReportCollectionEntity reportCollection = (ReportCollectionEntity)this.getEntityService().getEntityByPath(id);
            FolderEntity parentFolder = FolderFileServiceManager.getFolder(new File(id).getParent());
            reportCollection.setParentFolder(parentFolder);
            reportCollection.setProject(parentFolder.getProject());
            return reportCollection;
        }
        catch (Exception e) {
            throw new DALException(e);
        }
    }

    private EntityService getEntityService() throws DALException {
        try {
            return EntityService.getInstance();
        }
        catch (Exception e) {
            throw new DALException(e);
        }
    }

    public void updateReportCollectionEntity(ReportCollectionEntity collectionReport) throws DALException {
        try {
            this.getEntityService().saveEntity((FileEntity)collectionReport, collectionReport.getId());
        }
        catch (Exception e) {
            throw new DALException(e);
        }
    }

    public void deleteReportCollection(ReportCollectionEntity reportCollection) throws DALException {
        try {
            EntityService.getInstance().deleteEntity((FileEntity)reportCollection);
            FolderFileServiceManager.deleteFolder(reportCollection.getParentFolder());
        }
        catch (Exception e) {
            throw new DALException(e);
        }
    }

    public ReportEntity renameReport(ReportEntity report, String newName) throws DALException {
        try {
            return ReportFileServiceManager.renameReport(report, newName);
        }
        catch (Exception e) {
            throw new DALException(e);
        }
    }

    public ReportCollectionEntity renameCollectionReport(ReportCollectionEntity collectionReport, String newName) throws DALException {
        try {
            return ReportFileServiceManager.renameReportCollection(collectionReport, newName);
        }
        catch (Exception e) {
            throw new DALException(e);
        }
    }
}

