/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.dal.fileservice.dataprovider;

import com.kms.katalon.dal.ISystemFileDataProvider;
import com.kms.katalon.dal.exception.DALException;
import com.kms.katalon.dal.fileservice.manager.EntityFileServiceManager;
import com.kms.katalon.dal.fileservice.manager.FolderFileServiceManager;
import com.kms.katalon.entity.file.FileEntity;
import com.kms.katalon.entity.file.SystemFileEntity;
import com.kms.katalon.entity.folder.FolderEntity;
import com.kms.katalon.entity.project.ProjectEntity;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;

public class SystemFileServiceDataProvider
implements ISystemFileDataProvider {
    public List<FileEntity> getChildren(FolderEntity parentFolder) throws DALException {
        File folder = new File(parentFolder.getLocation());
        if (!folder.exists() || folder.listFiles() == null) {
            return Collections.emptyList();
        }
        ArrayList<FileEntity> listSystemFileEntities = new ArrayList<FileEntity>();
        File[] fileArray = folder.listFiles(EntityFileServiceManager.fileFilter);
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (file.isFile()) {
                SystemFileEntity systemFileEntity = new SystemFileEntity(file);
                systemFileEntity.setParentFolder(parentFolder);
                systemFileEntity.setProject(parentFolder.getProject());
                listSystemFileEntities.add((FileEntity)systemFileEntity);
            } else {
                FolderEntity childFolder = new FolderEntity();
                childFolder.setFolderType(FolderEntity.FolderType.INCLUDE);
                childFolder.setName(file.getName());
                childFolder.setParentFolder(parentFolder);
                childFolder.setProject(parentFolder.getProject());
                listSystemFileEntities.add((FileEntity)childFolder);
            }
            ++n2;
        }
        return listSystemFileEntities;
    }

    public List<SystemFileEntity> getFiles(FolderEntity parentFolder) throws DALException {
        File folder = new File(parentFolder.getLocation());
        if (!folder.exists() || folder.listFiles() == null) {
            return Collections.emptyList();
        }
        ArrayList<SystemFileEntity> listSystemFileEntities = new ArrayList<SystemFileEntity>();
        File[] fileArray = folder.listFiles(EntityFileServiceManager.fileFilter);
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (file.isFile()) {
                SystemFileEntity systemFileEntity = new SystemFileEntity(file);
                systemFileEntity.setParentFolder(parentFolder);
                systemFileEntity.setProject(parentFolder.getProject());
                listSystemFileEntities.add(systemFileEntity);
            }
            ++n2;
        }
        return listSystemFileEntities;
    }

    public SystemFileEntity newFile(String name, String content, FolderEntity parentFolder) throws DALException {
        File file = new File(parentFolder.getId(), name);
        try {
            file.createNewFile();
            FileUtils.write((File)file, (CharSequence)content);
            SystemFileEntity systemFileEntity = new SystemFileEntity(file);
            systemFileEntity.setParentFolder(parentFolder);
            systemFileEntity.setProject(parentFolder.getProject());
            return systemFileEntity;
        }
        catch (IOException e) {
            throw new DALException((Exception)e);
        }
    }

    public void deleteFile(SystemFileEntity systemFileEntity) {
        systemFileEntity.getFile().delete();
    }

    public SystemFileEntity renameFile(String newName, SystemFileEntity systemFileEntity) {
        File newFile = new File(systemFileEntity.getParentFolder().getLocation(), newName);
        systemFileEntity.getFile().renameTo(newFile);
        systemFileEntity.setFile(newFile);
        return systemFileEntity;
    }

    public SystemFileEntity copyFile(SystemFileEntity sourceFileEntity, FolderEntity folderEntity) throws DALException {
        File sourceFile = sourceFileEntity.getFile();
        String newPotentialName = String.valueOf(FilenameUtils.getBaseName((String)sourceFile.getName())) + " - Copy";
        List<FileEntity> currentFeatures = this.getChildren(folderEntity);
        int index = 1;
        while (this.checkNameExist(newPotentialName, currentFeatures)) {
            newPotentialName = String.format("%s %d", newPotentialName, index);
            ++index;
        }
        File newFile = new File(folderEntity.getLocation(), String.valueOf(newPotentialName) + sourceFileEntity.getFileExtension());
        try {
            FileUtils.copyFile((File)sourceFile, (File)newFile);
        }
        catch (IOException e) {
            throw new DALException((Exception)e);
        }
        SystemFileEntity systemFileEntity = new SystemFileEntity(newFile);
        systemFileEntity.setParentFolder(folderEntity);
        systemFileEntity.setProject(folderEntity.getProject());
        return systemFileEntity;
    }

    private boolean checkNameExist(String name, List<FileEntity> currentFeatures) {
        return currentFeatures.stream().filter(f -> {
            String fileName = FilenameUtils.getBaseName((String)f.getName());
            return fileName.equals(name);
        }).findAny().isPresent();
    }

    public FolderEntity copyFolder(FolderEntity folder, FolderEntity destinationFolder) throws DALException {
        String newPotentialName = String.valueOf(FilenameUtils.getBaseName((String)folder.getName())) + " - Copy";
        List<FileEntity> currentFeatures = this.getChildren(destinationFolder);
        int index = 1;
        while (this.checkNameExist(newPotentialName, currentFeatures)) {
            newPotentialName = String.format("%s %d", newPotentialName, index);
            ++index;
        }
        File newFile = new File(destinationFolder.getLocation(), newPotentialName);
        try {
            FileUtils.copyDirectory((File)folder.toFile(), (File)newFile);
        }
        catch (IOException e) {
            throw new DALException((Exception)e);
        }
        FolderEntity newFolder = new FolderEntity();
        newFolder.setName(newPotentialName);
        newFolder.setParentFolder(destinationFolder);
        newFolder.setProject(destinationFolder.getProject());
        return newFolder;
    }

    public SystemFileEntity moveFile(SystemFileEntity systemFile, FolderEntity targetFolder) throws DALException {
        String newPotentialName = FilenameUtils.getBaseName((String)systemFile.getName());
        List<FileEntity> currentFeatures = this.getChildren(targetFolder);
        int index = 1;
        while (this.checkNameExist(newPotentialName, currentFeatures)) {
            newPotentialName = String.format("%s %d", newPotentialName, index);
            ++index;
        }
        File newFile = new File(targetFolder.getLocation(), String.valueOf(newPotentialName) + systemFile.getFileExtension());
        try {
            FileUtils.moveFile((File)systemFile.getFile(), (File)newFile);
        }
        catch (IOException e) {
            throw new DALException((Exception)e);
        }
        SystemFileEntity newSystemFile = new SystemFileEntity(newFile);
        newSystemFile.setParentFolder(targetFolder);
        newSystemFile.setProject(targetFolder.getProject());
        return newSystemFile;
    }

    public FolderEntity moveFolder(FolderEntity folder, FolderEntity destinationFolder) throws DALException {
        String newPotentialName = FilenameUtils.getBaseName((String)folder.getName());
        List<FileEntity> currentFeatures = this.getChildren(destinationFolder);
        int index = 1;
        while (this.checkNameExist(newPotentialName, currentFeatures)) {
            newPotentialName = String.format("%s %d", newPotentialName, index);
            ++index;
        }
        File newFile = new File(destinationFolder.getLocation(), newPotentialName);
        try {
            FileUtils.moveDirectory((File)folder.toFile(), (File)newFile);
        }
        catch (IOException e) {
            throw new DALException((Exception)e);
        }
        FolderEntity newFolder = new FolderEntity();
        newFolder.setName(newPotentialName);
        newFolder.setParentFolder(destinationFolder);
        newFolder.setProject(destinationFolder.getProject());
        return newFolder;
    }

    public SystemFileEntity getSystemFile(String systemFilePath, ProjectEntity projectEntity) throws DALException {
        try {
            File systemFile = new File(systemFilePath);
            SystemFileEntity systemFileEntity = new SystemFileEntity(systemFile);
            systemFileEntity.setParentFolder(FolderFileServiceManager.getFolder(systemFile.getParent()));
            systemFileEntity.setProject(projectEntity);
            return systemFileEntity;
        }
        catch (Exception e) {
            throw new DALException(e);
        }
    }
}

